/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.DynamicBundle;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFromTemplateDialog
extends DialogWrapper {
    private JTextField myNameField;
    private TemplateKindCombo myKindCombo;
    private JPanel myPanel;
    private JLabel myUpDownHint;
    private JLabel myKindLabel;
    private JLabel myNameLabel;
    private ElementCreator myCreator;
    private InputValidator myInputValidator;

    protected CreateFileFromTemplateDialog(@NotNull Project project) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myKindLabel.setLabelFor((Component)((Object)this.myKindCombo));
        this.myKindCombo.registerUpDownHint(this.myNameField);
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.setTemplateKindComponentsVisible(false);
        this.init();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String text;
        boolean canClose;
        if (this.myInputValidator != null && !(canClose = this.myInputValidator.canClose(text = this.myNameField.getText().trim()))) {
            String message;
            String errorText = LangBundle.message((String)"incorrect.name", (Object[])new Object[0]);
            if (this.myInputValidator instanceof InputValidatorEx && (message = ((InputValidatorEx)this.myInputValidator).getErrorText(text)) != null) {
                errorText = message;
            }
            return new ValidationInfo(errorText, (JComponent)this.myNameField);
        }
        return super.doValidate();
    }

    protected JTextField getNameField() {
        return this.myNameField;
    }

    protected TemplateKindCombo getKindCombo() {
        return this.myKindCombo;
    }

    protected JLabel getKindLabel() {
        return this.myKindLabel;
    }

    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    private String getEnteredName() {
        JTextField nameField = this.getNameField();
        String text = nameField.getText().trim();
        nameField.setText(text);
        return text;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        if (this.myCreator != null && this.myCreator.tryCreate(this.getEnteredName()).length == 0) {
            return;
        }
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getNameField();
    }

    public void setTemplateKindComponentsVisible(boolean flag) {
        this.myKindCombo.setVisible(flag);
        this.myKindLabel.setVisible(flag);
        this.myUpDownHint.setVisible(flag);
    }

    public static Builder createDialog(@NotNull Project project) {
        if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            return new NonBlockingPopupBuilderImpl(project);
        }
        CreateFileFromTemplateDialog dialog2 = new CreateFileFromTemplateDialog(project);
        return new BuilderImpl(dialog2, project);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TemplateKindCombo templateKindCombo;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/LangBundle", CreateFileFromTemplateDialog.class).getString("label.project.as.template.name"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKindLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/LangBundle", CreateFileFromTemplateDialog.class).getString("label.file.kind"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setColumns(30);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/LangBundle").getString("tooltip.pressing.up.or.down.arrows.while.in.editor.changes.the.kind"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myKindCombo = templateKindCombo = new TemplateKindCombo();
        jPanel2.add((Component)((Object)templateKindCombo), new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface FileCreator<T> {
        @Nullable
        public T createFile(@NonNls @NotNull String var1, @NonNls @NotNull String var2);

        public @NlsContexts.Command @NotNull String getActionName(@NonNls @NotNull String var1, @NonNls @NotNull String var2);

        public boolean startInWriteAction();
    }

    public static interface Builder {
        public Builder setTitle(@NlsContexts.DialogTitle String var1);

        public Builder setValidator(InputValidator var1);

        public Builder addKind(@NlsContexts.ListItem @NotNull String var1, @Nullable Icon var2, @NonNls @NotNull String var3);

        @Nullable
        public <T extends PsiElement> T show(@NlsContexts.DialogTitle @NotNull String var1, @NonNls @Nullable String var2, @NotNull FileCreator<T> var3);

        public <T extends PsiElement> void show(@NlsContexts.DialogTitle @NotNull String var1, @NonNls @Nullable String var2, @NotNull FileCreator<T> var3, Consumer<? super T> var4);

        @Nullable
        public Map<String, String> getCustomProperties();
    }

    private static class NonBlockingPopupBuilderImpl
    implements Builder {
        @NotNull
        private final Project myProject;
        private String myTitle = "Title";
        private final List<Trinity<String, Icon, String>> myTemplatesList = new ArrayList<Trinity<String, Icon, String>>();
        private InputValidator myInputValidator;

        private NonBlockingPopupBuilderImpl(@NotNull Project project) {
            this.myProject = project;
        }

        @Override
        public Builder setTitle(@Nls String title) {
            this.myTitle = title;
            return this;
        }

        @Override
        public Builder addKind(@Nls @NotNull String kind, @Nullable Icon icon2, @NotNull String templateName) {
            this.myTemplatesList.add((Trinity<String, Icon, String>)Trinity.create((Object)kind, (Object)icon2, (Object)templateName));
            return this;
        }

        @Override
        public Builder setValidator(InputValidator validator) {
            this.myInputValidator = validator;
            return this;
        }

        @Override
        @Nullable
        public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull FileCreator<T> creator) {
            throw new UnsupportedOperationException("Modal dialog is not supported by this builder");
        }

        @Override
        public <T extends PsiElement> void show(@NotNull String errorTitle, @Nullable String selectedItem, final @NotNull FileCreator<T> fileCreator, Consumer<? super T> elementConsumer) {
            final CreateWithTemplatesDialogPanel contentPanel2 = new CreateWithTemplatesDialogPanel(this.myTemplatesList, selectedItem);
            ElementCreator elementCreator = new ElementCreator(this.myProject, errorTitle){

                protected PsiElement[] create(@NotNull String newName) {
                    PsiElement[] psiElementArray;
                    PsiElement element2 = (PsiElement)fileCreator.createFile(contentPanel2.getEnteredName(), contentPanel2.getSelectedTemplate());
                    if (element2 != null) {
                        PsiElement[] psiElementArray2 = new PsiElement[1];
                        psiElementArray = psiElementArray2;
                        psiElementArray2[0] = element2;
                    } else {
                        psiElementArray = PsiElement.EMPTY_ARRAY;
                    }
                    return psiElementArray;
                }

                public boolean startInWriteAction() {
                    return fileCreator.startInWriteAction();
                }

                protected String getActionName(String newName) {
                    return fileCreator.getActionName(newName, contentPanel2.getSelectedTemplate());
                }
            };
            JBPopup popup2 = NewItemPopupUtil.createNewItemPopup(this.myTitle, (JComponent)((Object)contentPanel2), contentPanel2.getNameField());
            contentPanel2.setApplyAction((Consumer<? super InputEvent>)((Consumer)e -> {
                boolean isValid;
                String newElementName = contentPanel2.getEnteredName();
                if (StringUtil.isEmptyOrSpaces((String)newElementName)) {
                    return;
                }
                boolean bl = isValid = this.myInputValidator == null || this.myInputValidator.canClose(newElementName);
                if (isValid) {
                    popup2.closeOk(e);
                    PsiElement createdElement = NonBlockingPopupBuilderImpl.createElement(newElementName, elementCreator);
                    if (createdElement != null) {
                        elementConsumer.consume((Object)createdElement);
                    }
                } else {
                    String errorMessage = Optional.ofNullable(this.myInputValidator).filter(validator -> validator instanceof InputValidatorEx).map(validator -> ((InputValidatorEx)validator).getErrorText(newElementName)).orElse(LangBundle.message((String)"incorrect.name", (Object[])new Object[0]));
                    contentPanel2.setError(errorMessage);
                }
            }));
            Disposer.register((Disposable)popup2, (Disposable)contentPanel2);
            popup2.showCenteredInCurrentWindow(this.myProject);
        }

        @Override
        @Nullable
        public Map<String, String> getCustomProperties() {
            return null;
        }

        @Nullable
        private static PsiElement createElement(String newElementName, ElementCreator creator) {
            PsiElement[] elements2 = creator.tryCreate(newElementName);
            return elements2.length > 0 ? elements2[0] : null;
        }
    }

    private static class BuilderImpl
    implements Builder {
        private final CreateFileFromTemplateDialog myDialog;
        private final Project myProject;

        BuilderImpl(CreateFileFromTemplateDialog dialog2, Project project) {
            this.myDialog = dialog2;
            this.myProject = project;
        }

        @Override
        public Builder setTitle(@NlsContexts.DialogTitle String title) {
            this.myDialog.setTitle(title);
            return this;
        }

        @Override
        public Builder addKind(@Nls @NotNull String name, @Nullable Icon icon2, @NotNull String templateName) {
            this.myDialog.getKindCombo().addItem(name, icon2, templateName);
            if (this.myDialog.getKindCombo().getComboBox().getItemCount() > 1) {
                this.myDialog.setTemplateKindComponentsVisible(true);
            }
            return this;
        }

        @Override
        public Builder setValidator(InputValidator validator) {
            this.myDialog.myInputValidator = validator;
            return this;
        }

        @Override
        public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedTemplateName, final @NotNull FileCreator<T> creator) {
            final Ref created = Ref.create(null);
            this.myDialog.getKindCombo().setSelectedName(selectedTemplateName);
            this.myDialog.myCreator = new ElementCreator(this.myProject, errorTitle){

                protected PsiElement[] create(@NotNull String newName) {
                    PsiElement element2 = (PsiElement)creator.createFile(myDialog.getEnteredName(), myDialog.getKindCombo().getSelectedName());
                    if (element2 != null) {
                        created.set((Object)SmartPointerManager.getInstance((Project)myProject).createSmartPsiElementPointer(element2));
                        return new PsiElement[]{element2};
                    }
                    return PsiElement.EMPTY_ARRAY;
                }

                public boolean startInWriteAction() {
                    return creator.startInWriteAction();
                }

                protected String getActionName(String newName) {
                    return creator.getActionName(newName, myDialog.getKindCombo().getSelectedName());
                }
            };
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)created.get();
                return (T)(pointer == null ? null : pointer.getElement());
            }
            return null;
        }

        @Override
        public <T extends PsiElement> void show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull FileCreator<T> creator, Consumer<? super T> elementConsumer) {
            T element2 = this.show(errorTitle, selectedItem, creator);
            elementConsumer.consume(element2);
        }

        @Override
        @Nullable
        public Map<String, String> getCustomProperties() {
            return null;
        }
    }
}

