/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;

public class CopyAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    public CopyAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        CopyProvider provider = (CopyProvider)PlatformDataKeys.COPY_PROVIDER.getData(dataContext);
        if (provider == null) {
            return;
        }
        provider.performCopy(dataContext);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        CopyProvider provider = (CopyProvider)PlatformDataKeys.COPY_PROVIDER.getData(dataContext);
        presentation2.setEnabled(provider != null && provider.isCopyEnabled(dataContext));
        if (event.getPlace().equals("EditorPopup") && provider != null) {
            presentation2.setVisible(provider.isCopyVisible(dataContext));
        } else {
            presentation2.setVisible(true);
        }
    }
}

