/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseEditorsActionBase;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CloseAllEditorsToTheLeftAction
extends CloseEditorsActionBase {
    @Override
    protected boolean isFileToClose(EditorComposite editor, EditorWindow window) {
        return false;
    }

    @Override
    protected boolean isFileToCloseInContext(DataContext dataContext, EditorComposite candidate, EditorWindow window) {
        VirtualFile contextFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        VirtualFile candidateFile = candidate.getFile();
        if (Comparing.equal((Object)candidateFile, (Object)contextFile)) {
            return false;
        }
        for (EditorWithProviderComposite composite : window.getEditors()) {
            VirtualFile cursorFile = composite.getFile();
            if (!Comparing.equal((Object)cursorFile, (Object)contextFile) && !Comparing.equal((Object)cursorFile, (Object)candidateFile)) continue;
            return this.isOKToClose(contextFile, candidateFile, cursorFile);
        }
        return false;
    }

    protected boolean isOKToClose(VirtualFile contextFile, VirtualFile candidateFile, VirtualFile cursorFile) {
        return Comparing.equal((Object)cursorFile, (Object)candidateFile);
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        int tabPlacement = UISettings.getInstance().getEditorTabPlacement();
        if (tabPlacement == 2 || tabPlacement == 4) {
            event.getPresentation().setText(IdeBundle.messagePointer((String)this.getAlternativeTextKey(), (Object[])new Object[0]));
        }
    }

    protected String getAlternativeTextKey() {
        return "action.close.all.editors.above";
    }

    @Override
    protected String getPresentationText(boolean inSplitter) {
        return IdeBundle.message((String)"action.close.all.editors.to.the.left", (Object[])new Object[0]);
    }
}

