/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.navigation.History;
import org.jetbrains.annotations.NotNull;

public class BackAction
extends AnAction
implements DumbAware {
    public BackAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        History history = (History)e.getData(History.KEY);
        if (history != null) {
            history.back();
        } else if (project != null) {
            IdeDocumentHistory.getInstance(project).back();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        History history = (History)e.getData(History.KEY);
        boolean isModalContext = e.getData(PlatformDataKeys.IS_MODAL_CONTEXT) == Boolean.TRUE;
        Presentation presentation2 = e.getPresentation();
        if (history != null) {
            presentation2.setEnabled(history.canGoBack());
        } else if (project != null && !project.isDisposed()) {
            presentation2.setEnabled(!isModalContext && IdeDocumentHistory.getInstance(project).isBackAvailable());
        } else {
            presentation2.setEnabled(false);
        }
    }
}

