/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class AssociateFileTypeAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        FileTypeChooser.associateFileType(file2.getName());
    }

    public void update(@NotNull AnActionEvent e) {
        boolean haveSmthToDo;
        Presentation presentation2 = e.getPresentation();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        Project project = e.getProject();
        if (project == null || file2 == null || file2.isDirectory()) {
            haveSmthToDo = false;
        } else {
            haveSmthToDo = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence()) == FileTypes.UNKNOWN && !(file2.getFileSystem() instanceof NonPhysicalFileSystem) && !ScratchRootType.getInstance().containsFile(file2);
            haveSmthToDo |= ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        }
        presentation2.setVisible(haveSmthToDo || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
        presentation2.setEnabled(haveSmthToDo);
    }
}

