/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SizedIcon;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActivateToolWindowAction
extends DumbAwareAction {
    private final String myToolWindowId;

    private ActivateToolWindowAction(@NotNull String toolWindowId) {
        this.myToolWindowId = toolWindowId;
    }

    @NotNull
    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    public static void ensureToolWindowActionRegistered(@NotNull ToolWindow toolWindow) {
        String actionId;
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getAction(actionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()));
        if (action2 == null) {
            ActivateToolWindowAction newAction = new ActivateToolWindowAction(toolWindow.getId());
            newAction.updatePresentation(newAction.getTemplatePresentation(), toolWindow);
            actionManager.registerAction(actionId, (AnAction)newAction);
        }
    }

    public static void updateToolWindowActionPresentation(@NotNull ToolWindow toolWindow) {
        AnAction action2 = ActionManager.getInstance().getAction(ActivateToolWindowAction.getActionIdForToolWindow(toolWindow.getId()));
        if (action2 instanceof ActivateToolWindowAction) {
            ((ActivateToolWindowAction)action2).updatePresentation(action2.getTemplatePresentation(), toolWindow);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = ActivateToolWindowAction.getEventProject((AnActionEvent)e);
        Presentation presentation2 = e.getPresentation();
        if (project == null || project.isDisposed()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(this.myToolWindowId);
        if (toolWindow == null) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setVisible(true);
            presentation2.setEnabled(toolWindow.isAvailable());
            this.updatePresentation(presentation2, toolWindow);
        }
    }

    private void updatePresentation(@NotNull Presentation presentation2, @NotNull ToolWindow toolWindow) {
        String title = toolWindow.getStripeTitle();
        presentation2.setText(title);
        presentation2.setDescription(IdeBundle.messagePointer((String)"action.activate.tool.window", (Object[])new Object[]{title}));
        Icon icon2 = toolWindow.getIcon();
        if ("Event Log".equals(this.myToolWindowId)) {
            icon2 = AllIcons.Ide.Notification.InfoEvents;
        }
        presentation2.setIcon((Icon)(icon2 == null ? null : new SizedIcon(icon2, icon2.getIconHeight(), icon2.getIconHeight())));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = ActivateToolWindowAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow window = windowManager.getToolWindow(this.myToolWindowId);
        if (windowManager.isEditorComponentActive() || !this.myToolWindowId.equals(windowManager.getActiveToolWindowId())) {
            window.activate(null);
        } else {
            window.hide(null);
        }
    }

    @NonNls
    @NotNull
    public static String getActionIdForToolWindow(@NotNull String id2) {
        return "Activate" + id2.replaceAll(" ", "") + "ToolWindow";
    }

    public static int getMnemonicForToolWindow(@NotNull String toolWindowId) {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        for (Shortcut shortcut : activeKeymap.getShortcuts(ActivateToolWindowAction.getActionIdForToolWindow(toolWindowId))) {
            int keyCode;
            KeyStroke keyStroke;
            int modifiers;
            if (!(shortcut instanceof KeyboardShortcut) || (modifiers = (keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke()).getModifiers()) != 520 && modifiers != 8 && modifiers != 512 && modifiers != 260 && modifiers != 4 && modifiers != 256 || 48 > (keyCode = keyStroke.getKeyCode()) || keyCode > 57) continue;
            return (char)(48 + keyCode - 48);
        }
        return -1;
    }
}

