/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BitUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ReopenProjectAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private final String myProjectPath;
    private final String myProjectName;
    private boolean myIsRemoved = false;

    public ReopenProjectAction(@NotNull @SystemIndependent String projectPath, String projectName, String displayName) {
        this.myProjectPath = projectPath;
        this.myProjectName = projectName;
        Presentation presentation2 = this.getTemplatePresentation();
        String text = projectPath.equals(displayName) ? FileUtil.getLocationRelativeToUserHome((String)projectPath) : displayName;
        presentation2.setText(text, false);
        presentation2.setDescription(FileUtil.toSystemDependentName((String)projectPath));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        Project project = e.getProject();
        Path file2 = Paths.get(this.myProjectPath, new String[0]).normalize();
        if (!Files.exists(file2, new LinkOption[0])) {
            if (Messages.showDialog((Project)project, (String)IdeBundle.message((String)"message.the.path.0.does.not.exist.maybe.on.remote", (Object[])new Object[]{FileUtil.toSystemDependentName((String)this.myProjectPath)}), (String)IdeBundle.message((String)"dialog.title.reopen.project", (Object[])new Object[0]), (String[])new String[]{"OK", "&Remove From List"}, (int)0, (Icon)Messages.getErrorIcon()) == 1) {
                this.myIsRemoved = true;
                RecentProjectsManager.getInstance().removePath(this.myProjectPath);
            }
            return;
        }
        int modifiers = e.getModifiers();
        boolean forceOpenInNewFrame = BitUtil.isSet((int)modifiers, (int)2) || BitUtil.isSet((int)modifiers, (int)1) || e.getPlace() == "WelcomeScreen" || LightEdit.owns((Project)project);
        RecentProjectsManagerBase.getInstanceEx().openProject(file2, OpenProjectTask.withProjectToClose(project, forceOpenInNewFrame).withRunConfigurators());
    }

    public @SystemIndependent String getProjectPath() {
        return this.myProjectPath;
    }

    public boolean isRemoved() {
        return this.myIsRemoved;
    }

    public String getProjectName() {
        RecentProjectsManager mgr = RecentProjectsManager.getInstance();
        if (mgr instanceof RecentProjectsManagerBase) {
            return ((RecentProjectsManagerBase)mgr).getProjectName(this.myProjectPath);
        }
        return this.myProjectName;
    }

    public @NlsActions.ActionText @Nullable String getTemplateText() {
        return IdeBundle.message((String)"action.ReopenProject.reopen.project.text", (Object[])new Object[0]);
    }
}

