/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.AWTEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ProhibitAWTEvents
implements IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance(ProhibitAWTEvents.class);
    private final String myActivityName;
    private boolean myReported;

    private ProhibitAWTEvents(@NotNull String activityName) {
        this.myActivityName = activityName;
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (!this.myReported) {
            this.myReported = true;
            LOG.error("AWT events are prohibited inside " + this.myActivityName + "; got " + e);
        }
        return true;
    }

    @NotNull
    public static AccessToken start(@NotNull String activityName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return AccessToken.EMPTY_ACCESS_TOKEN;
        }
        final ProhibitAWTEvents dispatcher = new ProhibitAWTEvents(activityName);
        IdeEventQueue.getInstance().addPostprocessor(dispatcher, null);
        return new AccessToken(){

            public void finish() {
                IdeEventQueue.getInstance().removePostprocessor(dispatcher);
            }
        };
    }
}

