/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.actions.RecentProjectsGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

final class ManageRecentProjectsAction
extends DumbAwareAction {
    ManageRecentProjectsAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Disposable disposable2 = Disposer.newDisposable();
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        NewRecentProjectPanel panel2 = new NewRecentProjectPanel(disposable2){

            protected JBList createList(AnAction[] recentProjectActions, Dimension size) {
                return super.createList(RecentProjectsGroup.removeCurrentProject(project, Arrays.asList(recentProjectActions)), size);
            }
        };
        JList list2 = (JList)UIUtil.findComponentOfType((JComponent)panel2, JList.class);
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)list2).setTitle(IdeBundle.message((String)"popup.title.recent.projects", (Object[])new Object[0])).setFocusable(true).setRequestFocus(true).setMayBeParent(true).setMovable(true).setResizable(true).setNormalWindowLevel(true).createPopup();
        Disposer.register((Disposable)popup2, (Disposable)disposable2);
        popup2.showCenteredInCurrentWindow(project);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean enable = project != null && !RecentProjectListActionProvider.getInstance().getActions(false).isEmpty();
        e.getPresentation().setEnabledAndVisible(enable);
    }
}

