/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameStateManagerImpl
extends FrameStateManager {
    private final List<FrameStateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final BusyObject.Impl myActive = new BusyObject.Impl(){

        public boolean isReady() {
            return ApplicationManager.getApplication().isActive();
        }
    };

    FrameStateManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){
            private final FrameStateListener myPublisher = (FrameStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(FrameStateListener.TOPIC);

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                System.setProperty("com.jetbrains.suppressWindowRaise", "false");
                FrameStateManagerImpl.this.myActive.onReady();
                this.myPublisher.onFrameActivated();
                if (ideFrame instanceof IdeFrameImpl) {
                    LifecycleUsageTriggerCollector.onFrameActivated(ideFrame.getProject());
                }
                for (FrameStateListener listener2 : FrameStateManagerImpl.this.myListeners) {
                    listener2.onFrameActivated();
                }
            }

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                System.setProperty("com.jetbrains.suppressWindowRaise", "true");
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                if (ideFrame instanceof IdeFrameImpl) {
                    LifecycleUsageTriggerCollector.onFrameDeactivated(ideFrame.getProject());
                }
                this.myPublisher.onFrameDeactivated();
                for (FrameStateListener listener2 : FrameStateManagerImpl.this.myListeners) {
                    listener2.onFrameDeactivated();
                }
            }
        });
    }

    public ActionCallback getApplicationActive() {
        return this.myActive.getReady((Object)this);
    }

    public void addListener(@NotNull FrameStateListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addListener(@NotNull FrameStateListener listener2, @Nullable Disposable disposable2) {
        if (disposable2 == null) {
            this.myListeners.add(listener2);
        } else {
            ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(FrameStateListener.TOPIC, (Object)listener2);
        }
    }

    public void removeListener(@NotNull FrameStateListener listener2) {
        this.myListeners.remove(listener2);
    }
}

