/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandLineWaitingManager {
    private static final Logger LOG = Logger.getInstance(CommandLineWaitingManager.class);
    private static final String DO_NOT_SHOW_KEY = "command.line.waiting.do.not.show";
    private final Map<Object, CompletableFuture<CliResult>> myFileOrProjectToCallback = Collections.synchronizedMap(new HashMap());
    private final Set<Object> myDismissedObjects = Collections.synchronizedSet(new HashSet());

    private CommandLineWaitingManager() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                CommandLineWaitingManager.this.freeObject(file2);
            }
        });
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                CommandLineWaitingManager.this.freeObject(project);
            }
        });
    }

    @NotNull
    public static CommandLineWaitingManager getInstance() {
        return (CommandLineWaitingManager)ApplicationManager.getApplication().getService(CommandLineWaitingManager.class);
    }

    @NotNull
    public Future<CliResult> addHookForFile(@NotNull VirtualFile file2) {
        return this.addHookAndNotify(file2, IdeBundle.message((String)"activation.file.is.waiting.notification", (Object[])new Object[]{file2.getPath()}));
    }

    @NotNull
    public Future<CliResult> addHookForProject(@NotNull Project project) {
        return this.addHookAndNotify(project, IdeBundle.message((String)"activation.project.is.waiting.notification", (Object[])new Object[]{project.getName()}));
    }

    @NotNull
    private Future<CliResult> addHookAndNotify(@NotNull Object fileOrProject, @NotNull String notificationText) {
        LOG.info(notificationText);
        CompletableFuture<CliResult> result2 = new CompletableFuture<CliResult>();
        this.myFileOrProjectToCallback.put(fileOrProject, result2);
        Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.activated.from.command.line", (Object[])new Object[0]), notificationText, NotificationType.WARNING).setImportant(true));
        EditorNotifications.updateAll();
        return result2;
    }

    public boolean hasHookFor(@NotNull VirtualFile file2) {
        return this.myFileOrProjectToCallback.containsKey(file2);
    }

    private void freeObject(@NotNull Object fileOrProject) {
        this.myDismissedObjects.remove(fileOrProject);
        CompletableFuture<CliResult> future2 = this.myFileOrProjectToCallback.remove(fileOrProject);
        if (future2 == null) {
            return;
        }
        future2.complete(CliResult.OK);
    }

    private static final class MyNotificationPanel
    extends EditorNotificationPanel {
        private MyNotificationPanel(@NotNull VirtualFile virtualFile) {
            super(EditorColors.GUTTER_BACKGROUND);
            this.setText(IdeBundle.message((String)"activation.file.is.waiting.title", (Object[])new Object[0]));
            this.createActionLabel(IdeBundle.message((String)"activation.file.is.waiting.release", (Object[])new Object[0]), () -> {
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (document != null) {
                        FileDocumentManager.getInstance().saveDocument(document);
                    } else {
                        FileDocumentManager.getInstance().saveAllDocuments();
                    }
                });
                CommandLineWaitingManager.getInstance().freeObject(virtualFile);
                EditorNotifications.updateAll();
            });
            this.createActionLabel(IdeBundle.message((String)"activation.file.is.waiting.do.not.show", (Object[])new Object[0]), () -> {
                PropertiesComponent.getInstance().setValue(CommandLineWaitingManager.DO_NOT_SHOW_KEY, true);
                EditorNotifications.updateAll();
            });
            this.createActionLabel(IdeBundle.message((String)"activation.file.is.waiting.dismiss", (Object[])new Object[0]), () -> {
                CommandLineWaitingManager.getInstance().myDismissedObjects.add(virtualFile);
                EditorNotifications.updateAll();
            });
        }
    }

    static final class MyNotification
    extends EditorNotifications.Provider<EditorNotificationPanel> {
        private static final Key<EditorNotificationPanel> KEY = Key.create((String)"CommandLineWaitingNotification");

        MyNotification() {
        }

        @NotNull
        public Key<EditorNotificationPanel> getKey() {
            return KEY;
        }

        @Nullable
        public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
            CommandLineWaitingManager manager;
            if (!PropertiesComponent.getInstance().getBoolean(CommandLineWaitingManager.DO_NOT_SHOW_KEY, false) && (manager = (CommandLineWaitingManager)ApplicationManager.getApplication().getServiceIfCreated(CommandLineWaitingManager.class)) != null && manager.hasHookFor(file2) && !manager.myDismissedObjects.contains(file2)) {
                return new MyNotificationPanel(file2);
            }
            return null;
        }
    }
}

