/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.State;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationActivationStateManager {
    private static final Logger LOG = Logger.getInstance(ApplicationActivationStateManager.class);
    private static final AtomicLong requestToDeactivateTime = new AtomicLong(System.currentTimeMillis());
    private static State state = State.DEACTIVATED;

    private ApplicationActivationStateManager() {
    }

    public static boolean isInactive() {
        return state.isInactive();
    }

    public static boolean isActive() {
        return state.isActive();
    }

    public static boolean updateState(final @NotNull WindowEvent windowEvent) {
        final Application app = ApplicationManager.getApplication();
        if (!(app instanceof ApplicationImpl)) {
            return false;
        }
        if (windowEvent.getID() == 205 || windowEvent.getID() == 207) {
            if (state.isInactive()) {
                return ApplicationActivationStateManager.setActive(app, windowEvent.getWindow());
            }
        } else if (windowEvent.getID() == 206 && windowEvent.getOppositeWindow() == null) {
            IdeFrame ideFrame;
            requestToDeactivateTime.getAndSet(System.currentTimeMillis());
            if (state.isActive() && !app.isDisposed() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(windowEvent.getWindow())) != null) {
                ((ApplicationActivationListener)app.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).applicationDeactivated(ideFrame);
            }
            state = State.DEACTIVATING;
            LOG.debug("The app is in the deactivating state");
            Timer timer2 = TimerUtil.createNamedTimer((String)"ApplicationDeactivation", (int)Registry.intValue((String)"application.deactivation.timeout", (int)1500), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (state == State.DEACTIVATING) {
                        IdeFrame ideFrame;
                        state = State.DEACTIVATED;
                        LOG.debug("The app is in the deactivated state");
                        if (!app.isDisposed() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(windowEvent.getWindow())) != null) {
                            ((ApplicationActivationListener)app.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).delayedApplicationDeactivated((Window)ideFrame);
                        }
                    }
                }
            });
            timer2.setRepeats(false);
            timer2.start();
            return true;
        }
        return false;
    }

    private static boolean setActive(@NotNull Application app, @Nullable Window window) {
        IdeFrame ideFrame;
        state = State.ACTIVE;
        LOG.debug("The app is in the active state");
        if (!app.isDisposed() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(window)) != null) {
            ((ApplicationActivationListener)app.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).applicationActivated(ideFrame);
            return true;
        }
        return false;
    }

    public static void updateState(@NotNull ApplicationImpl app, @NotNull Window window) {
        if (state.isInactive()) {
            ApplicationActivationStateManager.setActive(app, window);
        }
    }

    @Nullable
    private static IdeFrame getIdeFrameFromWindow(@Nullable Window window) {
        Component frame = window == null ? null : ComponentUtil.findUltimateParent((Component)window);
        return frame instanceof IdeFrame ? (IdeFrame)frame : null;
    }
}

