/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ByteContent;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryException;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryEventDispatcher;
import com.intellij.history.integration.LocalHistoryUtil;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalHistoryImpl
extends LocalHistory
implements Disposable {
    private MessageBusConnection myConnection;
    private ChangeList myChangeList;
    private LocalHistoryFacade myVcs;
    private IdeaGateway myGateway;
    private LocalHistoryEventDispatcher myEventDispatcher;
    private final AtomicBoolean isInitialized = new AtomicBoolean();

    @NotNull
    public static LocalHistoryImpl getInstanceImpl() {
        return (LocalHistoryImpl)LocalHistoryImpl.getInstance();
    }

    public LocalHistoryImpl() {
        this.init();
    }

    private void init() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isHeadlessEnvironment()) {
            return;
        }
        PersistentFS instance = PersistentFS.getInstance();
        ShutDownTracker.getInstance().registerShutdownTask(() -> this.doDispose());
        this.initHistory();
        this.isInitialized.set(true);
    }

    private void initHistory() {
        ChangeListStorage storage;
        try {
            storage = new ChangeListStorageImpl(LocalHistoryImpl.getStorageDir());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage = new InMemoryChangeListStorage();
        }
        this.myChangeList = new ChangeList(storage);
        this.myVcs = new LocalHistoryFacade(this.myChangeList);
        this.myGateway = new IdeaGateway();
        this.myEventDispatcher = new LocalHistoryEventDispatcher(this.myVcs, this.myGateway);
        this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myEventDispatcher);
        this.myConnection.subscribe(CommandListener.TOPIC, (Object)this.myEventDispatcher);
        VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)this.myEventDispatcher, (Disposable)this);
    }

    @NotNull
    public static File getStorageDir() {
        return new File(LocalHistoryImpl.getSystemPath(), "LocalHistory");
    }

    private static String getSystemPath() {
        return PathManager.getSystemPath();
    }

    public void dispose() {
        this.doDispose();
    }

    private void doDispose() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        long period = (long)Registry.intValue((String)"localHistory.daysToKeep") * 1000L * 60L * 60L * 24L;
        this.myConnection.disconnect();
        this.myConnection = null;
        LocalHistoryLog.LOG.debug("Purging local history...");
        this.myChangeList.purgeObsolete(period);
        this.myChangeList.close();
        LocalHistoryLog.LOG.debug("Local history storage successfully closed.");
    }

    public void cleanupForNextTest() {
        this.doDispose();
        FileUtil.delete((File)LocalHistoryImpl.getStorageDir());
        this.init();
    }

    public LocalHistoryAction startAction(String name) {
        if (!this.isInitialized()) {
            return LocalHistoryAction.NULL;
        }
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.myEventDispatcher, name);
        a.start();
        return a;
    }

    public Label putUserLabel(Project p, @NotNull String name) {
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putUserLabel(name, LocalHistoryImpl.getProjectId(p)));
    }

    private static String getProjectId(Project p) {
        return p.getLocationHash();
    }

    public Label putSystemLabel(Project p, @NotNull String name, int color) {
        if (!this.isInitialized()) {
            return Label.NULL_INSTANCE;
        }
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        return this.label(this.myVcs.putSystemLabel(name, LocalHistoryImpl.getProjectId(p), color));
    }

    @ApiStatus.Internal
    public void addVFSListenerAfterLocalHistoryOne(BulkFileListener virtualFileListener, Disposable disposable2) {
        this.myEventDispatcher.addVirtualFileListener(virtualFileListener, disposable2);
    }

    private Label label(final LabelImpl impl) {
        return new Label(){

            public void revert(@NotNull Project project, @NotNull VirtualFile file2) throws LocalHistoryException {
                LocalHistoryImpl.this.revertToLabel(project, file2, impl);
            }

            public ByteContent getByteContent(String path) {
                return (ByteContent)ReadAction.compute(() -> impl.getByteContent(LocalHistoryImpl.this.myGateway.createTransientRootEntryForPathOnly(path), path));
            }
        };
    }

    public byte @Nullable [] getByteContent(VirtualFile f, FileRevisionTimestampComparator c) {
        if (!this.isInitialized()) {
            return null;
        }
        if (!this.myGateway.areContentChangesVersioned(f)) {
            return null;
        }
        return (byte[])ReadAction.compute(() -> new ByteContentRetriever(this.myGateway, this.myVcs, f, c).getResult());
    }

    public boolean isUnderControl(@NotNull VirtualFile f) {
        return this.isInitialized() && this.myGateway.isVersioned(f);
    }

    private boolean isInitialized() {
        return this.isInitialized.get();
    }

    @Nullable
    public LocalHistoryFacade getFacade() {
        return this.myVcs;
    }

    @Nullable
    public IdeaGateway getGateway() {
        return this.myGateway;
    }

    private void revertToLabel(@NotNull Project project, @NotNull VirtualFile f, @NotNull LabelImpl impl) throws LocalHistoryException {
        HistoryDialogModel dirHistoryModel = f.isDirectory() ? new DirectoryHistoryDialogModel(project, this.myGateway, this.myVcs, f) : new EntireFileHistoryDialogModel(project, this.myGateway, this.myVcs, f);
        int leftRev = LocalHistoryUtil.findRevisionIndexToRevert(dirHistoryModel, impl);
        if (leftRev < 0) {
            throw new LocalHistoryException("Couldn't find label revision");
        }
        if (leftRev == 0) {
            return;
        }
        try {
            dirHistoryModel.selectRevisions(-1, leftRev - 1);
            dirHistoryModel.createReverter().revert();
        }
        catch (Exception e) {
            throw new LocalHistoryException(String.format("Couldn't revert %s to local history label.", f.getName()), (Throwable)e);
        }
    }
}

