/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalHistoryEventDispatcher
implements VirtualFileManagerListener,
CommandListener,
BulkFileListener {
    private static final Key<Boolean> WAS_VERSIONED_KEY = Key.create((String)(LocalHistoryEventDispatcher.class.getSimpleName() + ".WAS_VERSIONED_KEY"));
    private final LocalHistoryFacade myVcs;
    private final IdeaGateway myGateway;
    private final DisposableWrapperList<BulkFileListener> myVfsEventListeners = new DisposableWrapperList();

    LocalHistoryEventDispatcher(LocalHistoryFacade vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
    }

    public void beforeRefreshStart(boolean asynchronous) {
        this.beginChangeSet();
    }

    public void afterRefreshFinish(boolean asynchronous) {
        this.endChangeSet(LocalHistoryBundle.message("system.label.external.change", new Object[0]));
    }

    public void commandStarted(@NotNull CommandEvent e) {
        this.beginChangeSet();
    }

    public void commandFinished(@NotNull CommandEvent e) {
        this.endChangeSet(e.getCommandName());
    }

    void startAction() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.myVcs.forceBeginChangeSet();
    }

    void finishAction(String name) {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.endChangeSet(name);
    }

    private void beginChangeSet() {
        this.myVcs.beginChangeSet();
    }

    private void endChangeSet(String name) {
        this.myVcs.endChangeSet(name);
    }

    private void fileCreated(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return;
        }
        this.beginChangeSet();
        this.createRecursively(file2);
        this.endChangeSet(null);
    }

    private void createRecursively(VirtualFile f) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile f) {
                if (LocalHistoryEventDispatcher.this.isVersioned(f)) {
                    LocalHistoryEventDispatcher.this.myVcs.created(f.getPath(), f.isDirectory());
                }
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                return LocalHistoryEventDispatcher.this.myGateway.isVersioned(f, true) ? IdeaGateway.loadAndIterateChildren(f) : IdeaGateway.iterateDBChildren(f);
            }
        });
    }

    private void beforeContentsChange(@NotNull VFileContentChangeEvent e) {
        VirtualFile f = e.getFile();
        if (!this.myGateway.areContentChangesVersioned(f)) {
            return;
        }
        Pair<StoredContent, Long> content2 = this.myGateway.acquireAndUpdateActualContent(f, null);
        if (content2 != null) {
            this.myVcs.contentChanged(f.getPath(), (Content)content2.first, (Long)content2.second);
        }
    }

    private void handleBeforeEvent(VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            this.beforeContentsChange((VFileContentChangeEvent)event);
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename() || event instanceof VFileMoveEvent) {
            VirtualFile f = Objects.requireNonNull(event.getFile());
            f.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f));
        } else if (event instanceof VFileDeleteEvent) {
            this.beforeFileDeletion((VFileDeleteEvent)event);
        }
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent e) {
        if (e.isRename()) {
            VirtualFile f = e.getFile();
            boolean isVersioned = this.myGateway.isVersioned(f);
            Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
            if (wasVersioned == null) {
                return;
            }
            f.putUserData(WAS_VERSIONED_KEY, null);
            if (!wasVersioned.booleanValue() && !isVersioned) {
                return;
            }
            String oldName = (String)e.getOldValue();
            this.myVcs.renamed(f.getPath(), oldName);
        } else if ("writable".equals(e.getPropertyName())) {
            if (!this.isVersioned(e.getFile())) {
                return;
            }
            VirtualFile f = e.getFile();
            if (!f.isDirectory()) {
                this.myVcs.readOnlyStatusChanged(f.getPath(), (Boolean)e.getOldValue() == false);
            }
        }
    }

    private void fileMoved(@NotNull VFileMoveEvent e) {
        VirtualFile f = e.getFile();
        boolean isVersioned = this.myGateway.isVersioned(f);
        Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
        if (wasVersioned == null) {
            return;
        }
        f.putUserData(WAS_VERSIONED_KEY, null);
        if (!wasVersioned.booleanValue() && !isVersioned) {
            return;
        }
        this.myVcs.moved(f.getPath(), e.getOldParent().getPath());
    }

    private void beforeFileDeletion(@NotNull VFileDeleteEvent e) {
        VirtualFile f = e.getFile();
        Entry entry = this.myGateway.createEntryForDeletion(f);
        if (entry != null) {
            this.myVcs.deleted(f.getPath(), entry);
        }
    }

    private boolean isVersioned(VirtualFile f) {
        return this.myGateway.isVersioned(f);
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        this.myGateway.runWithVfsEventsDispatchContext(events, true, () -> {
            for (VFileEvent event : events) {
                this.handleBeforeEvent(event);
            }
            for (BulkFileListener listener2 : this.myVfsEventListeners) {
                listener2.before(events);
            }
        });
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        this.myGateway.runWithVfsEventsDispatchContext(events, false, () -> {
            for (VFileEvent event : events) {
                this.handleAfterEvent(event);
            }
            for (BulkFileListener listener2 : this.myVfsEventListeners) {
                listener2.after(events);
            }
        });
    }

    private void handleAfterEvent(VFileEvent event) {
        if (event instanceof VFileCreateEvent) {
            this.fileCreated(event.getFile());
        } else if (event instanceof VFileCopyEvent) {
            this.fileCreated(((VFileCopyEvent)event).findCreatedFile());
        } else if (event instanceof VFilePropertyChangeEvent) {
            this.propertyChanged((VFilePropertyChangeEvent)event);
        } else if (event instanceof VFileMoveEvent) {
            this.fileMoved((VFileMoveEvent)event);
        }
    }

    void addVirtualFileListener(BulkFileListener virtualFileListener, Disposable disposable2) {
        this.myVfsEventListeners.add((Object)virtualFileListener, disposable2);
    }
}

