/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGateway {
    private static final Key<ContentAndTimestamps> SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY = Key.create((String)"LocalHistory.SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY");
    private static final ThreadLocal<VfsEventDispatchContext> ourCurrentEventDispatchContext = new ThreadLocal();

    public boolean isVersioned(@NotNull VirtualFile f) {
        return this.isVersioned(f, false);
    }

    public boolean isVersioned(@NotNull VirtualFile f, boolean shouldBeInContent) {
        CharSequence fileName;
        if (!f.isInLocalFileSystem()) {
            return false;
        }
        if (!f.isDirectory() && (StringUtil.equals((CharSequence)(fileName = f.getNameSequence()), (CharSequence)"workspace.xml") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".iws") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".class"))) {
            return false;
        }
        VersionedFilterData versionedFilterData = IdeaGateway.getVersionedFilterData();
        int numberOfOpenProjects = versionedFilterData.myOpenedProjects.size();
        if (numberOfOpenProjects == 0) {
            if (shouldBeInContent) {
                return false;
            }
            return !FileTypeManager.getInstance().isFileIgnored(f);
        }
        boolean isExcludedFromAll = true;
        boolean isInContent = false;
        for (int i2 = 0; i2 < numberOfOpenProjects; ++i2) {
            ProjectFileIndex index = versionedFilterData.myProjectFileIndices.get(i2);
            if (index.isUnderIgnored(f)) {
                return false;
            }
            isInContent |= index.isInContent(f);
            isExcludedFromAll &= index.isExcluded(f);
        }
        if (isExcludedFromAll) {
            return false;
        }
        return !shouldBeInContent || isInContent;
    }

    @NotNull
    protected static VersionedFilterData getVersionedFilterData() {
        VersionedFilterData versionedFilterData;
        VfsEventDispatchContext vfsEventDispatchContext = ourCurrentEventDispatchContext.get();
        if (vfsEventDispatchContext != null) {
            versionedFilterData = vfsEventDispatchContext.myFilterData;
            if (versionedFilterData == null) {
                versionedFilterData = vfsEventDispatchContext.myFilterData = new VersionedFilterData();
            }
        } else {
            versionedFilterData = new VersionedFilterData();
        }
        return versionedFilterData;
    }

    public void runWithVfsEventsDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents, Runnable action2) {
        try (VfsEventDispatchContext ignored = new VfsEventDispatchContext(events, beforeEvents);){
            action2.run();
        }
    }

    public boolean areContentChangesVersioned(@NotNull VirtualFile f) {
        return this.isVersioned(f) && !f.isDirectory() && (this.areContentChangesVersioned(f.getName()) || ScratchFileService.findRootType((VirtualFile)f) != null);
    }

    public boolean areContentChangesVersioned(@NotNull String fileName) {
        return !FileTypeManager.getInstance().getFileTypeByFileName(fileName).isBinary();
    }

    public boolean ensureFilesAreWritable(@NotNull Project p, @NotNull List<? extends VirtualFile> ff) {
        ReadonlyStatusHandler h = ReadonlyStatusHandler.getInstance((Project)p);
        return !h.ensureFilesWritable(ff).hasReadonlyFiles();
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path) {
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
        if (file2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path);
        }
        return file2;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) throws IOException {
        VirtualFile f = parent.findChild(name);
        if (f != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        return f;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull String path, boolean isDirectory) throws IOException {
        VirtualFile f = this.findVirtualFile(path);
        if (f != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path), true);
            String name = Paths.getNameOf(path);
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        return f;
    }

    public List<VirtualFile> getAllFilesFrom(@NotNull String path) {
        VirtualFile f = this.findVirtualFile(path);
        if (f == null) {
            return Collections.emptyList();
        }
        return IdeaGateway.collectFiles(f, new ArrayList<VirtualFile>());
    }

    @NotNull
    private static List<VirtualFile> collectFiles(@NotNull VirtualFile f, @NotNull List<VirtualFile> result2) {
        if (f.isDirectory()) {
            for (VirtualFile child2 : IdeaGateway.iterateDBChildren(f)) {
                IdeaGateway.collectFiles(child2, result2);
            }
        } else {
            result2.add(f);
        }
        return result2;
    }

    @NotNull
    public static Iterable<VirtualFile> iterateDBChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            return Collections.emptyList();
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        return nf.iterInDbChildrenWithoutLoadingVfsFromOtherProjects();
    }

    @NotNull
    public static Iterable<VirtualFile> loadAndIterateChildren(VirtualFile f) {
        if (!(f instanceof NewVirtualFile)) {
            return Collections.emptyList();
        }
        NewVirtualFile nf = (NewVirtualFile)f;
        return Arrays.asList(nf.getChildren());
    }

    @NotNull
    public RootEntry createTransientRootEntry() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false);
        return root;
    }

    @NotNull
    public RootEntry createTransientRootEntryForPathOnly(@NotNull String path) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootEntry root = new RootEntry();
        this.doCreateChildrenForPathOnly(root, path, IdeaGateway.getLocalRoots());
        return root;
    }

    private static List<VirtualFile> getLocalRoots() {
        return Arrays.asList(ManagingFS.getInstance().getLocalRoots());
    }

    private void doCreateChildrenForPathOnly(@NotNull DirectoryEntry parent, @NotNull String path, @NotNull Iterable<? extends VirtualFile> children2) {
        for (VirtualFile virtualFile : children2) {
            Entry e;
            String rest;
            String name = StringUtil.trimStart((String)virtualFile.getName(), (String)"/");
            if (!path.startsWith(name) || !(rest = path.substring(name.length())).isEmpty() && rest.charAt(0) != '/') continue;
            if (!rest.isEmpty() && rest.charAt(0) == '/') {
                rest = rest.substring(1);
            }
            if ((e = this.doCreateEntryForPathOnly(virtualFile, rest)) == null) continue;
            parent.addChild(e);
        }
    }

    @Nullable
    private Entry doCreateEntryForPathOnly(@NotNull VirtualFile file2, @NotNull String path) {
        if (!file2.isDirectory()) {
            if (!this.isVersioned(file2)) {
                return null;
            }
            return this.doCreateFileEntry(file2, IdeaGateway.getActualContentNoAcquire(file2));
        }
        DirectoryEntry newDir = new DirectoryEntry(file2.getName());
        this.doCreateChildrenForPathOnly(newDir, path, IdeaGateway.iterateDBChildren(file2));
        if (!this.isVersioned(file2) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @Nullable
    public Entry createTransientEntry(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file2, false);
    }

    @Nullable
    public Entry createEntryForDeletion(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.doCreateEntry(file2, true);
    }

    @Nullable
    private Entry doCreateEntry(@NotNull VirtualFile file2, boolean forDeletion) {
        int nameId;
        if (!file2.isDirectory()) {
            Pair<StoredContent, Long> contentAndStamps;
            if (!this.isVersioned(file2)) {
                return null;
            }
            if (forDeletion) {
                FileDocumentManager m = FileDocumentManager.getInstance();
                Document d = m.isFileModified(file2) ? m.getCachedDocument(file2) : null;
                contentAndStamps = this.acquireAndClearCurrentContent(file2, d);
            } else {
                contentAndStamps = IdeaGateway.getActualContentNoAcquire(file2);
            }
            return this.doCreateFileEntry(file2, contentAndStamps);
        }
        DirectoryEntry newDir = null;
        if (file2 instanceof VirtualFileSystemEntry && (nameId = ((VirtualFileSystemEntry)file2).getNameId()) > 0) {
            newDir = new DirectoryEntry(nameId);
        }
        if (newDir == null) {
            newDir = new DirectoryEntry(file2.getName());
        }
        this.doCreateChildren(newDir, IdeaGateway.iterateDBChildren(file2), forDeletion);
        if (!this.isVersioned(file2) && newDir.getChildren().isEmpty()) {
            return null;
        }
        return newDir;
    }

    @NotNull
    private Entry doCreateFileEntry(@NotNull VirtualFile file2, Pair<StoredContent, Long> contentAndStamps) {
        if (file2 instanceof VirtualFileSystemEntry) {
            return new FileEntry(((VirtualFileSystemEntry)file2).getNameId(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file2.isWritable());
        }
        return new FileEntry(file2.getName(), (Content)contentAndStamps.first, (long)((Long)contentAndStamps.second), !file2.isWritable());
    }

    private void doCreateChildren(@NotNull DirectoryEntry parent, Iterable<? extends VirtualFile> children2, boolean forDeletion) {
        List entries = ContainerUtil.mapNotNull(children2, (Function)((NullableFunction)each -> this.doCreateEntry((VirtualFile)each, forDeletion)));
        parent.addChildren(entries);
    }

    public void registerUnsavedDocuments(@NotNull LocalHistoryFacade vcs) {
        ApplicationManager.getApplication().runReadAction(() -> {
            vcs.beginChangeSet();
            for (Document d : FileDocumentManager.getInstance().getUnsavedDocuments()) {
                VirtualFile f = IdeaGateway.getFile(d);
                if (!this.shouldRegisterDocument(f)) continue;
                this.registerDocumentContents(vcs, f, d);
            }
            vcs.endChangeSet(null);
        });
    }

    private boolean shouldRegisterDocument(@Nullable VirtualFile f) {
        return f != null && f.isValid() && this.areContentChangesVersioned(f);
    }

    private void registerDocumentContents(@NotNull LocalHistoryFacade vcs, @NotNull VirtualFile f, Document d) {
        Pair<StoredContent, Long> contentAndStamp = this.acquireAndUpdateActualContent(f, d);
        if (contentAndStamp != null) {
            vcs.contentChanged(f.getPath(), (Content)contentAndStamp.first, (Long)contentAndStamp.second);
        }
    }

    @Nullable
    public Pair<StoredContent, Long> acquireAndUpdateActualContent(@NotNull VirtualFile f, @Nullable Document d) {
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        if (contentAndStamp == null) {
            if (d != null) {
                IdeaGateway.saveDocumentContent(f, d);
            }
            return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        }
        if (d == null) {
            f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
            return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
        }
        if (d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        IdeaGateway.saveDocumentContent(f, d);
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    private static void saveDocumentContent(@NotNull VirtualFile f, @NotNull Document d) {
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, (Object)new ContentAndTimestamps(Clock.getTime(), StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), d.getModificationStamp()));
    }

    @NotNull
    public Pair<StoredContent, Long> acquireAndClearCurrentContent(@NotNull VirtualFile f, @Nullable Document d) {
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d != null && contentAndStamp != null && d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
        }
        if (contentAndStamp != null) {
            contentAndStamp.content.release();
        }
        if (d != null) {
            return Pair.create((Object)StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), (Object)Clock.getTime());
        }
        return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
    }

    @NotNull
    private static Pair<StoredContent, Long> getActualContentNoAcquire(@NotNull VirtualFile f) {
        ContentAndTimestamps result2 = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        if (result2 == null) {
            return Pair.create((Object)StoredContent.transientContent(f), (Object)f.getTimeStamp());
        }
        return Pair.create((Object)result2.content, (Object)result2.registeredTimestamp);
    }

    private static byte[] bytesFromDocument(@NotNull Document d) {
        VirtualFile file2 = IdeaGateway.getFile(d);
        Charset charset = file2 != null ? file2.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return d.getText().getBytes(charset);
    }

    public String stringFromBytes(byte @NotNull [] bytes, @NotNull String path) {
        VirtualFile file2 = this.findVirtualFile(path);
        Charset charset = file2 != null ? file2.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    public void saveAllUnsavedDocuments() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Document d) {
        return FileDocumentManager.getInstance().getFile(d);
    }

    @Nullable
    public Document getDocument(@NotNull String path) {
        return FileDocumentManager.getInstance().getDocument(this.findVirtualFile(path));
    }

    @NotNull
    public FileType getFileType(@NotNull String fileName) {
        return FileTypeManager.getInstance().getFileTypeByFileName(fileName);
    }

    private static class ContentAndTimestamps {
        long registeredTimestamp;
        StoredContent content;
        long documentModificationStamp;

        private ContentAndTimestamps(long registeredTimestamp, StoredContent content2, long documentModificationStamp) {
            this.registeredTimestamp = registeredTimestamp;
            this.content = content2;
            this.documentModificationStamp = documentModificationStamp;
        }
    }

    private static class VersionedFilterData {
        final List<Project> myOpenedProjects = new ArrayList<Project>();
        final List<ProjectFileIndex> myProjectFileIndices = new ArrayList<ProjectFileIndex>();

        VersionedFilterData() {
            Project[] openProjects;
            for (Project each : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (each.isDefault() || !each.isInitialized()) continue;
                this.myOpenedProjects.add(each);
                this.myProjectFileIndices.add(ProjectRootManager.getInstance((Project)each).getFileIndex());
            }
        }
    }

    private static class VfsEventDispatchContext
    implements AutoCloseable {
        final List<? extends VFileEvent> myEvents;
        final boolean myBeforeEvents;
        final VfsEventDispatchContext myPreviousContext;
        VersionedFilterData myFilterData;

        VfsEventDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents) {
            this.myEvents = events;
            this.myBeforeEvents = beforeEvents;
            this.myPreviousContext = (VfsEventDispatchContext)ourCurrentEventDispatchContext.get();
            if (this.myPreviousContext != null) {
                this.myFilterData = this.myPreviousContext.myFilterData;
            }
            ourCurrentEventDispatchContext.set(this);
        }

        @Override
        public void close() {
            ourCurrentEventDispatchContext.set(this.myPreviousContext);
            if (this.myPreviousContext != null && this.myPreviousContext.myFilterData == null && this.myFilterData != null) {
                this.myPreviousContext.myFilterData = this.myFilterData;
            }
        }
    }
}

