/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.Paths;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DirectoryEntry
extends Entry {
    private final ArrayList<Entry> myChildren;

    public DirectoryEntry(String name) {
        this(DirectoryEntry.toNameId(name));
    }

    public DirectoryEntry(int nameId) {
        super(nameId);
        this.myChildren = new ArrayList(3);
    }

    public DirectoryEntry(DataInput in, boolean dummy) throws IOException {
        super(in);
        int count = DataInputOutputUtil.readINT((DataInput)in);
        this.myChildren = new ArrayList(count);
        while (count-- > 0) {
            this.unsafeAddChild(StreamUtil.readEntry(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChildren.size());
        for (Entry child2 : this.myChildren) {
            StreamUtil.writeEntry(out, child2);
        }
    }

    @Override
    public long getTimestamp() {
        return -1L;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public void addChild(Entry child2) {
        if (!this.checkDoesNotExist(child2, child2.getName())) {
            return;
        }
        this.unsafeAddChild(child2);
    }

    @Override
    public void addChildren(Collection<? extends Entry> children2) {
        this.myChildren.ensureCapacity(this.myChildren.size() + children2.size());
        for (Entry entry : children2) {
            this.unsafeAddChild(entry);
        }
    }

    private void unsafeAddChild(Entry child2) {
        this.myChildren.add(child2);
        child2.setParent(this);
    }

    protected boolean checkDoesNotExist(Entry e, String name) {
        Entry found = this.findChild(name);
        if (found == null) {
            return true;
        }
        if (found == e) {
            return false;
        }
        this.removeChild(found);
        LocalHistoryLog.LOG.warn(String.format("entry '%s' already exists in '%s'", name, this.getPath()));
        return true;
    }

    @Override
    public void removeChild(Entry child2) {
        this.myChildren.remove(child2);
        child2.setParent(null);
    }

    @Override
    public List<Entry> getChildren() {
        return this.myChildren;
    }

    @Override
    public boolean hasUnavailableContent(List<? super Entry> entriesWithUnavailableContent) {
        for (Entry e : this.myChildren) {
            e.hasUnavailableContent(entriesWithUnavailableContent);
        }
        return !entriesWithUnavailableContent.isEmpty();
    }

    @Override
    @NotNull
    public DirectoryEntry copy() {
        DirectoryEntry result2 = this.copyEntry();
        result2.myChildren.ensureCapacity(this.myChildren.size());
        for (Entry child2 : this.myChildren) {
            result2.unsafeAddChild(child2.copy());
        }
        return result2;
    }

    protected DirectoryEntry copyEntry() {
        return new DirectoryEntry(this.getNameId());
    }

    @Override
    public void collectDifferencesWith(@NotNull Entry right, @NotNull List<? super Difference> result2, boolean isRightContentCurrent) {
        int commonIndex;
        DirectoryEntry e = (DirectoryEntry)right;
        if (!this.getPath().equals(e.getPath())) {
            result2.add(new Difference(false, this, e, isRightContentCurrent));
        }
        int myChildrenSize = this.myChildren.size();
        int rightChildrenSize = e.myChildren.size();
        int minChildrenSize = Math.min(myChildrenSize, rightChildrenSize);
        for (commonIndex = 0; commonIndex < minChildrenSize; ++commonIndex) {
            Entry childEntry = this.myChildren.get(commonIndex);
            Entry rightChildEntry2 = e.myChildren.get(commonIndex);
            if (childEntry.getNameId() != rightChildEntry2.getNameId() || childEntry.isDirectory() != rightChildEntry2.isDirectory()) break;
            childEntry.collectDifferencesWith(rightChildEntry2, result2, isRightContentCurrent);
        }
        if (commonIndex == myChildrenSize && commonIndex == rightChildrenSize) {
            return;
        }
        TIntObjectHashMap uniqueNameIdToMyChildEntries = new TIntObjectHashMap(myChildrenSize - commonIndex);
        for (int i2 = commonIndex; i2 < myChildrenSize; ++i2) {
            Entry childEntry = this.myChildren.get(i2);
            uniqueNameIdToMyChildEntries.put(childEntry.getNameId(), (Object)childEntry);
        }
        TIntObjectHashMap uniqueNameIdToRightChildEntries = new TIntObjectHashMap(rightChildrenSize - commonIndex);
        TIntObjectHashMap myNameIdToRightChildEntries = new TIntObjectHashMap(rightChildrenSize - commonIndex);
        for (int i3 = commonIndex; i3 < rightChildrenSize; ++i3) {
            Entry rightChildEntry3 = e.myChildren.get(i3);
            int rightChildEntryNameId = rightChildEntry3.getNameId();
            Entry myChildEntry2 = (Entry)uniqueNameIdToMyChildEntries.get(rightChildEntryNameId);
            if (myChildEntry2 != null && myChildEntry2.isDirectory() == rightChildEntry3.isDirectory()) {
                uniqueNameIdToMyChildEntries.remove(rightChildEntryNameId);
                myNameIdToRightChildEntries.put(rightChildEntryNameId, (Object)rightChildEntry3);
                continue;
            }
            uniqueNameIdToRightChildEntries.put(rightChildEntryNameId, (Object)rightChildEntry3);
        }
        if (!Paths.isCaseSensitive() && uniqueNameIdToMyChildEntries.size() > 0 && uniqueNameIdToRightChildEntries.size() > 0) {
            THashMap nameToEntryMap = new THashMap(uniqueNameIdToMyChildEntries.size(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            uniqueNameIdToMyChildEntries.forEachValue(myChildEntry -> {
                nameToEntryMap.put((Object)myChildEntry.getName(), myChildEntry);
                return true;
            });
            uniqueNameIdToRightChildEntries.forEachValue(rightChildEntry -> {
                Entry myChildEntry = (Entry)nameToEntryMap.get((Object)rightChildEntry.getName());
                if (myChildEntry != null && rightChildEntry.isDirectory() == myChildEntry.isDirectory()) {
                    myNameIdToRightChildEntries.put(myChildEntry.getNameId(), rightChildEntry);
                    uniqueNameIdToMyChildEntries.remove(myChildEntry.getNameId());
                    uniqueNameIdToRightChildEntries.remove(rightChildEntry.getNameId());
                }
                return true;
            });
        }
        for (Entry child2 : e.myChildren) {
            if (!uniqueNameIdToRightChildEntries.containsKey(child2.getNameId())) continue;
            child2.collectCreatedDifferences(result2, isRightContentCurrent);
        }
        for (Entry child2 : this.myChildren) {
            if (uniqueNameIdToMyChildEntries.containsKey(child2.getNameId())) {
                child2.collectDeletedDifferences(result2, isRightContentCurrent);
                continue;
            }
            Entry itsChild = (Entry)myNameIdToRightChildEntries.get(child2.getNameId());
            if (itsChild == null) continue;
            child2.collectDifferencesWith(itsChild, result2, isRightContentCurrent);
        }
    }

    Entry findDirectChild(String name, boolean isDirectory) {
        int nameHash = DirectoryEntry.calcNameHash(name);
        for (Entry child2 : this.getChildren()) {
            if (child2.isDirectory() != isDirectory || nameHash != child2.getNameHash() || !child2.nameEquals(name)) continue;
            return child2;
        }
        return null;
    }

    @Override
    protected void collectCreatedDifferences(@NotNull List<? super Difference> result2, boolean isRightContentCurrent) {
        result2.add(new Difference(false, null, this, isRightContentCurrent));
        for (Entry child2 : this.myChildren) {
            child2.collectCreatedDifferences(result2, isRightContentCurrent);
        }
    }

    @Override
    protected void collectDeletedDifferences(@NotNull List<? super Difference> result2, boolean isRightContentCurrent) {
        result2.add(new Difference(false, this, null, isRightContentCurrent));
        for (Entry child2 : this.myChildren) {
            child2.collectDeletedDifferences(result2, isRightContentCurrent);
        }
    }
}

