/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamUtil {
    public static Entry readEntry(DataInput in) throws IOException {
        int type = DataInputOutputUtil.readINT((DataInput)in);
        switch (type) {
            case 0: {
                return new FileEntry(in, true);
            }
            case 1: {
                return new DirectoryEntry(in, true);
            }
        }
        throw new IOException("unexpected entry type: " + type);
    }

    public static void writeEntry(@NotNull DataOutput out, Entry e) throws IOException {
        int id2 = -1;
        Class<?> c = e.getClass();
        if (c.equals(FileEntry.class)) {
            id2 = 0;
        }
        if (c.equals(DirectoryEntry.class)) {
            id2 = 1;
        }
        if (id2 == -1) {
            throw new IOException("unexpected entry type: " + c);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)id2);
        e.write(out);
    }

    public static Change readChange(DataInput in) throws IOException {
        int type = DataInputOutputUtil.readINT((DataInput)in);
        switch (type) {
            case 1: {
                return new CreateFileChange(in);
            }
            case 2: {
                return new CreateDirectoryChange(in);
            }
            case 3: {
                return new ContentChange(in);
            }
            case 4: {
                return new RenameChange(in);
            }
            case 5: {
                return new ROStatusChange(in);
            }
            case 6: {
                return new MoveChange(in);
            }
            case 7: {
                return new DeleteChange(in);
            }
            case 8: {
                return new PutLabelChange(in);
            }
            case 9: {
                return new PutSystemLabelChange(in);
            }
        }
        throw new IOException("unexpected change type: " + type);
    }

    public static void writeChange(DataOutput out, Change change) throws IOException {
        int id2 = -1;
        Class<?> c = change.getClass();
        if (c.equals(CreateFileChange.class)) {
            id2 = 1;
        }
        if (c.equals(CreateDirectoryChange.class)) {
            id2 = 2;
        }
        if (c.equals(ContentChange.class)) {
            id2 = 3;
        }
        if (c.equals(RenameChange.class)) {
            id2 = 4;
        }
        if (c.equals(ROStatusChange.class)) {
            id2 = 5;
        }
        if (c.equals(MoveChange.class)) {
            id2 = 6;
        }
        if (c.equals(DeleteChange.class)) {
            id2 = 7;
        }
        if (c.equals(PutLabelChange.class)) {
            id2 = 8;
        }
        if (c.equals(PutSystemLabelChange.class)) {
            id2 = 9;
        }
        if (id2 == -1) {
            throw new IOException("unexpected change type: " + c);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)id2);
        change.write(out);
    }

    @NotNull
    public static String readString(DataInput in) throws IOException {
        return IOUtil.readUTF((DataInput)in);
    }

    public static void writeString(DataOutput out, @NotNull String s) throws IOException {
        IOUtil.writeUTF((DataOutput)out, (String)s);
    }

    @Nullable
    public static String readStringOrNull(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return StreamUtil.readString(in);
    }

    public static void writeStringOrNull(DataOutput out, @Nullable String s) throws IOException {
        out.writeBoolean(s != null);
        if (s != null) {
            StreamUtil.writeString(out, s);
        }
    }
}

