/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class BlockIndentOptions {
    private final CodeStyleSettings mySettings;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
    private final int myRightMargin;

    public BlockIndentOptions(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, Block block) {
        this.mySettings = settings;
        this.myIndentOptions = indentOptions;
        this.myRightMargin = this.calcRightMargin(block);
    }

    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        return this.myIndentOptions;
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull AbstractBlockWrapper block) {
        CommonCodeStyleSettings.IndentOptions result2;
        CommonCodeStyleSettings commonSettings;
        if (this.myIndentOptions.isOverrideLanguageOptions()) {
            return this.myIndentOptions;
        }
        Language language = block.getLanguage();
        if (language != null && (commonSettings = this.mySettings.getCommonSettings(language)) != null && (result2 = commonSettings.getIndentOptions()) != null) {
            return result2;
        }
        return this.myIndentOptions;
    }

    public int getRightMargin() {
        return this.myRightMargin;
    }

    private int calcRightMargin(Block rootBlock) {
        PsiFile psiFile;
        PsiElement psiElement;
        ASTNode node;
        Language language = null;
        if (rootBlock instanceof ASTBlock && (node = ((ASTBlock)rootBlock).getNode()) != null && (psiElement = node.getPsi()).isValid() && (psiFile = psiElement.getContainingFile()) != null) {
            language = psiFile.getViewProvider().getBaseLanguage();
        }
        return this.mySettings.getRightMargin(language);
    }
}

