/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.PlatformUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileSetFormatter
extends FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetFormatter.class);
    private static final String PROJECT_DIR_PREFIX = PlatformUtils.getPlatformPrefix() + ".format.";
    private static final String PROJECT_DIR_SUFFIX = ".tmp";
    private static final String RESULT_MESSAGE_OK = "OK";
    private static final String RESULT_MESSAGE_FAILED = "Failed";
    private static final String RESULT_MESSAGE_NOT_SUPPORTED = "Skipped, not supported.";
    private static final String RESULT_MESSAGE_BINARY_FILE = "Skipped, binary file.";
    @NotNull
    private final String myProjectUID;
    @Nullable
    private Project myProject;
    private final MessageOutput myMessageOutput;
    @NotNull
    private CodeStyleSettings mySettings;

    public FileSetFormatter(@NotNull MessageOutput messageOutput) {
        this.myMessageOutput = messageOutput;
        this.mySettings = CodeStyleSettingsManager.getInstance().createSettings();
        this.myProjectUID = UUID.randomUUID().toString();
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    private void createProject() throws IOException {
        this.myProject = ProjectManagerEx.getInstanceEx().openProject(this.createProjectDir(), OpenProjectTask.newProject());
        if (this.myProject != null) {
            CodeStyle.setMainProjectSettings((Project)this.myProject, (CodeStyleSettings)this.mySettings);
        }
    }

    @NotNull
    private Path createProjectDir() throws IOException {
        Path projectDir = FileUtil.createTempDirectory((String)PROJECT_DIR_PREFIX, (String)(this.myProjectUID + PROJECT_DIR_SUFFIX)).toPath().resolve(".idea");
        Files.createDirectories(projectDir, new FileAttribute[0]);
        return projectDir;
    }

    private void closeProject() {
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
        }
    }

    @Override
    public void processFiles() throws IOException {
        this.createProject();
        if (this.myProject != null) {
            super.processFiles();
            this.closeProject();
        }
    }

    @Override
    protected boolean processFile(@NotNull VirtualFile virtualFile) {
        String resultMessage = RESULT_MESSAGE_OK;
        assert (this.myProject != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
        this.myMessageOutput.info("Formatting " + virtualFile.getCanonicalPath() + "...");
        if (!virtualFile.getFileType().isBinary()) {
            VirtualFile[] openFiles;
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(virtualFile));
                if (psiFile != null) {
                    if (FileSetFormatter.isFormattingSupported(psiFile)) {
                        FileSetFormatter.reformatFile(this.myProject, psiFile, document);
                        FileDocumentManager.getInstance().saveDocument(document);
                    } else {
                        resultMessage = RESULT_MESSAGE_NOT_SUPPORTED;
                    }
                } else {
                    LOG.warn("Unable to get a PSI file for " + virtualFile.getPath());
                    resultMessage = RESULT_MESSAGE_FAILED;
                }
            } else {
                LOG.warn("No document available for " + virtualFile.getPath());
                resultMessage = RESULT_MESSAGE_FAILED;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
            for (VirtualFile openFile2 : openFiles = editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
        } else {
            resultMessage = RESULT_MESSAGE_BINARY_FILE;
        }
        this.myMessageOutput.info(resultMessage + "\n");
        return RESULT_MESSAGE_OK.equals(resultMessage);
    }

    private static void reformatFile(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformatText(file2, 0, file2.getTextLength());
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        });
    }

    private static boolean isFormattingSupported(@NotNull PsiFile file2) {
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null;
    }
}

