/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;

    public IndentInside() {
    }

    public IndentInside(int whiteSpaces, int tabs) {
        this.whiteSpaces = whiteSpaces;
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result2 = this.whiteSpaces;
        result2 = 29 * result2 + this.tabs;
        return result2;
    }

    public int getTabsCount(CommonCodeStyleSettings.IndentOptions options2) {
        int tabsFromSpaces = this.whiteSpaces / options2.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CommonCodeStyleSettings.IndentOptions options2) {
        return this.whiteSpaces + this.tabs * options2.TAB_SIZE;
    }

    @NotNull
    static IndentInside getLastLineIndent(@NotNull CharSequence text) {
        CharSequence lastLine = IndentInside.getLastLine(text);
        return IndentInside.createIndentOn(lastLine);
    }

    @NotNull
    public static IndentInside createIndentOn(@Nullable CharSequence lastLine) {
        IndentInside result2 = new IndentInside();
        if (lastLine == null) {
            return result2;
        }
        for (int i2 = 0; i2 < lastLine.length(); ++i2) {
            if (lastLine.charAt(i2) == ' ') {
                ++result2.whiteSpaces;
            }
            if (lastLine.charAt(i2) != '\t') continue;
            ++result2.tabs;
        }
        return result2;
    }

    @NotNull
    public static CharSequence getLastLine(@NotNull CharSequence text) {
        int i2 = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)(text.length() - 1), (String)"\n");
        if (i2 < 0) {
            return text;
        }
        if (i2 >= text.length() - 1) {
            return "";
        }
        return text.subSequence(i2 + 1, text.length());
    }

    public String toString() {
        return String.format("spaces: %d, tabs: %d", this.whiteSpaces, this.tabs);
    }
}

