/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoreFormatterUtil {
    private CoreFormatterUtil() {
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder2, @NotNull PsiElement element2, @NotNull TextRange range2, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (builder2 instanceof FormattingModelBuilderEx) {
            return ((FormattingModelBuilderEx)builder2).createModel(element2, range2, settings, mode);
        }
        return builder2.createModel(element2, settings);
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder2, @NotNull PsiElement element2, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        return CoreFormatterUtil.buildModel(builder2, element2, element2.getTextRange(), settings, mode);
    }

    @Nullable
    public static AlignmentImpl getAlignment(@NotNull AbstractBlockWrapper block) {
        AlignmentImpl alignment;
        AbstractBlockWrapper current2 = block;
        while ((alignment = current2.getAlignment()) == null || alignment.getOffsetRespBlockBefore(block) == null) {
            if ((current2 = current2.getParent()) != null && current2.getStartOffset() == block.getStartOffset()) continue;
            return null;
        }
        return alignment;
    }

    public static int getStartColumn(@Nullable LeafBlockWrapper block) {
        if (block == null) {
            return -1;
        }
        int result2 = 0;
        do {
            WhiteSpace whiteSpace = block.getWhiteSpace();
            result2 += whiteSpace.getTotalSpaces();
            if (whiteSpace.containsLineFeeds()) {
                return result2;
            }
            block = block.getPreviousBlock();
            if (result2 > 1000 || block == null) {
                return result2;
            }
            result2 += block.getSymbolsAtTheLastLine();
        } while (!block.containsLineFeeds());
        return result2;
    }

    @Nullable
    public static AbstractBlockWrapper getIndentedParentBlock(@NotNull AbstractBlockWrapper block) {
        for (CompositeBlockWrapper current2 = block.getParent(); current2 != null; current2 = current2.getParent()) {
            AbstractBlockWrapper prevIndented;
            if (current2.getStartOffset() != block.getStartOffset() && current2.getWhiteSpace().containsLineFeeds()) {
                return current2;
            }
            if (current2.getParent() == null || (prevIndented = current2.getParent().getPrevIndentedSibling(current2)) == null) continue;
            return prevIndented;
        }
        return null;
    }

    public static boolean allowBackwardAlignment(@NotNull LeafBlockWrapper first, @NotNull LeafBlockWrapper second, @NotNull Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings) {
        HashSet<AbstractBlockWrapper> blocksBeforeCurrent = new HashSet<AbstractBlockWrapper>();
        for (LeafBlockWrapper previousBlock = second.getPreviousBlock(); previousBlock != null; previousBlock = previousBlock.getPreviousBlock()) {
            Set<AbstractBlockWrapper> blocks = alignmentMappings.get(previousBlock);
            if (blocks != null) {
                blocksBeforeCurrent.addAll(blocks);
            }
            if (previousBlock.getWhiteSpace().containsLineFeeds()) break;
        }
        for (LeafBlockWrapper next = first.getNextBlock(); next != null && !next.getWhiteSpace().containsLineFeeds(); next = next.getNextBlock()) {
            if (!blocksBeforeCurrent.contains(next)) continue;
            return false;
        }
        return true;
    }

    public static IndentData getIndent(CommonCodeStyleSettings.IndentOptions options2, AbstractBlockWrapper block, int tokenBlockStartOffset) {
        IndentImpl indent = block.getIndent();
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return new IndentData(options2.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.CONTINUATION_WITHOUT_FIRST) {
            if (block.getStartOffset() != block.getParent().getStartOffset() && block.getStartOffset() == tokenBlockStartOffset) {
                return new IndentData(options2.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.LABEL) {
            return new IndentData(options2.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.SPACES) {
            return new IndentData(indent.getSpaces(), 0);
        }
        return new IndentData(options2.INDENT_SIZE);
    }

    @NotNull
    public static LeafBlockWrapper getFirstLeaf(@NotNull AbstractBlockWrapper block) {
        if (block instanceof LeafBlockWrapper) {
            return (LeafBlockWrapper)block;
        }
        return CoreFormatterUtil.getFirstLeaf(((CompositeBlockWrapper)block).getChildren().get(0));
    }
}

