/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.usages.impl;

import com.intellij.find.usages.SearchTarget;
import com.intellij.find.usages.SymbolSearchTargetFactory;
import com.intellij.find.usages.SymbolUsageHandlerFactory;
import com.intellij.find.usages.UsageHandler;
import com.intellij.find.usages.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.DefaultSymbolSearchTarget;
import com.intellij.find.usages.impl.DefaultSymbolUsageHandler;
import com.intellij.find.usages.impl.TextSearchKt;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiFile;
import com.intellij.usages.Usage;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001aB\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0010H\u0007\u001a\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u001a\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u001a\u001c\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"SEARCH_TARGET_EXTENSION", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/find/usages/SymbolSearchTargetFactory;", "USAGE_HANDLER_EXTENSION", "Lcom/intellij/find/usages/SymbolUsageHandlerFactory;", "buildQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/usages/Usage;", "O", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/find/usages/SearchTarget;", "handler", "Lcom/intellij/find/usages/UsageHandler;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "symbolSearchTarget", "symbol", "Lcom/intellij/model/Symbol;", "symbolSearchTargets", "", "targetSymbols", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "symbolUsageHandler", "intellij.platform.lang.impl"})
public final class ImplKt {
    private static final ClassExtension<SymbolSearchTargetFactory<?>> SEARCH_TARGET_EXTENSION = new ClassExtension("com.intellij.lang.symbolSearchTarget");
    private static final ClassExtension<SymbolUsageHandlerFactory<?>> USAGE_HANDLER_EXTENSION = new ClassExtension("com.intellij.lang.symbolUsageHandler");

    @ApiStatus.Internal
    @NotNull
    public static final List<SearchTarget> symbolSearchTargets(@NotNull PsiFile file2, int offset) {
        Collection<Symbol> targetSymbols = TargetsKt.targetSymbols(file2, offset);
        if (targetSymbols.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return ImplKt.symbolSearchTargets(file2.getProject(), targetSymbols);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SearchTarget> symbolSearchTargets(@NotNull Project project, @NotNull Collection<? extends Symbol> targetSymbols) {
        void var3_3;
        void $this$mapTo$iv;
        Iterable iterable = targetSymbols;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Symbol symbol = (Symbol)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            SearchTarget searchTarget = ImplKt.symbolSearchTarget(project, (Symbol)it);
            collection.add(searchTarget);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var3_3));
    }

    @NotNull
    public static final SearchTarget symbolSearchTarget(@NotNull Project project, @NotNull Symbol symbol) {
        for (SymbolSearchTargetFactory factory2 : SEARCH_TARGET_EXTENSION.forKey(symbol.getClass())) {
            SymbolSearchTargetFactory factory_;
            if (factory2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.find.usages.SymbolSearchTargetFactory<com.intellij.model.Symbol>");
            }
            SearchTarget target2 = factory_.createTarget(project, symbol);
            if (target2 == null) continue;
            return target2;
        }
        return new DefaultSymbolSearchTarget(project, symbol);
    }

    @NotNull
    public static final UsageHandler<?> symbolUsageHandler(@NotNull Project project, @NotNull Symbol symbol) {
        for (SymbolUsageHandlerFactory factory2 : USAGE_HANDLER_EXTENSION.forKey(symbol.getClass())) {
            SymbolUsageHandlerFactory factory_;
            if (factory2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.find.usages.SymbolUsageHandlerFactory<com.intellij.model.Symbol>");
            }
            UsageHandler<?> handler2 = factory_.createHandler(project, symbol);
            if (handler2 == null) continue;
            return handler2;
        }
        return new DefaultSymbolUsageHandler(project, symbol);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final <O> Query<? extends Usage> buildQuery(@NotNull Project project, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler2, @NotNull AllSearchOptions<O> allOptions) {
        void textSearch;
        void options2;
        AllSearchOptions<O> allSearchOptions = allOptions;
        UsageOptions usageOptions = allSearchOptions.component1();
        Boolean bl = allSearchOptions.component2();
        O customOptions = allSearchOptions.component3();
        Query<Usage> usageQuery = handler2.buildSearchQuery((UsageOptions)options2, customOptions);
        if (Intrinsics.areEqual((Object)textSearch, (Object)true) ^ true) {
            return usageQuery;
        }
        Collection<String> textSearchStrings2 = target2.getTextSearchStrings();
        if (textSearchStrings2.isEmpty()) {
            return usageQuery;
        }
        ArrayList queries = new ArrayList(textSearchStrings2.size() + 1);
        Collection collection = queries;
        boolean bl2 = false;
        collection.add(usageQuery);
        Iterable $this$mapTo$iv = textSearchStrings2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection2 = queries;
            boolean bl3 = false;
            Query<? extends Usage> query = TextSearchKt.buildTextQuery(project, (String)it, options2.getSearchScope());
            collection2.add(query);
        }
        return SearchService.getInstance().merge((List)queries);
    }
}

