/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl.livePreview;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.livePreview.SelectionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchResults
implements DocumentListener,
CaretListener {
    private final List<SearchResultsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private FindResult myCursor;
    @NotNull
    private List<FindResult> myOccurrences = new ArrayList<FindResult>();
    private final Set<RangeMarker> myExcluded = new HashSet<RangeMarker>();
    @NotNull
    private final Editor myEditor;
    private final Project myProject;
    private FindModel myFindModel;
    private int myMatchesLimit = 100;
    private boolean myNotFoundState;
    private boolean myDisposed;
    private int myStamp;
    private int myLastUpdatedStamp = -1;
    private long myDocumentTimestamp;
    private boolean myUpdating;
    private final Stack<Pair<FindModel, FindResult>> myCursorPositions = new Stack();
    private final SelectionManager mySelectionManager;

    public int getStamp() {
        return ++this.myStamp;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        this.myCursorPositions.clear();
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        Caret caret = event.getCaret();
        if (caret != null && this.myEditor.getCaretModel().getCaretCount() == 1) {
            int offset = caret.getOffset();
            FindResult occurrenceAtCaret = this.getOccurrenceAtCaret();
            if (occurrenceAtCaret != null && occurrenceAtCaret != this.myCursor) {
                this.moveCursorTo(occurrenceAtCaret, false, false);
                this.myEditor.getCaretModel().moveToOffset(offset);
                this.notifyCursorMoved();
            }
        }
    }

    public SearchResults(@NotNull Editor editor, Project project) {
        this.myEditor = editor;
        this.myProject = project;
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this);
        this.mySelectionManager = new SelectionManager(this);
    }

    public void setNotFoundState(boolean isForward) {
        this.myNotFoundState = true;
        FindModel findModel = new FindModel();
        findModel.copyFrom(this.myFindModel);
        findModel.setForward(isForward);
        FindUtil.processNotFound(this.myEditor, findModel.getStringToFind(), findModel, this.getProject());
    }

    public int getMatchesCount() {
        return this.myOccurrences.size();
    }

    public boolean hasMatches() {
        return !this.getOccurrences().isEmpty();
    }

    public FindModel getFindModel() {
        return this.myFindModel;
    }

    public boolean isExcluded(FindResult occurrence) {
        for (RangeMarker rangeMarker : this.myExcluded) {
            if (!TextRange.areSegmentsEqual((Segment)rangeMarker, (Segment)occurrence)) continue;
            return true;
        }
        return false;
    }

    public void exclude(FindResult occurrence) {
        boolean include = false;
        for (RangeMarker rangeMarker : this.myExcluded) {
            if (!TextRange.areSegmentsEqual((Segment)rangeMarker, (Segment)occurrence)) continue;
            this.myExcluded.remove(rangeMarker);
            rangeMarker.dispose();
            include = true;
            break;
        }
        if (!include) {
            this.myExcluded.add(this.myEditor.getDocument().createRangeMarker(occurrence.getStartOffset(), occurrence.getEndOffset(), true));
        }
        this.notifyChanged();
    }

    public Set<RangeMarker> getExcluded() {
        return this.myExcluded;
    }

    public void addListener(@NotNull SearchResultsListener srl) {
        this.myListeners.add(srl);
    }

    public void removeListener(@NotNull SearchResultsListener srl) {
        this.myListeners.remove(srl);
    }

    public int getMatchesLimit() {
        return this.myMatchesLimit;
    }

    public void setMatchesLimit(int matchesLimit) {
        this.myMatchesLimit = matchesLimit;
    }

    @Nullable
    public FindResult getCursor() {
        return this.myCursor;
    }

    public int getCursorVisualIndex() {
        FindResult occurrenceAtCaret = this.getOccurrenceAtCaret();
        return occurrenceAtCaret != null ? this.myOccurrences.indexOf(occurrenceAtCaret) + 1 : -1;
    }

    @NotNull
    public List<FindResult> getOccurrences() {
        return this.myOccurrences;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    public void clear() {
        this.searchCompleted(new ArrayList<FindResult>(), this.getEditor(), null, false, null, this.getStamp());
    }

    ActionCallback updateThreadSafe(@NotNull FindModel findModel, boolean toChangeSelection, @Nullable TextRange next, int stamp) {
        if (this.myDisposed) {
            return ActionCallback.DONE;
        }
        ActionCallback result2 = new ActionCallback();
        Editor editor = this.getEditor();
        this.updatePreviousFindModel(findModel);
        FutureResult startsRef = new FutureResult();
        FutureResult endsRef = new FutureResult();
        SearchResults.getSelection(editor, (FutureResult<int[]>)startsRef, (FutureResult<int[]>)endsRef);
        ArrayList results = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            Project project = this.getProject();
            if (this.myDisposed || project != null && project.isDisposed()) {
                return;
            }
            int[] starts = new int[]{};
            int[] ends = new int[]{};
            try {
                starts = (int[])startsRef.get();
                ends = (int[])endsRef.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            if (starts.length == 0 || findModel.isGlobal()) {
                this.findInRange(new TextRange(0, Integer.MAX_VALUE), editor, findModel, results);
            } else {
                for (int i2 = 0; i2 < starts.length; ++i2) {
                    this.findInRange(new TextRange(starts[i2], ends[i2]), editor, findModel, results);
                }
            }
            long documentTimeStamp = editor.getDocument().getModificationStamp();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (editor.getDocument().getModificationStamp() == documentTimeStamp) {
                    this.searchCompleted(results, editor, findModel, toChangeSelection, next, stamp);
                    result2.setDone();
                } else {
                    result2.setRejected();
                }
            });
        });
        return result2;
    }

    private void updatePreviousFindModel(@NotNull FindModel model) {
        FindModel prev = FindManager.getInstance((Project)this.getProject()).getPreviousFindModel();
        if (prev == null) {
            prev = new FindModel();
        }
        if (!model.getStringToFind().isEmpty()) {
            prev.copyFrom(model);
            FindManager.getInstance((Project)this.getProject()).setPreviousFindModel(prev);
        }
    }

    private static void getSelection(Editor editor, FutureResult<int[]> starts, FutureResult<int[]> ends) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            SelectionModel selection = editor.getSelectionModel();
            starts.set((Object)selection.getBlockSelectionStarts());
            ends.set((Object)selection.getBlockSelectionEnds());
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    SelectionModel selection = editor.getSelectionModel();
                    starts.set((Object)selection.getBlockSelectionStarts());
                    ends.set((Object)selection.getBlockSelectionEnds());
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findInRange(@NotNull TextRange range2, @NotNull Editor editor, @NotNull FindModel findModel, @NotNull List<? super FindResult> results) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        CharSequence charSequence = editor.getDocument().getImmutableCharSequence();
        int offset = range2.getStartOffset();
        int maxOffset = Math.min(range2.getEndOffset(), charSequence.length());
        FindManager findManager = FindManager.getInstance((Project)this.getProject());
        while (true) {
            FindResult result2;
            try {
                CharSequence bombedCharSequence = StringUtil.newBombedCharSequence((CharSequence)charSequence, (long)3000L);
                result2 = findManager.findString(bombedCharSequence, offset, findModel, virtualFile);
                ((StringUtil.BombedCharSequence)bombedCharSequence).defuse();
            }
            catch (ProcessCanceledException | PatternSyntaxException e) {
                result2 = null;
            }
            if (result2 == null) return;
            if (!result2.isStringFound()) {
                return;
            }
            int newOffset = result2.getEndOffset();
            if (result2.getEndOffset() > maxOffset) {
                return;
            }
            if (offset == newOffset) {
                if (offset >= maxOffset - 1) {
                    results.add((FindResult)result2);
                    return;
                }
                ++offset;
            } else {
                offset = newOffset;
                if (offset == result2.getStartOffset()) {
                    ++offset;
                }
            }
            results.add((FindResult)result2);
        }
    }

    public void dispose() {
        this.myDisposed = true;
        this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
    }

    private void searchCompleted(@NotNull List<FindResult> occurrences, @NotNull Editor editor, @Nullable FindModel findModel, boolean toChangeSelection, @Nullable TextRange next, int stamp) {
        if (stamp < this.myLastUpdatedStamp) {
            return;
        }
        this.myLastUpdatedStamp = stamp;
        if (editor != this.getEditor() || this.myDisposed || editor.isDisposed()) {
            return;
        }
        this.setUpdating(false);
        this.myOccurrences = occurrences;
        FindResult oldCursorRange = this.myCursor;
        this.myOccurrences.sort(Comparator.comparingInt(TextRange::getStartOffset));
        this.myFindModel = findModel;
        this.myDocumentTimestamp = this.myEditor.getDocument().getModificationStamp();
        this.updateCursor((TextRange)oldCursorRange, next);
        this.updateExcluded();
        this.notifyChanged();
        if (this.myCursor == null || !this.myCursor.equals((Object)oldCursorRange)) {
            if (toChangeSelection) {
                this.updateSelection(true, true, true);
            }
            this.notifyCursorMoved();
        }
        this.notifyUpdateFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection(boolean removePreviousSelection, boolean removeAllPreviousSelections, boolean adjustScrollPosition) {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.beforeSelectionUpdate();
        }
        try {
            this.mySelectionManager.updateSelection(removePreviousSelection, removeAllPreviousSelections, adjustScrollPosition);
        }
        finally {
            for (SearchResultsListener listener2 : this.myListeners) {
                listener2.afterSelectionUpdate();
            }
        }
    }

    private void notifyUpdateFinished() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.updateFinished();
        }
    }

    private void updateExcluded() {
        HashSet<RangeMarker> invalid = new HashSet<RangeMarker>();
        for (RangeMarker marker : this.myExcluded) {
            if (marker.isValid()) continue;
            invalid.add(marker);
            marker.dispose();
        }
        this.myExcluded.removeAll(invalid);
    }

    private void updateCursor(@Nullable TextRange oldCursorRange, @Nullable TextRange next) {
        boolean justReplaced = next != null;
        boolean toPush = true;
        if ((justReplaced || (toPush = !this.repairCursorFromStack())) && (justReplaced || !this.tryToRepairOldCursor(oldCursorRange))) {
            if (this.myFindModel != null) {
                if (oldCursorRange != null && !this.myFindModel.isGlobal()) {
                    this.myCursor = this.firstOccurrenceAfterOffset(oldCursorRange.getEndOffset());
                } else if (justReplaced) {
                    this.nextOccurrence(false, next, false, true, false);
                } else {
                    this.myCursor = oldCursorRange == null ? this.firstOccurrenceAtOrAfterCaret() : this.firstOccurrenceAfterCaret();
                }
            } else {
                this.myCursor = null;
            }
        }
        if (!justReplaced && this.myCursor == null && this.hasMatches()) {
            this.nextOccurrence(true, oldCursorRange, false, false, false);
        }
        if (toPush && this.myCursor != null) {
            this.push();
        }
    }

    private boolean repairCursorFromStack() {
        if (this.myCursorPositions.size() >= 2) {
            FindResult newCursor;
            Pair oldPosition = (Pair)this.myCursorPositions.get(this.myCursorPositions.size() - 2);
            if (((FindModel)oldPosition.first).equals((Object)this.myFindModel) && (newCursor = this.findOccurrenceEqualTo((FindResult)oldPosition.second)) != null) {
                this.myCursorPositions.pop();
                this.myCursor = newCursor;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private FindResult findOccurrenceEqualTo(FindResult occurrence) {
        for (FindResult findResult : this.myOccurrences) {
            if (!findResult.equals((Object)occurrence)) continue;
            return findResult;
        }
        return null;
    }

    @Nullable
    private FindResult firstOccurrenceAtOrAfterCaret() {
        FindResult occurrence = this.getOccurrenceAtCaret();
        if (occurrence != null) {
            return occurrence;
        }
        occurrence = this.getFirstOccurrenceInSelection();
        if (occurrence != null) {
            return occurrence;
        }
        return this.firstOccurrenceAfterCaret();
    }

    @Nullable
    private FindResult getOccurrenceAtCaret() {
        int offset = this.getEditor().getCaretModel().getOffset();
        for (FindResult occurrence : this.myOccurrences) {
            if (offset > occurrence.getEndOffset() || offset < occurrence.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    @Nullable
    private FindResult getFirstOccurrenceInSelection() {
        int selectionStartOffset = this.getEditor().getSelectionModel().getSelectionStart();
        int selectionEndOffset = this.getEditor().getSelectionModel().getSelectionEnd();
        for (FindResult occurrence : this.myOccurrences) {
            if (selectionEndOffset < occurrence.getEndOffset() || selectionStartOffset > occurrence.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    private void notifyChanged() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.searchResultsUpdated(this);
        }
    }

    static boolean insideVisibleArea(Editor e, TextRange r) {
        int startOffset = r.getStartOffset();
        if (startOffset > e.getDocument().getTextLength()) {
            return false;
        }
        Rectangle visibleArea = e.getScrollingModel().getVisibleArea();
        Point point = e.logicalPositionToXY(e.offsetToLogicalPosition(startOffset));
        return visibleArea.contains(point);
    }

    @Nullable
    private FindResult firstOccurrenceBeforeCaret() {
        int offset = this.getEditor().getCaretModel().getOffset();
        return this.firstOccurrenceBeforeOffset(offset);
    }

    @Nullable
    private FindResult firstOccurrenceBeforeOffset(int offset) {
        for (int i2 = this.getOccurrences().size() - 1; i2 >= 0; --i2) {
            if (this.getOccurrences().get(i2).getEndOffset() >= offset) continue;
            return this.getOccurrences().get(i2);
        }
        return null;
    }

    @Nullable
    private FindResult firstOccurrenceAfterCaret() {
        int caret = this.myEditor.getCaretModel().getOffset();
        return this.firstOccurrenceAfterOffset(caret);
    }

    @Nullable
    private FindResult firstOccurrenceAfterOffset(int offset) {
        FindResult afterCaret = null;
        for (FindResult occurrence : this.getOccurrences()) {
            if (occurrence.getStartOffset() < offset || occurrence.getEndOffset() <= offset || afterCaret != null && occurrence.getStartOffset() >= afterCaret.getStartOffset()) continue;
            afterCaret = occurrence;
        }
        return afterCaret;
    }

    private boolean tryToRepairOldCursor(@Nullable TextRange oldCursorRange) {
        if (oldCursorRange == null) {
            return false;
        }
        FindResult mayBeOldCursor = null;
        for (FindResult searchResult : this.getOccurrences()) {
            if (searchResult.intersects(oldCursorRange)) {
                mayBeOldCursor = searchResult;
            }
            if (searchResult.getStartOffset() != oldCursorRange.getStartOffset()) continue;
            break;
        }
        if (mayBeOldCursor != null) {
            this.myCursor = mayBeOldCursor;
            return true;
        }
        return false;
    }

    @Nullable
    private FindResult prevOccurrence(TextRange range2) {
        for (int i2 = this.getOccurrences().size() - 1; i2 >= 0; --i2) {
            FindResult occurrence = this.getOccurrences().get(i2);
            if (occurrence.getEndOffset() > range2.getStartOffset()) continue;
            return occurrence;
        }
        return null;
    }

    @Nullable
    private FindResult nextOccurrence(TextRange range2) {
        for (FindResult occurrence : this.getOccurrences()) {
            if (occurrence.getStartOffset() < range2.getEndOffset()) continue;
            return occurrence;
        }
        return null;
    }

    public void prevOccurrence(boolean findSelected) {
        if (findSelected) {
            this.myCursor = this.mySelectionManager.removeCurrentSelection() ? this.firstOccurrenceAtOrAfterCaret() : null;
            this.notifyCursorMoved();
        } else {
            if (this.myFindModel == null) {
                return;
            }
            boolean processFromTheBeginning = false;
            if (this.myNotFoundState) {
                this.myNotFoundState = false;
                processFromTheBeginning = true;
            }
            FindResult next = null;
            if (!this.myFindModel.isGlobal()) {
                if (this.myCursor != null) {
                    next = this.prevOccurrence((TextRange)this.myCursor);
                }
            } else {
                next = this.firstOccurrenceBeforeCaret();
            }
            if (next == null) {
                if (processFromTheBeginning) {
                    if (this.hasMatches()) {
                        next = this.getOccurrences().get(this.getOccurrences().size() - 1);
                    }
                } else {
                    this.setNotFoundState(false);
                }
            }
            this.moveCursorTo(next, false, true);
        }
        this.push();
    }

    private void push() {
        this.myCursorPositions.push((Object)Pair.create((Object)this.myFindModel, (Object)this.myCursor));
    }

    public void nextOccurrence(boolean retainOldSelection) {
        if (this.myFindModel == null) {
            return;
        }
        this.nextOccurrence(false, (TextRange)this.myCursor, true, false, retainOldSelection);
        this.push();
    }

    private void nextOccurrence(boolean processFromTheBeginning, TextRange cursor, boolean toNotify, boolean justReplaced, boolean retainOldSelection) {
        FindResult next;
        if (this.myNotFoundState) {
            this.myNotFoundState = false;
            processFromTheBeginning = true;
        }
        if ((next = (!this.myFindModel.isGlobal() || justReplaced) && cursor != null ? this.nextOccurrence(cursor) : this.firstOccurrenceAfterCaret()) == null) {
            if (processFromTheBeginning) {
                if (this.hasMatches()) {
                    next = this.getOccurrences().get(0);
                }
            } else {
                this.setNotFoundState(true);
            }
        }
        if (toNotify) {
            this.moveCursorTo(next, retainOldSelection, true);
        } else {
            this.myCursor = next;
        }
    }

    public void moveCursorTo(FindResult next, boolean retainOldSelection, boolean adjustScrollPosition) {
        if (next != null && !this.mySelectionManager.isSelected(next)) {
            boolean bl = this.myCursor != null && this.mySelectionManager.isSelected(this.myCursor);
            this.myCursor = next;
            this.updateSelection(!(retainOldSelection &= bl), false, adjustScrollPosition);
            this.notifyCursorMoved();
        }
    }

    private void notifyCursorMoved() {
        for (SearchResultsListener listener2 : this.myListeners) {
            listener2.cursorMoved();
            listener2.searchResultsUpdated(this);
        }
    }

    public boolean isUpToDate() {
        return this.myDocumentTimestamp == this.myEditor.getDocument().getModificationStamp();
    }

    void setUpdating(boolean value2) {
        this.myUpdating = value2;
    }

    public boolean isUpdating() {
        return this.myUpdating;
    }

    public static interface SearchResultsListener {
        public void searchResultsUpdated(@NotNull SearchResults var1);

        public void cursorMoved();

        default public void updateFinished() {
        }

        default public void beforeSelectionUpdate() {
        }

        default public void afterSelectionUpdate() {
        }
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

