/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.usages.ConfigurableUsageTarget;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowRecentFindUsagesGroup
extends ActionGroup {
    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabledAndVisible(project != null);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return EMPTY_ARRAY;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || DumbService.isDumb((Project)project)) {
            return EMPTY_ARRAY;
        }
        final FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        ArrayList<ConfigurableUsageTarget> history = new ArrayList<ConfigurableUsageTarget>(findUsagesManager.getHistory().getAll());
        Collections.reverse(history);
        String description = ActionManager.getInstance().getAction("UsageView.ShowRecentFindUsages").getTemplatePresentation().getDescription();
        ArrayList<1> children2 = new ArrayList<1>(history.size());
        for (final ConfigurableUsageTarget usageTarget : history) {
            if (!usageTarget.isValid()) continue;
            String text = usageTarget.getLongDescriptiveName();
            AnAction action2 = new AnAction(text, description, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    findUsagesManager.rerunAndRecallFromHistory(usageTarget);
                }
            };
            children2.add(action2);
        }
        return children2.toArray(AnAction.EMPTY_ARRAY);
    }
}

