/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindInProjectSearchEngine;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class IdeaIndexBasedFindInProjectSearchEngine
implements FindInProjectSearchEngine {
    @NotNull
    public FindInProjectSearchEngine.FindInProjectSearcher createSearcher(@NotNull FindModel findModel, @NotNull Project project) {
        return new MyFindInProjectSearcher(project, findModel);
    }

    private static final class MyFindInProjectSearcher
    implements FindInProjectSearchEngine.FindInProjectSearcher {
        @NotNull
        private final ProjectFileIndex myFileIndex;
        @NotNull
        private final FileBasedIndexImpl myFileBasedIndex;
        @NotNull
        private final Project myProject;
        @NotNull
        private final FindModel myFindModel;
        private final boolean myHasTrigrams;
        private final String myStringToFindInIndices;

        MyFindInProjectSearcher(@NotNull Project project, @NotNull FindModel findModel) {
            this.myProject = project;
            this.myFindModel = findModel;
            this.myFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
            this.myFileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            String stringToFind = findModel.getStringToFind();
            if (findModel.isRegularExpressions()) {
                stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, project);
            }
            this.myStringToFindInIndices = stringToFind;
            this.myHasTrigrams = MyFindInProjectSearcher.hasTrigrams(this.myStringToFindInIndices);
        }

        @NotNull
        public Collection<VirtualFile> searchForOccurrences() {
            String stringToFind = MyFindInProjectSearcher.getStringToFindInIndexes(this.myFindModel, this.myProject);
            if (stringToFind.isEmpty() || DumbService.getInstance((Project)this.myProject).isDumb() && !FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
                return Collections.emptySet();
            }
            GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)FindInProjectUtil.getScopeFromModel(this.myProject, this.myFindModel), (Project)this.myProject);
            IntOpenHashSet keys2 = new IntOpenHashSet();
            TrigramBuilder.processTrigrams((CharSequence)stringToFind, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((IntSet)keys2){
                final /* synthetic */ IntSet val$keys;
                {
                    this.val$keys = intSet;
                }

                public boolean test(int value2) {
                    this.val$keys.add(value2);
                    return true;
                }
            });
            if (!keys2.isEmpty()) {
                ArrayList hits = new ArrayList();
                FileBasedIndex.getInstance().ignoreDumbMode(() -> MyFindInProjectSearcher.lambda$searchForOccurrences$0((IntSet)keys2, hits, scope), DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE);
                return Collections.unmodifiableCollection(hits);
            }
            HashSet resultFiles = new HashSet();
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)this.myProject);
            helper.processCandidateFilesForText(scope, (short)255, this.myFindModel.isCaseSensitive(), stringToFind, file2 -> {
                ContainerUtil.addIfNotNull((Collection)resultFiles, (Object)file2);
                return true;
            });
            CacheManager cacheManager = CacheManager.getInstance(this.myProject);
            VirtualFile[] filesWithWord = cacheManager.getVirtualFilesWithWord(stringToFind, (short)255, scope, this.myFindModel.isCaseSensitive());
            Collections.addAll(resultFiles, filesWithWord);
            return Collections.unmodifiableCollection(resultFiles);
        }

        public boolean isReliable() {
            if (DumbService.isDumb((Project)this.myProject)) {
                return false;
            }
            if (this.myFindModel.getCustomScope() instanceof LocalSearchScope) {
                return false;
            }
            if (this.myHasTrigrams) {
                return true;
            }
            return this.myFindModel.isWholeWordsOnly() && this.myStringToFindInIndices.indexOf(36) < 0 && !StringUtil.getWordsIn((String)this.myStringToFindInIndices).isEmpty();
        }

        public boolean isCovered(@NotNull VirtualFile file2) {
            return this.myHasTrigrams && this.isCoveredByIndex(file2) && (this.myFileIndex.isInContent(file2) || this.myFileIndex.isInLibrary(file2));
        }

        private boolean isCoveredByIndex(@NotNull VirtualFile file2) {
            FileType fileType = file2.getFileType();
            return TrigramIndex.isIndexable(fileType) && this.myFileBasedIndex.isIndexingCandidate(file2, TrigramIndex.INDEX_ID);
        }

        private static boolean hasTrigrams(@NotNull String text) {
            return !TrigramBuilder.processTrigrams((CharSequence)text, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor(){

                public boolean test(int value2) {
                    return false;
                }
            });
        }

        @NotNull
        private static String getStringToFindInIndexes(@NotNull FindModel findModel, @NotNull Project project) {
            String stringToFind = findModel.getStringToFind();
            if (findModel.isRegularExpressions()) {
                stringToFind = FindInProjectUtil.buildStringToFindForIndicesFromRegExp(stringToFind, project);
            }
            return stringToFind;
        }

        private static /* synthetic */ void lambda$searchForOccurrences$0(IntSet keys2, List hits, GlobalSearchScope scope) {
            FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, (Set)keys2, Processors.cancelableCollectProcessor((Collection)hits), scope);
        }
    }
}

