/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindUsagesHandler
extends FindUsagesHandlerBase
implements FindUsagesHandlerUi {
    @NotNull
    public static final FindUsagesHandler NULL_HANDLER = new NullFindUsagesHandler();

    protected FindUsagesHandler(@NotNull PsiElement psiElement) {
        super(psiElement);
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        return FindUsagesHandler.createDefaultFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab, this);
    }

    @NotNull
    public static AbstractFindUsagesDialog createDefaultFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab, @NotNull FindUsagesHandlerBase handler2) {
        DataContext ctx = DataManager.getInstance().getDataContext();
        return new CommonFindUsagesDialog(handler2.getPsiElement(), handler2.getProject(), handler2.getFindUsagesOptions(ctx), toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @Override
    @Nullable
    public String getHelpId() {
        return FindUsagesManager.getHelpID(this.myPsiElement);
    }

    private static class NullFindUsagesHandler
    extends FindUsagesHandler {
        private NullFindUsagesHandler() {
            super(PsiUtilCore.NULL_PSI_ELEMENT);
        }

        @Override
        @NotNull
        public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
            throw new IncorrectOperationException();
        }

        @Override
        public PsiElement @NotNull [] getPrimaryElements() {
            throw new IncorrectOperationException();
        }

        @Override
        public PsiElement @NotNull [] getSecondaryElements() {
            throw new IncorrectOperationException();
        }

        @Override
        @Nullable
        public String getHelpId() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public FindUsagesOptions getFindUsagesOptions() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean processElementUsages(@NotNull PsiElement element2, @NotNull Processor<? super UsageInfo> processor2, @NotNull FindUsagesOptions options2) {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean processUsagesInText(@NotNull PsiElement element2, @NotNull Processor<? super UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
            throw new IncorrectOperationException();
        }

        @Override
        @Nullable
        protected Collection<String> getStringsToSearch(@NotNull PsiElement element2) {
            throw new IncorrectOperationException();
        }

        @Override
        protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target2, @NotNull SearchScope searchScope) {
            throw new IncorrectOperationException();
        }
    }
}

