/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.Embeddable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleWholeWordsOnlyAction
extends EditorHeaderToggleAction
implements Embeddable {
    public ToggleWholeWordsOnlyAction() {
        super(FindBundle.message("find.whole.words", new Object[0]), AllIcons.Actions.Words, AllIcons.Actions.WordsHovered, AllIcons.Actions.WordsSelected);
    }

    public void update(@NotNull AnActionEvent e) {
        SearchSession session2 = (SearchSession)e.getData(SearchSession.KEY);
        e.getPresentation().setEnabled(session2 != null && !session2.getFindModel().isRegularExpressions());
        e.getPresentation().setVisible(session2 != null && !session2.getFindModel().isMultiline());
        super.update(e);
    }

    @Override
    protected boolean isSelected(@NotNull SearchSession session2) {
        return session2.getFindModel().isWholeWordsOnly();
    }

    @Override
    protected void setSelected(@NotNull SearchSession session2, boolean selected2) {
        FindSettings.getInstance().setLocalWholeWordsOnly(selected2);
        session2.getFindModel().setWholeWordsOnly(selected2);
    }
}

