/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PrevNextOccurrenceAction
extends DumbAwareAction
implements ContextAwareShortcutProvider,
LightEditCompatible {
    protected final boolean mySearch;

    PrevNextOccurrenceAction(@NotNull String templateActionId, boolean search2) {
        this.mySearch = search2;
        ActionUtil.copyFrom((AnAction)this, (String)templateActionId);
    }

    public final void update(@NotNull AnActionEvent e) {
        SearchSession search2 = (SearchSession)e.getData(SearchSession.KEY);
        e.getPresentation().setEnabled(search2 != null && !search2.isSearchInProgress() && search2.hasMatches());
    }

    @Override
    public final ShortcutSet getShortcut(@NotNull DataContext context) {
        SearchSession search2 = (SearchSession)SearchSession.KEY.getData(context);
        boolean singleLine = search2 != null && !search2.getFindModel().isMultiline();
        return Utils.shortcutSetOf(singleLine ? ContainerUtil.concat(this.getDefaultShortcuts(), this.getSingleLineShortcuts()) : this.getDefaultShortcuts());
    }

    @NotNull
    protected abstract List<Shortcut> getDefaultShortcuts();

    @NotNull
    protected abstract List<Shortcut> getSingleLineShortcuts();
}

