/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface ShowUsagesActionHandler {
    public boolean isValid();

    @NotNull
    public UsageSearchPresentation getPresentation();

    @NotNull
    public UsageSearcher createUsageSearcher();

    public void findUsages();

    @Nullable
    public ShowUsagesActionHandler showDialog();

    @NotNull
    public ShowUsagesActionHandler withScope(@NotNull SearchScope var1);

    @NotNull
    public SearchScope getSelectedScope();

    @NotNull
    public SearchScope getMaximalScope();

    @Nullable
    public static String getSecondInvocationTitle(@NotNull ShowUsagesActionHandler actionHandler) {
        KeyboardShortcut shortcut = ShowUsagesAction.getShowUsagesShortcut();
        if (shortcut == null) {
            return null;
        }
        SearchScope maximalScope = actionHandler.getMaximalScope();
        if (actionHandler.getSelectedScope().equals(maximalScope)) {
            return null;
        }
        return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcut) + " again to search in " + maximalScope.getDisplayName();
    }
}

