/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.FindUsagesKt;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.usages.SearchTarget;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindUsagesAction
extends AnAction {
    public FindUsagesAction() {
        this.setInjectedContext(true);
    }

    protected boolean toShowDialog() {
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DataContext dataContext = e.getDataContext();
        if (Registry.is((String)"ide.symbol.find.usages")) {
            this.findSymbolUsages(project, dataContext);
        } else {
            this.findUsageTargetUsages(project, dataContext);
        }
    }

    private void findSymbolUsages(final @NotNull Project project, final @NotNull DataContext dataContext) {
        ResolverKt.findShowUsages(project, dataContext, FindBundle.message("find.usages.ambiguous.title", new Object[0]), new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                SearchScope searchScope = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
                FindUsagesKt.findUsages(FindUsagesAction.this.toShowDialog(), project, searchScope, target2);
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                FindUsagesAction.this.startFindUsages(element2);
            }
        });
    }

    private void findUsageTargetUsages(@NotNull Project project, @NotNull DataContext dataContext) {
        UsageTarget[] usageTargets = (UsageTarget[])dataContext.getData(UsageView.USAGE_TARGETS_KEY);
        if (usageTargets == null) {
            Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
                this.startFindUsages(element2);
                return false;
            }));
        } else {
            UsageTarget target2 = usageTargets[0];
            if (target2 instanceof PsiElementUsageTarget) {
                PsiElement element3 = ((PsiElementUsageTarget)target2).getElement();
                if (element3 != null) {
                    this.startFindUsages(element3);
                }
            } else {
                target2.findUsages();
            }
        }
    }

    protected void startFindUsages(@NotNull PsiElement element2) {
        FindManager.getInstance((Project)element2.getProject()).findUsages(element2);
    }

    public void update(@NotNull AnActionEvent event) {
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    static void chooseAmbiguousTargetAndPerform(@NotNull Project project, Editor editor, @NotNull PsiElementProcessor<? super PsiElement> processor2) {
        if (editor == null) {
            Messages.showMessageDialog((Project)project, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            int offset = editor.getCaretModel().getOffset();
            boolean chosen = GotoDeclarationAction.chooseAmbiguousTarget(project, editor, offset, processor2, FindBundle.message("find.usages.ambiguous.title", new Object[0]), null);
            if (!chosen) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor.isDisposed() || !EditorActivityManager.getInstance().isVisible(editor)) {
                        return;
                    }
                    HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
                }, project.getDisposed());
            }
        }
    }

    public static class ShowSettingsAndFindUsages
    extends FindUsagesAction {
        @Override
        protected void startFindUsages(@NotNull PsiElement element2) {
            FindManager.getInstance((Project)element2.getProject()).findUsages(element2, true);
        }

        @Override
        protected boolean toShowDialog() {
            return true;
        }
    }
}

