/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindAllAction
extends AnAction
implements ShortcutProvider,
DumbAware {
    public FindAllAction() {
        super(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.description", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        EditorSearchSession search2 = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        e.getPresentation().setIcon(FindAllAction.getIcon(project));
        e.getPresentation().setEnabled(editor != null && project != null && search2 != null && !project.isDisposed() && search2.hasMatches() && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        EditorSearchSession search2 = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        if (project.isDisposed()) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return;
        }
        FindModel oldModel = FindManager.getInstance((Project)project).getFindInFileModel();
        FindModel newModel = oldModel.clone();
        String text = search2.getTextInField();
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        newModel.setStringToFind(text);
        FindUtil.findAllAndShow(project, file2, newModel);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        AnAction findUsages2 = ActionManager.getInstance().getAction("FindUsages");
        return findUsages2 != null ? findUsages2.getShortcutSet() : null;
    }

    @NotNull
    private static Icon getIcon(@Nullable Project project) {
        ToolWindowManager toolWindowManager;
        ToolWindowManager toolWindowManager2 = toolWindowManager = project != null ? ToolWindowManager.getInstance((Project)project) : null;
        if (toolWindowManager != null) {
            return toolWindowManager.getLocationIcon("Find", AllIcons.General.Pin_tab);
        }
        return AllIcons.General.Pin_tab;
    }
}

