/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.FindAllAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleAnywhereAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAndLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleInCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleInLiteralsOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchSession
implements SearchSession,
DataProvider,
SelectionListener,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    private static final String FIND_TYPE = "FindInFile";
    public static final DataKey<EditorSearchSession> SESSION_KEY = DataKey.create((String)"EditorSearchSession");
    public static final Logger SELECTION_UPDATE_LOGGER = Logger.getInstance((String)"com.intellij.find.selection");
    private final Editor myEditor;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    @NotNull
    private final FindModel myFindModel;
    private final SearchReplaceComponent myComponent;
    private RangeMarker myStartSessionSelectionMarker;
    private RangeMarker myStartSessionCaretMarker;
    private String myStartSelectedText;
    private boolean mySelectionUpdatedFromSearchResults;
    private final LinkLabel<Object> myClickToHighlightLabel = new LinkLabel(FindBundle.message("link.click.to.highlight", new Object[0]), null, (__, ___) -> {
        this.setMatchesLimit(Integer.MAX_VALUE);
        this.updateResults(true);
    });
    private final Disposable myDisposable = Disposer.newDisposable((String)EditorSearchSession.class.getName());

    public EditorSearchSession(@NotNull Editor editor, Project project) {
        this(editor, project, EditorSearchSession.createDefaultFindModel(project, editor));
    }

    public EditorSearchSession(final @NotNull Editor editor, Project project, @NotNull FindModel findModel) {
        assert (!editor.isDisposed());
        this.myClickToHighlightLabel.setVisible(false);
        this.myFindModel = findModel;
        this.myEditor = editor;
        this.saveInitialSelection();
        this.mySearchResults = new SearchResults(this.myEditor, project);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this, this.myDisposable);
        this.myComponent = SearchReplaceComponent.buildFor(project, this.myEditor.getContentComponent()).addPrimarySearchActions(this.createPrimarySearchActions()).addSecondarySearchActions(this.createSecondarySearchActions()).addPrimarySearchActions(new AnAction[]{new ToggleSelectionOnlyAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleWholeWordsOnlyAction(), new ToggleRegex(), new DefaultCustomComponentAction(() -> this.myClickToHighlightLabel)}).addSearchFieldActions(new RestorePreviousSettingsAction()).addPrimaryReplaceActions(new AnAction[]{new ReplaceAction(), new ReplaceAllAction(), new ExcludeAction()}).addExtraReplaceAction(new AnAction[]{new TogglePreserveCaseAction()}).addReplaceFieldActions(new AnAction[]{new PrevOccurrenceAction(false), new NextOccurrenceAction(false)}).withDataProvider(this).withCloseAction(this::close).withReplaceAction(this::replaceCurrent).withSecondarySearchActionsIsModifiedGetter(() -> this.myFindModel.getSearchContext() != FindModel.SearchContext.ANY).build();
        this.myComponent.addListener(this);
        new UiNotifyConnector((Component)this.myComponent, new Activatable(){

            public void showNotify() {
                EditorSearchSession.this.initLivePreview();
            }

            public void hideNotify() {
                EditorSearchSession.this.myLivePreviewController.off();
                EditorSearchSession.this.mySearchResults.removeListener(EditorSearchSession.this);
            }
        });
        new SwitchToFind(this.getComponent());
        new SwitchToReplace(this.getComponent());
        this.myFindModel.addObserver(new FindModel.FindModelObserver(){
            boolean myReentrantLock = false;
            boolean myIsGlobal = EditorSearchSession.access$300(EditorSearchSession.this).isGlobal();
            boolean myIsReplace = EditorSearchSession.access$300(EditorSearchSession.this).isReplaceState();

            public void findModelChanged(FindModel findModel1) {
                if (this.myReentrantLock) {
                    return;
                }
                try {
                    this.myReentrantLock = true;
                    String stringToFind = EditorSearchSession.this.myFindModel.getStringToFind();
                    if (!EditorSearchSession.wholeWordsApplicable(stringToFind)) {
                        EditorSearchSession.this.myFindModel.setWholeWordsOnly(false);
                    }
                    if (this.myIsGlobal != EditorSearchSession.this.myFindModel.isGlobal() || this.myIsReplace != EditorSearchSession.this.myFindModel.isReplaceState()) {
                        if (EditorSearchSession.this.myFindModel.getStringToFind().isEmpty() && EditorSearchSession.this.myFindModel.isGlobal()) {
                            EditorSearchSession.this.myFindModel.setStringToFind(StringUtil.notNullize((String)EditorSearchSession.this.myEditor.getSelectionModel().getSelectedText()));
                        }
                        if (!EditorSearchSession.this.myFindModel.isGlobal()) {
                            if (EditorSearchSession.this.myFindModel.getStringToFind().equals(EditorSearchSession.this.myStartSelectedText)) {
                                EditorSearchSession.this.myFindModel.setStringToFind("");
                            } else {
                                EditorSearchSession.this.restoreInitialCaretPositionAndSelection();
                            }
                        }
                        this.myIsGlobal = EditorSearchSession.this.myFindModel.isGlobal();
                        this.myIsReplace = EditorSearchSession.this.myFindModel.isReplaceState();
                    }
                    EditorSearchSession.this.updateUIWithFindModel();
                    EditorSearchSession.this.mySearchResults.clear();
                    EditorSearchSession.this.updateResults(true);
                    FindUtil.updateFindInFileModel(EditorSearchSession.this.getProject(), EditorSearchSession.this.myFindModel, !ConsoleViewUtil.isConsoleViewEditor(editor));
                }
                finally {
                    this.myReentrantLock = false;
                }
            }
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
        this.updateMultiLineStateIfNeeded();
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event.getEditor() == EditorSearchSession.this.myEditor) {
                    Disposer.dispose((Disposable)EditorSearchSession.this.myDisposable);
                    EditorSearchSession.this.myLivePreviewController.dispose();
                    EditorSearchSession.this.myStartSessionSelectionMarker.dispose();
                    EditorSearchSession.this.myStartSessionCaretMarker.dispose();
                }
            }
        }, this.myDisposable);
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this, this.myDisposable);
        FindUtil.triggerUsedOptionsStats(FIND_TYPE, findModel);
    }

    @NotNull
    protected AnAction[] createPrimarySearchActions() {
        return new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction(), new FindAllAction(), new Separator(), new AddOccurrenceAction(), new RemoveOccurrenceAction(), new SelectAllAction(), new Separator()};
    }

    @NotNull
    protected AnAction[] createSecondarySearchActions() {
        return new AnAction[]{new ToggleAnywhereAction(), new ToggleInCommentsAction(), new ToggleInLiteralsOnlyAction(), new ToggleExceptCommentsAction(), new ToggleExceptLiteralsAction(), new ToggleExceptCommentsAndLiteralsAction()};
    }

    private void saveInitialSelection() {
        if (this.mySelectionUpdatedFromSearchResults) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        Document document = this.myEditor.getDocument();
        this.myStartSessionSelectionMarker = document.createRangeMarker(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        this.myStartSessionCaretMarker = document.createRangeMarker(this.myEditor.getCaretModel().getOffset(), this.myEditor.getCaretModel().getOffset());
        this.myStartSelectedText = selectionModel.getSelectedText();
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public static EditorSearchSession get(@Nullable Editor editor) {
        JComponent headerComponent = editor != null ? editor.getHeaderComponent() : null;
        SearchReplaceComponent searchReplaceComponent2 = (SearchReplaceComponent)ObjectUtils.tryCast((Object)headerComponent, SearchReplaceComponent.class);
        return searchReplaceComponent2 != null ? (EditorSearchSession)SESSION_KEY.getData((DataProvider)searchReplaceComponent2) : null;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @Nullable Project project) {
        EditorSearchSession session2 = new EditorSearchSession(editor, project);
        editor.setHeaderComponent((JComponent)session2.getComponent());
        return session2;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @NotNull FindModel findModel, @Nullable Project project) {
        EditorSearchSession session2 = new EditorSearchSession(editor, project, findModel);
        editor.setHeaderComponent((JComponent)session2.getComponent());
        return session2;
    }

    @Override
    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.myComponent;
    }

    public Project getProject() {
        return this.myComponent.getProject();
    }

    @NotNull
    private static FindModel createDefaultFindModel(Project project, Editor editor) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)project).getFindInFileModel());
        if (editor.getSelectionModel().hasSelection() && (selectedText = editor.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        return findModel;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        if (SESSION_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myFindModel.isReplaceState() ? "Replace_the_found_target" : "ixFindText";
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(@NotNull SearchResults sr) {
        if (sr.getFindModel() == null) {
            return;
        }
        if (this.myComponent.getSearchTextComponent().getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            String status;
            boolean tooManyMatches;
            int matches2 = sr.getMatchesCount();
            boolean bl = tooManyMatches = matches2 > this.mySearchResults.getMatchesLimit();
            if (matches2 == 0 && !sr.getFindModel().isGlobal() && !this.myEditor.getSelectionModel().hasSelection()) {
                status = ApplicationBundle.message((String)"editorsearch.noselection", (Object[])new Object[0]);
                this.myComponent.setRegularBackground();
            } else {
                int cursorIndex = sr.getCursorVisualIndex();
                String string = tooManyMatches ? ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])new Object[]{this.mySearchResults.getMatchesLimit()}) : (status = cursorIndex != -1 ? ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])new Object[]{cursorIndex, matches2}) : ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{matches2}));
                if (!tooManyMatches && matches2 <= 0) {
                    this.myComponent.setNotFoundBackground();
                } else {
                    this.myComponent.setRegularBackground();
                }
            }
            this.myComponent.setStatusText(status);
            this.myClickToHighlightLabel.setVisible(tooManyMatches);
        }
        this.myComponent.updateActions();
    }

    @Override
    public void cursorMoved() {
        this.myComponent.updateActions();
    }

    @Override
    public void searchFieldDocumentChanged() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.setMatchesLimit(10000);
        String text = this.myComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(text);
        this.updateResults(true);
        this.updateMultiLineStateIfNeeded();
    }

    private void updateMultiLineStateIfNeeded() {
        this.myFindModel.setMultiline(this.myComponent.getSearchTextComponent().getText().contains("\n") || this.myComponent.getReplaceTextComponent().getText().contains("\n"));
    }

    @Override
    public void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myComponent.getReplaceTextComponent().getText());
        this.updateMultiLineStateIfNeeded();
    }

    @Override
    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.myComponent.isMultiline());
    }

    @Override
    @NotNull
    public FindModel getFindModel() {
        return this.myFindModel;
    }

    @Override
    public boolean hasMatches() {
        return this.mySearchResults.hasMatches();
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchResults.isUpdating();
    }

    @Override
    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    @Override
    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    private void updateUIWithFindModel() {
        this.myComponent.update(this.myFindModel.getStringToFind(), this.myFindModel.getStringToReplace(), this.myFindModel.isReplaceState(), this.myFindModel.isMultiline());
        this.updateEmptyText();
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
    }

    private void updateEmptyText() {
        if (this.myComponent.getSearchTextComponent() instanceof ComponentWithEmptyText) {
            String emptyText = this.getEmptyText();
            ((ComponentWithEmptyText)this.myComponent.getSearchTextComponent()).getEmptyText().setText(emptyText);
        }
    }

    @NotNull
    private String getEmptyText() {
        if (this.myFindModel.isGlobal() || !this.myFindModel.getStringToFind().isEmpty()) {
            return "";
        }
        String text = this.getEditor().getSelectionModel().getSelectedText();
        if (text != null && text.contains("\n")) {
            boolean replaceState = this.myFindModel.isReplaceState();
            AnAction action2 = ActionManager.getInstance().getAction(replaceState ? "Replace" : "ToggleFindInSelection");
            Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])action2.getShortcutSet().getShortcuts());
            if (shortcut != null) {
                return ApplicationBundle.message((String)"editorsearch.in.selection.with.hint", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)});
            }
        }
        return ApplicationBundle.message((String)"editorsearch.in.selection", (Object[])new Object[0]);
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value2) {
        this.mySearchResults.setMatchesLimit(value2);
    }

    private void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            try {
                this.myLivePreviewController.performReplace();
            }
            catch (FindManager.MalformedReplacementStringException e) {
                Messages.showErrorDialog((Component)this.myComponent, (String)e.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
            }
        }
    }

    public void addTextToRecent(JTextComponent textField2) {
        this.myComponent.addTextToRecent(textField2);
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        this.saveInitialSelection();
        this.updateEmptyText();
    }

    @Override
    public void beforeSelectionUpdate() {
        this.mySelectionUpdatedFromSearchResults = true;
    }

    @Override
    public void afterSelectionUpdate() {
        this.mySelectionUpdatedFromSearchResults = false;
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    @Override
    public void close() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    private void initLivePreview() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        String text = this.myFindModel.getStringToFind();
        if (text.isEmpty()) {
            this.nothingToSearchFor(allowedToChangedEditorSelection);
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text);
                }
                catch (PatternSyntaxException e) {
                    this.myComponent.setNotFoundBackground();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    this.myComponent.setStatusText(INCORRECT_REGEX_MESSAGE);
                    return;
                }
                if (text.matches("\\|+")) {
                    this.nothingToSearchFor(allowedToChangedEditorSelection);
                    this.myComponent.setStatusText(ApplicationBundle.message((String)"editorsearch.empty.string.matches", (Object[])new Object[0]));
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance((Project)this.getProject());
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy2 = new FindModel();
                copy2.copyFrom(this.myFindModel);
                copy2.setReplaceState(false);
                findManager.setFindNextModel(copy2);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor(boolean allowedToChangedEditorSelection) {
        this.updateUIWithEmptyResults();
        this.mySearchResults.clear();
        if (allowedToChangedEditorSelection && !UIUtil.isClientPropertyTrue((Object)this.myComponent.getSearchTextComponent(), (Object)"JUST_CLEARED")) {
            this.restoreInitialCaretPositionAndSelection();
        }
    }

    private void restoreInitialCaretPositionAndSelection() {
        int originalSelectionStart = Math.min(this.myStartSessionSelectionMarker.getStartOffset(), this.myEditor.getDocument().getTextLength());
        int originalSelectionEnd = Math.min(this.myStartSessionSelectionMarker.getEndOffset(), this.myEditor.getDocument().getTextLength());
        this.myEditor.getSelectionModel().setSelection(originalSelectionStart, originalSelectionEnd);
        this.myEditor.getCaretModel().moveToOffset(Math.min(this.myStartSessionCaretMarker.getEndOffset(), this.myEditor.getDocument().getTextLength()));
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorSearchSession.logSelectionUpdate();
    }

    public static void logSelectionUpdate() {
        if (SELECTION_UPDATE_LOGGER.isDebugEnabled()) {
            SELECTION_UPDATE_LOGGER.debug(new Throwable());
        }
    }

    private void updateUIWithEmptyResults() {
        this.myComponent.setRegularBackground();
        this.myComponent.setStatusText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{0}));
        this.myClickToHighlightLabel.setVisible(false);
    }

    public String getTextInField() {
        return this.myComponent.getSearchTextComponent().getText();
    }

    public void setTextInField(String text) {
        this.myComponent.getSearchTextComponent().setText(text);
        this.myFindModel.setStringToFind(text);
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        this.myComponent.resetUndoRedoActions();
    }

    private class ExcludeAction
    extends ButtonAction
    implements LightEditCompatible {
        ExcludeAction() {
            super("", 'l');
        }

        @Override
        protected void update(@NotNull JButton button2) {
            FindResult cursor = EditorSearchSession.this.mySearchResults.getCursor();
            button2.setEnabled(cursor != null);
            button2.setText(cursor != null && EditorSearchSession.this.mySearchResults.isExcluded(cursor) ? FindBundle.message("button.include", new Object[0]) : FindBundle.message("button.exclude", new Object[0]));
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.exclude();
            EditorSearchSession.this.moveCursor(SearchResults.Direction.DOWN);
        }
    }

    private class ReplaceAllAction
    extends ButtonAction
    implements LightEditCompatible {
        ReplaceAllAction() {
            super("Replace all", 'a');
        }

        @Override
        protected void update(@NotNull JButton button2) {
            button2.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.performReplaceAll();
        }
    }

    private class ReplaceAction
    extends ButtonAction
    implements LightEditCompatible {
        ReplaceAction() {
            super("Replace", 'p');
        }

        @Override
        protected void update(@NotNull JButton button2) {
            button2.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.replaceCurrent();
        }
    }

    private static abstract class ButtonAction
    extends DumbAwareAction
    implements CustomComponentAction,
    ActionListener {
        private final String myTitle;
        private final char myMnemonic;

        ButtonAction(@NotNull String title, char mnemonic) {
            this.myTitle = title;
            this.myMnemonic = mnemonic;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            JButton button2 = new JButton(this.myTitle);
            button2.setFocusable(false);
            if (!UISettings.getInstance().getDisableMnemonicsInControls()) {
                button2.setMnemonic(this.myMnemonic);
            }
            button2.setBorder(new DarculaButtonPainter(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return JBUI.insets((int)1);
                }
            });
            button2.addActionListener(this);
            return button2;
        }

        public final void update(@NotNull AnActionEvent e) {
            JButton button2 = (JButton)e.getPresentation().getClientProperty(COMPONENT_KEY);
            if (button2 != null) {
                this.update(button2);
            }
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            this.onClick();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.onClick();
        }

        protected abstract void update(@NotNull JButton var1);

        protected abstract void onClick();
    }
}

