/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    public static <F extends Facet> F addFacet(Module module, FacetType<F, ?> type) {
        return FacetUtil.addFacet(module, type, type.getPresentableName());
    }

    public static <F extends Facet> F addFacet(@NotNull Module module, @NotNull FacetType<F, ?> type, @NotNull String facetName) {
        ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
        Object facet = FacetUtil.createFacet(module, type, facetName);
        ApplicationManager.getApplication().runWriteAction(() -> {
            model.addFacet(facet);
            model.commit();
        });
        return facet;
    }

    private static <F extends Facet, C extends FacetConfiguration> F createFacet(Module module, FacetType<F, C> type, @NotNull String facetName) {
        return (F)FacetManager.getInstance((Module)module).createFacet(type, facetName, type.createDefaultConfiguration(), null);
    }

    public static void deleteFacet(Facet facet) {
        WriteAction.runAndWait(() -> {
            if (!FacetUtil.isRegistered(facet)) {
                return;
            }
            ModifiableFacetModel model = FacetManager.getInstance((Module)facet.getModule()).createModifiableModel();
            model.removeFacet(facet);
            model.commit();
        });
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance((Module)facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration, @Nullable Element config2) throws InvalidDataException {
        if (config2 != null) {
            if (configuration instanceof PersistentStateComponent) {
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)((PersistentStateComponent)configuration), (Element)config2);
            } else {
                configuration.readExternal(config2);
            }
        }
    }

    @NotNull
    public static Element saveFacetConfiguration(@NotNull FacetConfiguration configuration) {
        if (configuration instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)configuration).getState();
            if (state instanceof Element) {
                return (Element)state;
            }
            Element result2 = XmlSerializer.serialize((Object)state);
            return result2 == null ? new Element("configuration") : result2;
        }
        Element config2 = new Element("configuration");
        configuration.writeExternal(config2);
        return config2;
    }

    @ApiStatus.Internal
    @Nullable
    public static Element saveFacetConfiguration(Facet<?> facet) {
        Element config2;
        try {
            FacetConfiguration configuration = facet.getConfiguration();
            config2 = FacetUtil.saveFacetConfiguration(configuration);
            if (facet instanceof JDOMExternalizable) {
                ((JDOMExternalizable)facet).writeExternal(config2);
            }
        }
        catch (WriteExternalException e) {
            return null;
        }
        return config2;
    }
}

