/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerImpl;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FacetModelImpl
extends FacetModelBase
implements ModifiableFacetModel {
    private static final Logger LOG = Logger.getInstance(FacetModelImpl.class);
    private final List<Facet<?>> myFacets = new ArrayList();
    private final Map<Facet<?>, String> myFacet2NewName = new HashMap();
    private final FacetManagerImpl myManager;
    private final List<ModifiableFacetModel.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public FacetModelImpl(@NotNull FacetManagerImpl manager) {
        this.myManager = manager;
    }

    public void addFacetsFromManager() {
        for (Facet<?> facet : this.myManager.getAllFacets()) {
            this.addFacet(facet);
        }
    }

    public void addFacet(Facet<?> facet) {
        if (this.myFacets.contains(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] is already added");
        }
        this.myFacets.add(facet);
        this.facetsChanged();
    }

    public void addFacet(Facet<?> facet, @Nullable ProjectModelExternalSource externalSource) {
        this.addFacet(facet);
        FacetManagerImpl.setExternalSource(facet, externalSource);
    }

    public void removeFacet(Facet<?> facet) {
        if (!this.myFacets.remove(facet)) {
            LOG.error("Facet " + facet + " [" + facet.getTypeId() + "] not found");
        }
        this.myFacet2NewName.remove(facet);
        this.facetsChanged();
    }

    public void replaceFacet(@NotNull Facet<?> original, @NotNull Facet<?> replacement) {
        int index = this.myFacets.indexOf(original);
        if (index != -1) {
            this.myFacets.set(index, replacement);
            this.facetsChanged();
        }
    }

    public void rename(Facet<?> facet, String newName) {
        if (!newName.equals(facet.getName())) {
            this.myFacet2NewName.put(facet, newName);
        } else {
            this.myFacet2NewName.remove(facet);
        }
        this.facetsChanged();
    }

    @Nullable
    public String getNewName(Facet<?> facet) {
        return this.myFacet2NewName.get(facet);
    }

    public void commit() {
        this.myManager.commit(this);
    }

    public boolean isModified() {
        return !new HashSet(this.myFacets).equals(ContainerUtil.set((Object[])this.myManager.getAllFacets())) || !this.myFacet2NewName.isEmpty();
    }

    public boolean isNewFacet(Facet<?> facet) {
        return this.myFacets.contains(facet) && ArrayUtil.find((Object[])this.myManager.getAllFacets(), facet) == -1;
    }

    public Facet<?> @NotNull [] getAllFacets() {
        return this.myFacets.toArray(Facet.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        return this.myFacet2NewName.containsKey(facet) ? this.myFacet2NewName.get(facet) : facet.getName();
    }

    public void addListener(@NotNull ModifiableFacetModel.Listener listener2, @NotNull Disposable parentDisposable) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myListeners.remove(listener2));
    }

    @Override
    protected void facetsChanged() {
        super.facetsChanged();
        for (ModifiableFacetModel.Listener each : this.myListeners) {
            each.onChanged();
        }
    }
}

