/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFromExternalSourcesStorage;
import com.intellij.facet.FacetManagerBase;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetEventsPublisher;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetModelImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@State(name="FacetManager", useLoadedStateAsExisting=false)
@ApiStatus.Internal
public final class FacetManagerImpl
extends FacetManagerBase
implements ModuleComponent,
PersistentStateComponent<FacetManagerState> {
    private static final Logger LOG = Logger.getInstance(FacetManagerImpl.class);
    private final Module myModule;
    private final FacetManagerModel myModel = new FacetManagerModel();
    private boolean myInsideCommit;
    private boolean myModuleAdded;
    private final FacetFromExternalSourcesStorage myExternalSourcesStorage;

    public FacetManagerImpl(@NotNull Module module) {
        this.myModule = module;
        this.myExternalSourcesStorage = FacetFromExternalSourcesStorage.getInstance(module);
    }

    @NotNull
    public ModifiableFacetModel createModifiableModel() {
        FacetModelImpl model = new FacetModelImpl(this);
        model.addFacetsFromManager();
        return model;
    }

    @Override
    protected FacetModel getModel() {
        return this.myModel;
    }

    @Override
    protected Module getModule() {
        return this.myModule;
    }

    private void addFacets(List<? extends FacetState> facetStates, Facet<?> underlyingFacet, ModifiableFacetModel model) {
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        for (FacetState facetState : facetStates) {
            FacetType actualUnderlyingType;
            String typeId = facetState.getFacetType();
            if (typeId == null) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message((String)"error.message.facet.type.isn.t.specified", (Object[])new Object[0]));
                continue;
            }
            FacetType type = registry.findFacetType(typeId);
            if (type == null) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{typeId}), true);
                continue;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            if (!type.isSuitableModuleType(moduleType)) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facets.are.not.allowed.in.1", (Object[])new Object[]{type.getPresentableName(), moduleType.getName()}));
                continue;
            }
            FacetType expectedUnderlyingType = null;
            FacetTypeId underlyingTypeId = type.getUnderlyingFacetType();
            if (underlyingTypeId != null) {
                expectedUnderlyingType = registry.findFacetType(underlyingTypeId);
            }
            FacetType facetType = actualUnderlyingType = underlyingFacet != null ? underlyingFacet.getType() : null;
            if (expectedUnderlyingType != null) {
                if (!expectedUnderlyingType.equals(actualUnderlyingType)) {
                    this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facet.must.be.placed.under.1.facet", (Object[])new Object[]{type.getPresentableName(), expectedUnderlyingType.getPresentableName()}));
                    continue;
                }
            } else if (actualUnderlyingType != null) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.cannot.be.placed.under.1", (Object[])new Object[]{type.getPresentableName(), actualUnderlyingType.getPresentableName()}));
                continue;
            }
            try {
                this.addFacet(type, facetState, underlyingFacet, model);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message((String)"error.message.cannot.load.facet.configuration.0", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet<?> underlyingFacet, String errorMessage) {
        this.addInvalidFacet(state, model, underlyingFacet, errorMessage, false);
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet<?> underlyingFacet, String errorMessage, boolean unknownType) {
        model.addFacet((Facet)FacetManagerImpl.createInvalidFacet(this.getModule(), state, underlyingFacet, errorMessage, unknownType, true));
    }

    private <F extends Facet<C>, C extends FacetConfiguration> void addFacet(FacetType<F, C> type, FacetState state, Facet<?> underlyingFacet, ModifiableFacetModel model) throws InvalidDataException {
        Element newConfiguration;
        Collection facetsOfThisType;
        Collection collection = facetsOfThisType = underlyingFacet == null ? model.getFacetsByType(type.getId()) : model.getFacetsByType(underlyingFacet, type.getId());
        if (type.isOnlyOneFacetAllowed() && !facetsOfThisType.isEmpty() && facetsOfThisType.stream().anyMatch(f -> !f.getName().equals(state.getName()))) {
            LOG.info("'" + state.getName() + "' facet removed from module " + this.myModule.getName() + ", because only one " + type.getPresentableName() + " facet allowed");
            return;
        }
        Facet facet = null;
        if (!facetsOfThisType.isEmpty() && ProjectUtilCore.isExternalStorageEnabled((Project)this.myModule.getProject()) && (facet = (Facet)facetsOfThisType.stream().filter(f -> f.getName().equals(state.getName())).findFirst().orElse(null)) != null && (newConfiguration = state.getConfiguration()) != null) {
            FacetUtil.loadFacetConfiguration(facet.getConfiguration(), newConfiguration);
        }
        if (facet == null) {
            facet = (Facet)FacetManagerImpl.createFacetFromState(this.getModule(), type, state, underlyingFacet);
            model.addFacet(facet);
        }
        this.addFacets(state.subFacets, facet, model);
    }

    @ApiStatus.Internal
    @NotNull
    public static Facet<?> createFacetFromStateRaw(@NotNull Module module, @NotNull FacetType<?, ?> type, @NotNull FacetState state, @Nullable Facet<?> underlyingFacet) {
        return FacetManagerImpl.createFacetFromState(module, type, state, underlyingFacet);
    }

    @NotNull
    private static <F extends Facet<C>, C extends FacetConfiguration> F createFacetFromState(Module module, FacetType<F, C> type, FacetState state, Facet<?> underlyingFacet) {
        String externalSystemId;
        FacetConfiguration configuration = type.createDefaultConfiguration();
        Element config2 = state.getConfiguration();
        FacetUtil.loadFacetConfiguration(configuration, config2);
        String name = state.getName();
        F facet = FacetManagerImpl.createFacet(module, type, name, configuration, underlyingFacet);
        if (facet instanceof JDOMExternalizable) {
            ((JDOMExternalizable)facet).readExternal(config2);
        }
        if ((externalSystemId = state.getExternalSystemId()) != null) {
            facet.setExternalSource(ExternalProjectSystemRegistry.getInstance().getSourceById(externalSystemId));
        }
        return facet;
    }

    public void noStateLoaded() {
        this.doLoadState(null);
    }

    public void loadState(@NotNull FacetManagerState state) {
        this.doLoadState(state);
    }

    private void doLoadState(@Nullable FacetManagerState state) {
        FacetModelImpl model = new FacetModelImpl(this);
        FacetManagerState importedFacetsState = this.myExternalSourcesStorage.getLoadedState();
        this.addFacets(ContainerUtil.concat((List)(state == null ? Collections.emptyList() : state.facets), (List)importedFacetsState.facets), null, model);
        this.commit(model, false);
    }

    @NotNull
    public FacetManagerState getState() {
        return this.saveState(FacetManagerImpl.getImportedFacetPredicate(this.myModule.getProject()).negate());
    }

    @NotNull
    static Predicate<Facet<?>> getImportedFacetPredicate(@NotNull Project project) {
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            return facet -> facet.getExternalSource() != null;
        }
        return facet -> false;
    }

    @NotNull
    FacetManagerState saveState(@NotNull Predicate<? super Facet<?>> filter2) {
        FacetManagerState managerState = new FacetManagerState();
        Facet<?>[] facets2 = this.getSortedFacets();
        HashMap states = new HashMap();
        states.put(null, managerState.facets);
        for (Facet<?> facet : facets2) {
            if (!filter2.test(facet)) continue;
            Facet underlyingFacet = facet.getUnderlyingFacet();
            FacetState facetState = FacetManagerImpl.saveFacetConfiguration(facet);
            if (facetState == null) continue;
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet, states, this.myModule.getProject()).add(facetState);
            states.put(facet, facetState.subFacets);
        }
        return managerState;
    }

    @ApiStatus.Internal
    @Nullable
    public static FacetState saveFacetConfiguration(Facet<?> facet) {
        FacetState facetState = FacetManagerImpl.createFacetState(facet, facet.getModule().getProject());
        if (!(facet instanceof InvalidFacet)) {
            Element config2 = FacetUtil.saveFacetConfiguration(facet);
            if (config2 == null) {
                return null;
            }
            facetState.setConfiguration(config2);
        }
        return facetState;
    }

    private static List<FacetState> getOrCreateTargetFacetList(Facet<?> underlyingFacet, Map<Facet<?>, List<FacetState>> states, @NotNull Project project) {
        List facetStateList = states.get(underlyingFacet);
        if (facetStateList == null) {
            FacetState state = FacetManagerImpl.createFacetState(underlyingFacet, project);
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet.getUnderlyingFacet(), states, project).add(state);
            facetStateList = state.subFacets;
            states.put(underlyingFacet, facetStateList);
        }
        return facetStateList;
    }

    private static FacetState createFacetState(@NotNull Facet<?> facet, @NotNull Project project) {
        if (facet instanceof InvalidFacet) {
            return ((InvalidFacetConfiguration)((InvalidFacet)facet).getConfiguration()).getFacetState();
        }
        FacetState facetState = new FacetState();
        ProjectModelExternalSource externalSource = facet.getExternalSource();
        if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)project)) {
            facetState.setExternalSystemId(externalSource.getId());
        }
        facetState.setFacetType(facet.getType().getStringId());
        facetState.setName(facet.getName());
        return facetState;
    }

    public void commit(ModifiableFacetModel model) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.commit(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ModifiableFacetModel model, boolean fireEvents) {
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        Set toRemove2 = ContainerUtil.set((Object[])this.getAllFacets());
        ArrayList<Facet> toAdd = new ArrayList<Facet>();
        ArrayList<FacetRenameInfo> toRename = new ArrayList<FacetRenameInfo>();
        try {
            this.myInsideCommit = true;
            for (Facet facet : model.getAllFacets()) {
                boolean isNew;
                boolean bl = isNew = !toRemove2.remove(facet);
                if (!isNew) continue;
                toAdd.add(facet);
            }
            Iterator newFacets = new ArrayList<Object>();
            for (Facet<?> facet : this.getAllFacets()) {
                if (toRemove2.contains(facet)) continue;
                newFacets.add(facet);
            }
            newFacets.addAll(toAdd);
            Iterator iterator2 = newFacets.iterator();
            while (iterator2.hasNext()) {
                Facet facet = (Facet)iterator2.next();
                String newName = model.getNewName(facet);
                if (newName == null || newName.equals(facet.getName())) continue;
                toRename.add(new FacetRenameInfo(facet, facet.getName(), newName));
            }
            if (fireEvents) {
                FacetEventsPublisher facetEventsPublisher = FacetEventsPublisher.getInstance(this.myModule.getProject());
                for (Facet facet : toAdd) {
                    facetEventsPublisher.fireBeforeFacetAdded(facet);
                }
                for (Facet facet : toRemove2) {
                    facetEventsPublisher.fireBeforeFacetRemoved(facet);
                }
                for (FacetRenameInfo info : toRename) {
                    facetEventsPublisher.fireBeforeFacetRenamed(info.myFacet);
                }
            }
            for (FacetRenameInfo info : toRename) {
                FacetManagerImpl.setFacetName(info.myFacet, info.myNewName);
            }
            this.myModel.setAllFacets(newFacets.toArray(Facet.EMPTY_ARRAY));
        }
        finally {
            this.myInsideCommit = false;
        }
        if (this.myModuleAdded) {
            for (Facet facet : toAdd) {
                facet.initFacet();
            }
        }
        for (Facet facet : toRemove2) {
            Disposer.dispose((Disposable)facet);
        }
        if (fireEvents) {
            FacetEventsPublisher publisher = FacetEventsPublisher.getInstance(this.myModule.getProject());
            for (Facet facet : toAdd) {
                publisher.fireFacetAdded(facet);
            }
            for (Facet facet : toRemove2) {
                publisher.fireFacetRemoved(this.myModule, facet);
            }
            for (FacetRenameInfo info : toRename) {
                publisher.fireFacetRenamed(info.myFacet, info.myOldName);
            }
        }
        for (Facet facet : toAdd) {
            FacetType type;
            Module module = facet.getModule();
            if (!module.equals(this.myModule)) {
                LOG.error(facet + " is created for module " + module + " but added to module " + this.myModule);
            }
            if (!(type = facet.getType()).isOnlyOneFacetAllowed()) continue;
            if (type.getUnderlyingFacetType() == null) {
                Collection facets2 = this.getFacetsByType(type.getId());
                if (facets2.size() <= 1) continue;
                LOG.error("Only one '" + type.getPresentableName() + "' facet per module allowed, but " + facets2.size() + " facets found in module '" + this.myModule.getName() + "'");
                continue;
            }
            Facet underlyingFacet = facet.getUnderlyingFacet();
            LOG.assertTrue(underlyingFacet != null, (Object)("Underlying facet is not specified for '" + facet.getName() + "'"));
            Collection facets3 = this.getFacetsByType(underlyingFacet, type.getId());
            if (facets3.size() <= 1) continue;
            LOG.error("Only one '" + type.getPresentableName() + "' facet per parent facet allowed, but " + facets3.size() + " sub-facets found in facet " + underlyingFacet.getName());
        }
    }

    public static void setExternalSource(@NotNull Facet<?> facet, ProjectModelExternalSource externalSource) {
        facet.setExternalSource(externalSource);
    }

    Set<ProjectModelExternalSource> getExternalSources() {
        return this.myModel.myExternalSources;
    }

    public void moduleAdded() {
        if (this.myModuleAdded) {
            return;
        }
        for (Facet<?> facet : this.getAllFacets()) {
            facet.initFacet();
        }
        this.myModuleAdded = true;
    }

    private static class FacetRenameInfo {
        private final Facet<?> myFacet;
        private final String myOldName;
        private final String myNewName;

        FacetRenameInfo(Facet<?> facet, String oldName, String newName) {
            this.myFacet = facet;
            this.myOldName = oldName;
            this.myNewName = newName;
        }
    }

    private static class FacetManagerModel
    extends FacetModelBase {
        private Facet<?>[] myAllFacets = Facet.EMPTY_ARRAY;
        private final Set<ProjectModelExternalSource> myExternalSources = new LinkedHashSet<ProjectModelExternalSource>();

        private FacetManagerModel() {
        }

        public Facet<?> @NotNull [] getAllFacets() {
            return this.myAllFacets;
        }

        void setAllFacets(Facet<?>[] allFacets) {
            this.myExternalSources.clear();
            for (Facet<?> facet : allFacets) {
                ContainerUtil.addIfNotNull(this.myExternalSources, (Object)facet.getExternalSource());
            }
            this.myAllFacets = allFacets;
            this.facetsChanged();
        }
    }
}

