/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.externalDependencies.impl.CheckRequiredPluginsActivity;
import com.intellij.externalDependencies.impl.DependencyOnPluginState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ExternalDependencies", storages={@Storage(value="externalDependencies.xml")})
public final class ExternalDependenciesManagerImpl
extends ExternalDependenciesManager
implements PersistentStateComponent<ExternalDependenciesState> {
    private final Project myProject;
    private static final Comparator<ProjectExternalDependency> DEPENDENCY_COMPARATOR = (o1, o2) -> {
        int i2 = o1.getClass().getSimpleName().compareToIgnoreCase(o2.getClass().getSimpleName());
        if (i2 != 0) {
            return i2;
        }
        return ((Comparable)((Object)o1)).compareTo(o2);
    };
    private final List<ProjectExternalDependency> myDependencies = new ArrayList<ProjectExternalDependency>();

    ExternalDependenciesManagerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public <T extends ProjectExternalDependency> List<T> getDependencies(@NotNull Class<T> aClass) {
        return ContainerUtil.filterIsInstance(this.myDependencies, aClass);
    }

    @Override
    @NotNull
    public List<ProjectExternalDependency> getAllDependencies() {
        return Collections.unmodifiableList(this.myDependencies);
    }

    @Override
    public void setAllDependencies(@NotNull List<? extends ProjectExternalDependency> dependencies) {
        this.myDependencies.clear();
        this.myDependencies.addAll(dependencies);
        this.myDependencies.sort(DEPENDENCY_COMPARATOR);
    }

    @NotNull
    public ExternalDependenciesState getState() {
        ExternalDependenciesState state = new ExternalDependenciesState();
        for (ProjectExternalDependency dependency : this.myDependencies) {
            state.myDependencies.add(new DependencyOnPluginState((DependencyOnPlugin)dependency));
        }
        return state;
    }

    public void loadState(@NotNull ExternalDependenciesState state) {
        ArrayList<ProjectExternalDependency> oldDependencies = new ArrayList<ProjectExternalDependency>(this.myDependencies);
        this.myDependencies.clear();
        for (DependencyOnPluginState dependency : state.myDependencies) {
            this.myDependencies.add(new DependencyOnPlugin(dependency.myId, dependency.myMinVersion, dependency.myMaxVersion));
        }
        if (!(oldDependencies.equals(this.myDependencies) || this.myDependencies.isEmpty() || ApplicationManager.getApplication().isUnitTestMode())) {
            NonUrgentExecutor.getInstance().execute(() -> StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> CheckRequiredPluginsActivity.runCheck(this.myProject, this)));
        }
    }

    public static final class ExternalDependenciesState {
        @Property(surroundWithTag=false)
        @XCollection
        public final List<DependencyOnPluginState> myDependencies = new ArrayList<DependencyOnPluginState>();
    }
}

