/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

final class CheckRequiredPluginsActivity
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance(CheckRequiredPluginsActivity.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Required Plugins", NotificationDisplayType.BALLOON, true);

    CheckRequiredPluginsActivity() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void runActivity(@NotNull Project project) {
        ExternalDependenciesManager.getInstance(project);
    }

    public static void runCheck(final @NotNull Project project, @NotNull ExternalDependenciesManager dependencyManager) {
        List<DependencyOnPlugin> dependencies = dependencyManager.getDependencies(DependencyOnPlugin.class);
        if (dependencies.isEmpty()) {
            return;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        final ArrayList<IdeaPluginDescriptor> disabled = new ArrayList<IdeaPluginDescriptor>();
        final ArrayList<PluginId> notInstalled = new ArrayList<PluginId>();
        ArrayList<IdeaPluginDescriptor> pluginsToEnableWithoutRestart = new ArrayList<IdeaPluginDescriptor>();
        for (DependencyOnPlugin dependency : dependencies) {
            PluginId pluginId = PluginId.getId((String)dependency.getPluginId());
            IdeaPluginDescriptor plugin2 = PluginManagerCore.getPlugin(pluginId);
            if (plugin2 == null) {
                errorMessages.add("Plugin '" + dependency.getPluginId() + "' required for '" + project.getName() + "' project isn't installed.");
                notInstalled.add(pluginId);
                continue;
            }
            if (!plugin2.isEnabled()) {
                boolean canEnableWithoutRestart = false;
                if (Registry.is((String)"ide.plugins.load.automatically")) {
                    String message;
                    IdeaPluginDescriptorImpl fullDescriptor = PluginDescriptorLoader.tryLoadFullDescriptor((IdeaPluginDescriptorImpl)plugin2);
                    String string = message = fullDescriptor == null ? "Cannot load full descriptor for " + plugin2.getPluginId() : DynamicPlugins.checkCanUnloadWithoutRestart((IdeaPluginDescriptorImpl)plugin2);
                    if (message == null) {
                        canEnableWithoutRestart = true;
                        pluginsToEnableWithoutRestart.add(plugin2);
                    } else {
                        LOG.info("Required plugin " + plugin2.getPluginId() + " can't be enabled without restart: " + message);
                    }
                }
                if (canEnableWithoutRestart) continue;
                errorMessages.add("Plugin '" + plugin2.getName() + "' required for '" + project.getName() + "' project is disabled.");
                disabled.add(plugin2);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            String maxVersion = dependency.getMaxVersion();
            String pluginVersion = plugin2.getVersion();
            BuildNumber currentIdeVersion = ApplicationInfo.getInstance().getBuild();
            if (plugin2.isBundled() && !plugin2.allowBundledUpdate() && currentIdeVersion.asStringWithoutProductCode().equals(pluginVersion)) {
                String pluginFromString;
                String string = pluginFromString = PluginManagerCore.CORE_ID == plugin2.getPluginId() ? "" : "plugin '" + plugin2.getName() + "' from ";
                if (minVersion != null && currentIdeVersion.compareTo(BuildNumber.fromString((String)minVersion)) < 0) {
                    errorMessages.add("Project '" + project.getName() + "' requires " + pluginFromString + "'" + minVersion + "' or newer build of the IDE, but the current build is '" + pluginVersion + "'.");
                }
                if (maxVersion == null || currentIdeVersion.compareTo(BuildNumber.fromString((String)maxVersion)) <= 0) continue;
                errorMessages.add("Project '" + project.getName() + "' requires " + pluginFromString + "'" + maxVersion + "' or older build of the IDE, but the current build is '" + pluginVersion + "'.");
                continue;
            }
            if (minVersion != null && VersionComparatorUtil.compare((String)pluginVersion, (String)minVersion) < 0) {
                errorMessages.add("Project '" + project.getName() + "' requires plugin  '" + plugin2.getName() + "' version '" + minVersion + "' or higher, but '" + pluginVersion + "' is installed.");
            }
            if (maxVersion == null || VersionComparatorUtil.compare((String)pluginVersion, (String)maxVersion) <= 0) continue;
            errorMessages.add("Project '" + project.getName() + "' requires plugin  '" + plugin2.getName() + "' version '" + maxVersion + "' or lower, but '" + pluginVersion + "' is installed.");
        }
        if (!pluginsToEnableWithoutRestart.isEmpty()) {
            LOG.info("Automatically enabling plugins required for this project: " + StringUtil.join(pluginsToEnableWithoutRestart, plugin -> plugin.getPluginId().toString(), (String)", "));
            for (IdeaPluginDescriptor descriptor2 : pluginsToEnableWithoutRestart) {
                ProjectPluginTracker.getInstance().registerProjectPlugin(project, descriptor2);
            }
            ApplicationManager.getApplication().invokeLater(() -> PluginEnabler.enablePlugins(project, pluginsToEnableWithoutRestart, true));
        }
        if (!errorMessages.isEmpty()) {
            if (!disabled.isEmpty() && notInstalled.isEmpty()) {
                String plugins = disabled.size() == 1 ? ((IdeaPluginDescriptor)disabled.get(0)).getName() : "required plugins";
                errorMessages.add("<a href=\"enable\">Enable " + plugins + "</a>");
            } else if (!disabled.isEmpty() || !notInstalled.isEmpty()) {
                errorMessages.add("<a href=\"install\">Install required plugins</a>");
            }
            NOTIFICATION_GROUP.createNotification(IdeBundle.message((String)"notification.title.required.plugins.weren.t.loaded", (Object[])new Object[0]), StringUtil.join(errorMessages, (String)"<br>"), NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if ("enable".equals(event.getDescription())) {
                            notification.expire();
                            DisabledPluginsState.enablePlugins(disabled, true);
                            PluginManagerMain.notifyPluginsUpdated(project);
                        } else {
                            HashSet<PluginId> pluginIds = new HashSet<PluginId>();
                            for (IdeaPluginDescriptor descriptor2 : disabled) {
                                pluginIds.add(descriptor2.getPluginId());
                            }
                            pluginIds.addAll(notInstalled);
                            PluginsAdvertiser.installAndEnable(pluginIds, () -> notification.expire());
                        }
                    }
                }
            }).notify(project);
        }
    }
}

