/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PsiFileBase
extends PsiFileImpl {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ParserDefinition myParserDefinition;

    protected PsiFileBase(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        super(viewProvider);
        this.myLanguage = PsiFileBase.findLanguage(language, viewProvider);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null for: " + this.myLanguage);
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        assert (nodeType.getLanguage() == this.myLanguage) : nodeType.getLanguage() + " != " + this.myLanguage;
        this.init((IElementType)nodeType, (IElementType)nodeType);
    }

    private static Language findLanguage(@NotNull Language baseLanguage, @NotNull FileViewProvider viewProvider) {
        Set languages = viewProvider.getLanguages();
        Language candidate = null;
        for (Language actualLanguage : languages) {
            if (actualLanguage.equals(baseLanguage)) {
                return baseLanguage;
            }
            if (candidate != null || !actualLanguage.isKindOf(baseLanguage)) continue;
            candidate = actualLanguage;
        }
        if (candidate != null) {
            return candidate;
        }
        throw new AssertionError((Object)("Language " + baseLanguage + " doesn't participate in view provider " + viewProvider + ": " + new ArrayList(languages)));
    }

    @Override
    @NotNull
    public final Language getLanguage() {
        return this.myLanguage;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitFile((PsiFile)this);
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        return this.myParserDefinition;
    }
}

