/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Tag(value="descriptor")
final class WslDistributionDescriptor {
    @Tag(value="id")
    private String myId;
    @Tag(value="microsoft-id")
    private String myMsId;
    @Tag(value="executable-path")
    private String myExecutablePath;
    @Tag(value="presentable-name")
    private String myPresentableName;
    private final AtomicNotNullLazyValue<String> myMntRootProvider = AtomicNotNullLazyValue.createValue(this::computeMntRoot);

    WslDistributionDescriptor() {
    }

    WslDistributionDescriptor(@NotNull String id2, @NotNull String msId, @NotNull String executablePath, @NotNull String presentableName) {
        this.myId = id2;
        this.myMsId = msId;
        this.myExecutablePath = executablePath;
        this.myPresentableName = presentableName;
    }

    @NotNull
    public String getId() {
        return Objects.requireNonNull(this.myId);
    }

    @NotNull
    public String getMsId() {
        return Objects.requireNonNull(this.myMsId);
    }

    @NotNull
    public String getExecutablePath() {
        return Objects.requireNonNull(this.myExecutablePath);
    }

    @NotNull
    public String getPresentableName() {
        return Objects.requireNonNull(this.myPresentableName);
    }

    boolean isValid() {
        return StringUtil.isNotEmpty((String)this.myId) && StringUtil.isNotEmpty((String)this.myMsId) && StringUtil.isNotEmpty((String)this.myExecutablePath) && StringUtil.isNotEmpty((String)this.myPresentableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslDistributionDescriptor that = (WslDistributionDescriptor)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "WslDistributionDescriptor{id='" + this.myId + '\'' + ", msId='" + this.myMsId + '\'' + '}';
    }

    @NotNull
    final String getMntRoot() {
        return (String)this.myMntRootProvider.getValue();
    }

    @NotNull
    private String computeMntRoot() {
        String currentPathSuffix;
        ProcessOutput pwdOutput;
        String windowsCurrentDirectory = System.getProperty("user.dir");
        if (StringUtil.isEmpty((String)windowsCurrentDirectory) || windowsCurrentDirectory.length() < 3) {
            WSLUtil.LOG.warn("Could not obtain current directory from user.dir (or path is too short): " + windowsCurrentDirectory);
            return "/mnt/";
        }
        WSLDistribution distribution = WSLUtil.getDistributionById(this.getId());
        if (distribution == null) {
            return "/mnt/";
        }
        try {
            pwdOutput = distribution.executeOnWsl(-1, "pwd");
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn("Error reading pwd output for " + this.getId(), (Throwable)e);
            return "/mnt/";
        }
        if (pwdOutput.getExitCode() != 0) {
            WSLUtil.LOG.info("Non-zero exit code while fetching pwd: [id=" + this.getId() + "; [exitCode=" + pwdOutput.getExitCode() + "; [stderr=" + pwdOutput.getStderr() + "; [stdout=" + pwdOutput.getStdout() + "]");
            return "/mnt/";
        }
        List pwdOutputLines = pwdOutput.getStdoutLines();
        if (pwdOutputLines.size() != 1) {
            WSLUtil.LOG.warn("One line response expected from `pwd`: [id=" + this.getId() + "; exitCode=" + pwdOutput.getExitCode() + "; stderr=" + pwdOutput.getStderr() + "; stdout=" + pwdOutput.getStdout() + "]");
            return "/mnt/";
        }
        String wslCurrentDirectory = ((String)pwdOutputLines.get(0)).trim();
        if (StringUtil.endsWithIgnoreCase((String)wslCurrentDirectory, (String)(currentPathSuffix = WSLDistribution.convertWindowsPath(windowsCurrentDirectory)))) {
            return StringUtil.trimEnd((String)wslCurrentDirectory, (String)currentPathSuffix, (boolean)true);
        }
        WSLUtil.LOG.warn("Wsl current directory does not ends with windows converted suffix: [pwd=" + wslCurrentDirectory + "; suffix=" + currentPathSuffix + "]");
        return "/mnt/";
    }
}

