/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.update;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.update.RunningApplicationUpdater;
import com.intellij.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateRunningApplicationAction
extends AnAction {
    UpdateRunningApplicationAction() {
        super(ExecutionBundle.messagePointer((String)"action.AnAction.text.update.running.application", (Object[])new Object[0]), ExecutionBundle.messagePointer((String)"action.AnAction.description.update.running.application", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        Presentation presentation2 = e.getPresentation();
        if (contentDescriptor != null && project != null) {
            ProcessHandler processHandler2 = contentDescriptor.getProcessHandler();
            RunningApplicationUpdater updater2 = UpdateRunningApplicationAction.findUpdater(project, processHandler2);
            if (updater2 != null) {
                presentation2.setEnabled(processHandler2.isStartNotified() && !processHandler2.isProcessTerminating() && !processHandler2.isProcessTerminated());
                presentation2.setText(updater2.getDescription());
            } else {
                presentation2.setEnabled(false);
            }
            presentation2.setVisible(true);
            return;
        }
        List<RunningApplicationUpdater> updaters = UpdateRunningApplicationAction.getAvailableUpdaters(project);
        boolean enable = !updaters.isEmpty();
        presentation2.setEnabledAndVisible(enable);
        if (updaters.size() == 1) {
            presentation2.setText(updaters.get(0).getDescription());
        } else {
            presentation2.setText(ExecutionBundle.messagePointer((String)"action.presentation.UpdateRunningApplicationAction.text", (Object[])new Object[0]));
        }
    }

    @Nullable
    private static RunningApplicationUpdater findUpdater(@NotNull Project project, @Nullable ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            return null;
        }
        for (RunningApplicationUpdaterProvider provider : (RunningApplicationUpdaterProvider[])RunningApplicationUpdaterProvider.EP_NAME.getExtensions()) {
            RunningApplicationUpdater updater2 = provider.createUpdater(project, processHandler2);
            if (updater2 == null) continue;
            return updater2;
        }
        return null;
    }

    private static List<RunningApplicationUpdater> getAvailableUpdaters(@Nullable Project project) {
        ProcessHandler[] processes;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<RunningApplicationUpdater> result2 = new ArrayList<RunningApplicationUpdater>();
        for (ProcessHandler process2 : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (process2.isProcessTerminated() || process2.isProcessTerminating() || !process2.isStartNotified()) continue;
            ContainerUtil.addIfNotNull(result2, (Object)UpdateRunningApplicationAction.findUpdater(project, process2));
        }
        return result2;
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        RunningApplicationUpdater updater2;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        if (contentDescriptor != null && (updater2 = UpdateRunningApplicationAction.findUpdater(project, contentDescriptor.getProcessHandler())) != null) {
            updater2.performUpdate(e);
            return;
        }
        List<RunningApplicationUpdater> updaters = UpdateRunningApplicationAction.getAvailableUpdaters(project);
        if (updaters.isEmpty()) {
            return;
        }
        if (updaters.size() > 1) {
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<RunningApplicationUpdater>(ExecutionBundle.message((String)"popup.title.select.process.to.update", (Object[])new Object[0]), updaters){

                @NotNull
                public String getTextFor(RunningApplicationUpdater value2) {
                    return value2.getShortName();
                }

                public Icon getIconFor(RunningApplicationUpdater value2) {
                    return value2.getIcon();
                }

                public PopupStep onChosen(RunningApplicationUpdater selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> selectedValue.performUpdate(e));
                }
            });
            popup2.showCenteredInCurrentWindow(project);
        } else {
            updaters.get(0).performUpdate(e);
        }
    }
}

