/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.execution.ui.layout.LayoutViewOptions;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.RunnerLayoutSettings;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayoutUiImpl
implements Disposable.Parent,
RunnerLayoutUi,
LayoutStateDefaults,
LayoutViewOptions,
DataProvider {
    private final RunnerLayout myLayout;
    private final RunnerContentUi myContentUI;
    private final ContentManager myViewsContentManager;
    public static final Key<String> CONTENT_TYPE = Key.create((String)"ContentType");

    public RunnerLayoutUiImpl(@NotNull Project project, @NotNull Disposable parent, @NotNull String runnerId, @NotNull String runnerTitle, @NotNull String sessionName) {
        this.myLayout = RunnerLayoutSettings.getInstance().getLayout(runnerId);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myContentUI = new RunnerContentUi(project, this, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project), this.myLayout, runnerTitle + " - " + sessionName, runnerId);
        Disposer.register((Disposable)this, (Disposable)this.myContentUI);
        this.myViewsContentManager = RunnerLayoutUiImpl.getContentFactory().createContentManager(this.myContentUI.getContentUI(), true, project);
        this.myViewsContentManager.addDataProvider((DataProvider)this);
        Disposer.register((Disposable)this, (Disposable)this.myViewsContentManager);
    }

    @Deprecated
    @NotNull
    public LayoutViewOptions setTopToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        return this.setTopLeftToolbar(actions, place);
    }

    @NotNull
    public LayoutViewOptions setTopLeftToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        this.myContentUI.setTopLeftActions(actions, place);
        return this;
    }

    @NotNull
    public LayoutViewOptions setTopMiddleToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        this.myContentUI.setTopMiddleActions(actions, place);
        return this;
    }

    @NotNull
    public LayoutViewOptions setTopRightToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        this.myContentUI.setTopRightActions(actions, place);
        return this;
    }

    @NotNull
    public LayoutStateDefaults initTabDefaults(int id2, String text, Icon icon2) {
        this.getLayout().setDefault(id2, text, icon2);
        return this;
    }

    @NotNull
    public LayoutStateDefaults initContentAttraction(@NotNull String contentId, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        this.getLayout().setDefaultToFocus(contentId, condition, policy);
        return this;
    }

    @NotNull
    public LayoutStateDefaults cancelContentAttraction(@NotNull String condition) {
        this.getLayout().cancelDefaultFocusBy(condition);
        return this;
    }

    @NotNull
    public Content addContent(@NotNull Content content2) {
        return this.addContent(content2, false, -1, PlaceInGrid.center, false);
    }

    @NotNull
    public Content addContent(@NotNull Content content2, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        return this.addContent(content2, true, defaultTabId, defaultPlace, defaultIsMinimized);
    }

    public Content addContent(@NotNull Content content2, boolean applyDefaults, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        String id2 = (String)content2.getUserData(CONTENT_TYPE);
        assert (id2 != null) : "Content id is missing, use RunnerLayoutUi to create content instances";
        if (applyDefaults) {
            this.getLayout().setDefault(id2, defaultTabId, defaultPlace, defaultIsMinimized);
        }
        this.getContentManager().addContent(content2);
        return content2;
    }

    @NotNull
    public Content createContent(@NotNull String id2, @NotNull JComponent component2, @NotNull String displayName, @Nullable Icon icon2, @Nullable JComponent focusable) {
        return this.createContent(id2, (ComponentWithActions)new ComponentWithActions.Impl(component2), displayName, icon2, focusable);
    }

    @NotNull
    public Content createContent(@NotNull String contentId, @NotNull ComponentWithActions withActions, @NotNull String displayName, @Nullable Icon icon2, @Nullable JComponent toFocus) {
        Content content2 = RunnerLayoutUiImpl.getContentFactory().createContent(withActions.getComponent(), displayName, false);
        content2.putUserData(CONTENT_TYPE, (Object)contentId);
        content2.putUserData(ViewImpl.ID, (Object)contentId);
        content2.setIcon(icon2);
        if (toFocus != null) {
            content2.setPreferredFocusableComponent(toFocus);
        }
        if (!withActions.isContentBuiltIn()) {
            content2.setSearchComponent(withActions.getSearchComponent());
            content2.setActions(withActions.getToolbarActions(), withActions.getToolbarPlace(), withActions.getToolbarContextComponent());
        }
        return content2;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myViewsContentManager.getComponent();
    }

    private static ContentFactory getContentFactory() {
        return ContentFactory.SERVICE.getInstance();
    }

    public RunnerLayout getLayout() {
        return this.myLayout;
    }

    public void updateActionsNow() {
        this.myContentUI.updateActionsImmediately();
    }

    public void beforeTreeDispose() {
        this.myContentUI.saveUiState();
    }

    public void dispose() {
    }

    @NotNull
    public ContentManager getContentManager() {
        return this.myViewsContentManager;
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content2, boolean requestFocus, boolean forced) {
        return this.selectAndFocus(content2, requestFocus, forced, false);
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content2, boolean requestFocus, boolean forced, boolean implicit) {
        if (content2 == null) {
            return ActionCallback.REJECTED;
        }
        return this.getContentManager(content2).setSelectedContent(content2, requestFocus || this.shouldRequestFocus(), forced, implicit);
    }

    private ContentManager getContentManager(@NotNull Content content2) {
        return this.myContentUI.getContentManager(content2);
    }

    private boolean shouldRequestFocus() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.isDescendingFrom(focused, this.getContentManager().getComponent());
    }

    public boolean removeContent(@Nullable Content content2, boolean dispose2) {
        return content2 != null && this.getContentManager().removeContent(content2, dispose2);
    }

    public boolean isToFocus(@NotNull Content content2, @NotNull String condition) {
        String id2 = (String)content2.getUserData(ViewImpl.ID);
        return this.getLayout().isToFocus(id2, condition);
    }

    @NotNull
    public LayoutViewOptions setToFocus(@Nullable Content content2, @NotNull String condition) {
        this.getLayout().setToFocus(content2 != null ? (String)content2.getUserData(ViewImpl.ID) : null, condition);
        return this;
    }

    public void attractBy(@NotNull String condition) {
        this.myContentUI.attractByCondition(condition, true);
    }

    public void clearAttractionBy(@NotNull String condition) {
        this.myContentUI.clearAttractionByCondition(condition, true);
    }

    public void removeContent(@NotNull String id2, boolean dispose2) {
        Content content2 = this.findContent(id2);
        if (content2 != null) {
            this.getContentManager().removeContent(content2, dispose2);
        }
    }

    public AnAction getLayoutActions() {
        return this.myContentUI.getLayoutActions();
    }

    public AnAction @NotNull [] getLayoutActionsList() {
        ActionGroup group = (ActionGroup)this.getLayoutActions();
        return group.getChildren(null);
    }

    @NotNull
    public LayoutViewOptions setTabPopupActions(@NotNull ActionGroup group) {
        this.myContentUI.setTabPopupActions(group);
        return this;
    }

    @NotNull
    public LayoutViewOptions setLeftToolbar(@NotNull ActionGroup leftToolbar, @NotNull String place) {
        this.myContentUI.setLeftToolbar(leftToolbar, place);
        return this;
    }

    @Nullable
    public Content findContent(@NotNull String key) {
        return this.myContentUI.findContent(key);
    }

    @NotNull
    public RunnerLayoutUi addListener(final @NotNull ContentManagerListener listener2, @NotNull Disposable parent) {
        final ContentManager mgr = this.getContentManager();
        mgr.addContentManagerListener(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                mgr.removeContentManagerListener(listener2);
            }
        });
        return this;
    }

    public void removeListener(@NotNull ContentManagerListener listener2) {
        this.getContentManager().removeContentManagerListener(listener2);
    }

    public void setBouncing(@NotNull Content content2, boolean activate2) {
        this.myContentUI.processBounce(content2, activate2);
    }

    public boolean isDisposed() {
        return this.getContentManager().isDisposed();
    }

    @NotNull
    public LayoutViewOptions setMinimizeActionEnabled(boolean enabled) {
        this.myContentUI.setMinimizeActionEnabled(enabled);
        return this;
    }

    public LayoutViewOptions setToDisposeRemoveContent(boolean toDispose) {
        this.myContentUI.setToDisposeRemovedContent(toDispose);
        return this;
    }

    @NotNull
    public LayoutViewOptions setMoveToGridActionEnabled(boolean enabled) {
        this.myContentUI.setMovetoGridActionEnabled(enabled);
        return this;
    }

    @NotNull
    public LayoutViewOptions setAttractionPolicy(@NotNull String contentId, LayoutAttractionPolicy policy) {
        this.myContentUI.setPolicy(contentId, policy);
        return this;
    }

    @NotNull
    public LayoutViewOptions setConditionAttractionPolicy(@NotNull String condition, LayoutAttractionPolicy policy) {
        this.myContentUI.setConditionPolicy(condition, policy);
        return this;
    }

    @NotNull
    public LayoutStateDefaults getDefaults() {
        return this;
    }

    @NotNull
    public LayoutViewOptions getOptions() {
        return this;
    }

    @NotNull
    public LayoutViewOptions setAdditionalFocusActions(@NotNull ActionGroup group) {
        this.myContentUI.setAdditionalFocusActions(group);
        return this;
    }

    public AnAction getSettingsActions() {
        return this.myContentUI.getSettingsActions();
    }

    public AnAction @NotNull [] getSettingsActionsList() {
        ActionGroup group = (ActionGroup)this.getSettingsActions();
        return group.getChildren(null);
    }

    public Content @NotNull [] getContents() {
        Content[] contents = new Content[this.getContentManager().getContentCount()];
        for (int i2 = 0; i2 < contents.length; ++i2) {
            contents[i2] = this.getContentManager().getContent(i2);
        }
        return contents;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (QuickActionProvider.KEY.is(dataId) || RunnerContentUi.KEY.is(dataId)) {
            return this.myContentUI;
        }
        return null;
    }

    public void setLeftToolbarVisible(boolean value2) {
        this.myContentUI.setLeftToolbarVisible(value2);
    }

    public void setContentToolbarBefore(boolean value2) {
        this.myContentUI.setContentToolbarBefore(value2);
    }

    public List<AnAction> getActions() {
        return this.myContentUI.getActions(true);
    }
}

