/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.hash.LinkedHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    protected Map<String, ViewImpl> myViews = new LinkedHashMap();
    private final Map<String, ViewImpl.Default> myDefaultViews = new HashMap<String, ViewImpl.Default>();
    protected Set<TabImpl> myTabs = new TreeSet<TabImpl>(Comparator.comparingInt(TabImpl::getIndex));
    private final Int2ObjectOpenHashMap<TabImpl.Default> myDefaultTabs = new Int2ObjectOpenHashMap();
    protected General myGeneral = new General();
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
    private Set<String> myLightWeightIds = null;

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @NotNull
    public TabImpl getOrCreateTab(int index) {
        if (index < 0) {
            return this.createNewTab();
        }
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            return tab;
        }
        tab = this.createNewTab(index);
        return tab;
    }

    @NotNull
    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        return tab;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = (TabImpl.Default)this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, (Object)tab);
        }
        return tab;
    }

    @NotNull
    public TabImpl createNewTab() {
        int index = this.myTabs.stream().mapToInt(x -> x.getIndex()).max().orElse(-1) + 1;
        return this.createNewTab(index);
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        return this.write(new Element("layout"));
    }

    public void loadState(@NotNull Element state) {
        this.read(state);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Object eachTabElement : tabs) {
            TabImpl eachTab = (TabImpl)XmlSerializer.deserialize((Element)eachTabElement, TabImpl.class);
            XmlSerializer.deserializeInto((Element)eachTabElement, (Object)this.getOrCreateTab(eachTab.getIndex()));
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Element content2 : views) {
            ViewImpl view = new ViewImpl();
            XmlSerializer.deserializeInto((Element)content2, (Object)view);
            view.assignTab(this.getOrCreateTab(view.getTabIndex()));
            this.myViews.put(view.getID(), view);
        }
        Element general = parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$'));
        XmlSerializer.deserializeInto((Element)(general == null ? new Element("state") : general), (Object)this.myGeneral);
        return parentNode;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        Element element2;
        for (ViewImpl eachState : this.myViews.values()) {
            if (this.myLightWeightIds != null && this.myLightWeightIds.contains(eachState.getID())) continue;
            element2 = XmlSerializer.serialize((Object)eachState);
            parentNode.addContent(element2 == null ? new Element("ViewImpl") : element2);
        }
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            element2 = XmlSerializer.serialize((Object)eachTab);
            parentNode.addContent(element2 == null ? new Element("TabImpl") : element2);
        }
        Element generalContent = XmlSerializer.serialize((Object)this.myGeneral);
        if (generalContent != null) {
            parentNode.addContent(generalContent);
        }
        return parentNode;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content2) {
        return this.getOrCreateView(RunnerLayout.getOrCreateContentId(content2));
    }

    public void clearStateFor(@NotNull Content content2) {
        Tab tab;
        String id2 = RunnerLayout.getOrCreateContentId(content2);
        this.myDefaultViews.remove(id2);
        ViewImpl view = this.myViews.remove(id2);
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content2) {
        String id2 = (String)content2.getUserData(ViewImpl.ID);
        if (id2 == null) {
            id2 = "UnknownView-" + content2.getDisplayName();
            content2.putUserData(ViewImpl.ID, (Object)id2);
        }
        return id2;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id2) {
        ViewImpl view = this.myViews.get(id2);
        if (view == null) {
            view = this.getOrCreateDefault(id2).createView(this);
            this.myViews.put(id2, view);
        }
        return view;
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id2) {
        if (this.myDefaultViews.containsKey(id2)) {
            return this.myDefaultViews.get(id2);
        }
        return this.setDefault(id2, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
    }

    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon2) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon2);
        this.myDefaultTabs.put(tabID, (Object)tab);
        return tab;
    }

    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id2, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        ViewImpl.Default view = new ViewImpl.Default(id2, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id2, view);
        return view;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content2) {
        return this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content2)).getPlaceInGrid();
    }

    public boolean isToFocus(String id2, @NotNull String condition) {
        return Objects.equals(id2, this.getToFocus(condition));
    }

    public void setToFocus(String id2, @NotNull String condition) {
        this.myGeneral.focusOnCondition.put(condition, id2);
    }

    public void setDefaultToFocus(@NotNull String id2, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id2, (Object)policy));
    }

    void cancelDefaultFocusBy(@NotNull String condition) {
        this.myDefaultFocus.remove(condition);
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        Pair<String, LayoutAttractionPolicy> pair = this.myDefaultFocus.get(condition);
        return pair == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
    }

    public void setLightWeight(Content content2) {
        if (this.myLightWeightIds == null) {
            this.myLightWeightIds = new HashSet<String>();
        }
        this.myLightWeightIds.add(RunnerLayout.getOrCreateContentId(content2));
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

