/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.Grid;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.CloseViewAction;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.actions.RestoreViewAction;
import com.intellij.execution.ui.layout.impl.GridCellImpl;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.execution.ui.layout.impl.JBRunnerTabsBase;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CloseAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.content.SelectContentStep;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunnerContentUi
implements ContentUI,
Disposable,
CellTransform.Facade,
ViewContextEx,
PropertyChangeListener,
QuickActionProvider,
DockContainer.Dialog,
Activatable {
    public static final DataKey<RunnerContentUi> KEY = DataKey.create((String)"DebuggerContentUI");
    public static final Key<Boolean> LIGHTWEIGHT_CONTENT_MARKER = Key.create((String)"LightweightContent");
    @NonNls
    private static final String LAYOUT = "Runner.Layout";
    @NonNls
    private static final String SETTINGS = "XDebugger.Settings";
    @NonNls
    private static final String VIEW_POPUP = "Runner.View.Popup";
    @NonNls
    static final String VIEW_TOOLBAR = "Runner.View.Toolbar";
    private ShowDebugContentAction myShowDebugContentAction = null;
    private ContentManager myManager;
    private final RunnerLayout myLayoutSettings;
    @NotNull
    private final ActionManager myActionManager;
    private final String mySessionName;
    private final String myRunnerId;
    private NonOpaquePanel myComponent;
    private final Wrapper myToolbar = new Wrapper();
    final MyDragOutDelegate myDragOutDelegate = new MyDragOutDelegate();
    JBRunnerTabsBase myTabs;
    private final Comparator<TabInfo> myTabsComparator = (o1, o2) -> {
        TabImpl tab1 = RunnerContentUi.getTabFor(o1);
        TabImpl tab2 = RunnerContentUi.getTabFor(o2);
        int index1 = tab1 != null ? tab1.getIndex() : -1;
        int index2 = tab2 != null ? tab2.getIndex() : -1;
        return index1 - index2;
    };
    private final Project myProject;
    private ActionGroup myTopLeftActions = new DefaultActionGroup();
    private ActionGroup myTopMiddleActions = new DefaultActionGroup();
    private ActionGroup myTopRightActions = new DefaultActionGroup();
    private final DefaultActionGroup myViewActions = new DefaultActionGroup();
    private final Map<GridImpl, Wrapper> myMinimizedButtonsPlaceholder = new HashMap<GridImpl, Wrapper>();
    private final Map<GridImpl, TopToolbarWrappers> myCommonActionsPlaceholder = new HashMap<GridImpl, TopToolbarWrappers>();
    private final Map<GridImpl, TopToolbarContextActions> myContextActions = new HashMap<GridImpl, TopToolbarContextActions>();
    private boolean myUiLastStateWasRestored;
    private final Set<Object> myRestoreStateRequestors = new HashSet<Object>();
    private String myTopLeftActionsPlace = "unknown";
    private String myTopMiddleActionsPlace = "unknown";
    private String myTopRightActionsPlace = "unknown";
    private final IdeFocusManager myFocusManager;
    private boolean myMinimizeActionEnabled = true;
    private boolean myMoveToGridActionEnabled = true;
    private final RunnerLayoutUi myRunnerUi;
    private final Map<String, LayoutAttractionPolicy> myAttractions = new HashMap<String, LayoutAttractionPolicy>();
    private final Map<String, LayoutAttractionPolicy> myConditionAttractions = new HashMap<String, LayoutAttractionPolicy>();
    private ActionGroup myTabPopupActions;
    private ActionGroup myAdditionalFocusActions;
    private final ActionCallback myInitialized = new ActionCallback();
    private boolean myToDisposeRemovedContent = true;
    private int myAttractionCount;
    private ActionGroup myLeftToolbarActions;
    private boolean myContentToolbarBefore = true;
    private JBTabs myCurrentOver;
    private Image myCurrentOverImg;
    private TabInfo myCurrentOverInfo;
    private MyDropAreaPainter myCurrentPainter;
    private Disposable myGlassPaneListenersDisposable = Disposer.newDisposable();
    private RunnerContentUi myOriginal;
    private final CopyOnWriteArraySet<DockContainer.Listener> myDockingListeners = new CopyOnWriteArraySet();
    private final Set<RunnerContentUi> myChildren = new TreeSet<RunnerContentUi>(Comparator.comparingInt(o -> o.myWindow));
    private int myWindow;
    private boolean myDisposing;

    public RunnerContentUi(@NotNull Project project, @NotNull RunnerLayoutUi ui, @NotNull ActionManager actionManager, @NotNull IdeFocusManager focusManager, @NotNull RunnerLayout settings, @NotNull String sessionName, @NotNull String runnerId) {
        this.myProject = project;
        this.myRunnerUi = ui;
        this.myLayoutSettings = settings;
        this.myActionManager = actionManager;
        this.mySessionName = sessionName;
        this.myFocusManager = focusManager;
        this.myRunnerId = runnerId;
    }

    public RunnerContentUi(@NotNull RunnerContentUi ui, @NotNull RunnerContentUi original, int window) {
        this(ui.myProject, ui.myRunnerUi, ui.myActionManager, ui.myFocusManager, ui.myLayoutSettings, ui.mySessionName, original.myRunnerId);
        this.myOriginal = original;
        original.myChildren.add(this);
        this.myWindow = window == 0 ? original.findFreeWindow() : window;
    }

    void setTopLeftActions(@NotNull ActionGroup topActions, @NotNull String place) {
        this.myTopLeftActions = topActions;
        this.myTopLeftActionsPlace = place;
        this.rebuildCommonActions();
    }

    void setTopMiddleActions(@NotNull ActionGroup topActions, @NotNull String place) {
        this.myTopMiddleActions = topActions;
        this.myTopMiddleActionsPlace = place;
        this.rebuildCommonActions();
    }

    void setTopRightActions(@NotNull ActionGroup topActions, @NotNull String place) {
        this.myTopRightActions = topActions;
        this.myTopRightActionsPlace = place;
        this.rebuildCommonActions();
    }

    void setTabPopupActions(ActionGroup tabPopupActions) {
        this.myTabPopupActions = tabPopupActions;
        this.rebuildTabPopup();
    }

    void setAdditionalFocusActions(ActionGroup group) {
        this.myAdditionalFocusActions = group;
        this.rebuildTabPopup();
    }

    public void setLeftToolbar(ActionGroup group, String place) {
        ActionToolbar tb = this.myActionManager.createActionToolbar(place, group, false);
        tb.setTargetComponent((JComponent)this.myComponent);
        this.myToolbar.setContent(tb.getComponent());
        this.myLeftToolbarActions = group;
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    void setLeftToolbarVisible(boolean value2) {
        this.myToolbar.setVisible(value2);
        Border border = this.myTabs.getComponent().getBorder();
        if (border instanceof JBRunnerTabs.JBRunnerTabsBorder) {
            ((JBRunnerTabs.JBRunnerTabsBorder)((Object)border)).setSideMask(value2 ? 1 : 0);
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    void setContentToolbarBefore(boolean value2) {
        this.myContentToolbarBefore = value2;
        for (GridImpl each : this.getGrids()) {
            each.setToolbarBefore(value2);
        }
        this.myContextActions.clear();
        this.updateTabsUI(false);
    }

    private void initUi() {
        if (this.myTabs != null) {
            return;
        }
        this.myTabs = JBRunnerTabs.create(this.myProject, this);
        this.myTabs.setDataProvider(dataId -> {
            if (ViewContext.CONTENT_KEY.is(dataId)) {
                TabInfo info = this.myTabs.getTargetInfo();
                if (info != null) {
                    return RunnerContentUi.getGridFor(info).getData(dataId);
                }
            } else if (ViewContext.CONTEXT_KEY.is(dataId)) {
                return this;
            }
            return null;
        });
        this.myTabs.getPresentation().setTabLabelActionsAutoHide(false).setInnerInsets((Insets)JBUI.emptyInsets()).setToDrawBorderIfTabsHidden(false).setTabDraggingEnabled(this.isMoveToGridActionEnabled()).setUiDecorator(null);
        this.rebuildTabPopup();
        this.myTabs.getPresentation().setPaintFocus(false).setRequestFocusOnLastFocusedComponent(true);
        MyComponent wrapper2 = new MyComponent(new BorderLayout(0, 0));
        wrapper2.add((Component)this.myToolbar, "West");
        wrapper2.add(this.myTabs.getComponent(), "Center");
        wrapper2.setBorder((Border)JBUI.Borders.emptyTop((int)-1));
        this.myComponent = wrapper2;
        this.myTabs.addListener(new TabsListener(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridImpl grid;
                if (oldSelection != null && !RunnerContentUi.this.isStateBeingRestored() && (grid = RunnerContentUi.getGridFor(oldSelection)) != null && RunnerContentUi.this.getTabFor(grid) != null) {
                    grid.saveUiState();
                }
            }

            public void tabsMoved() {
                RunnerContentUi.this.saveUiState();
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (!RunnerContentUi.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                    RunnerContentUi.getGridFor(newSelection).processAddToUi(false);
                }
                if (oldSelection != null) {
                    RunnerContentUi.getGridFor(oldSelection).processRemoveFromUi();
                }
            }
        });
        this.myTabs.addTabMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    Content[] contents;
                    TabInfo tabInfo = RunnerContentUi.this.myTabs.findInfo(e);
                    GridImpl grid = tabInfo == null ? null : RunnerContentUi.getGridFor(tabInfo);
                    Content[] contentArray = contents = grid != null ? (Content[])ViewContext.CONTENT_KEY.getData((DataProvider)grid) : null;
                    if (contents == null) {
                        return;
                    }
                    if (CloseViewAction.isEnabled(contents)) {
                        CloseViewAction.perform(RunnerContentUi.this, contents[0]);
                    } else if (MinimizeViewAction.isEnabled(RunnerContentUi.this, contents, "debuggerTabToolbar")) {
                        grid.getCellFor(contents[0]).minimize(contents[0]);
                    }
                }
            }
        });
        if (this.myOriginal != null) {
            ContentManager manager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)this, false, this.myProject);
            Disposer.register((Disposable)((Disposable)this.myRunnerUi), (Disposable)manager);
            manager.getComponent();
        } else {
            DockManager dockManager;
            DockManager dockManager2 = dockManager = this.myProject.isDefault() ? null : DockManager.getInstance((Project)this.myProject);
            if (dockManager != null) {
                dockManager.register((DockContainer)this, (Disposable)this);
            }
        }
        this.updateRestoreLayoutActionVisibility();
    }

    private void rebuildTabPopup() {
        this.initUi();
        this.myTabs.setPopupGroup(this.getCellPopupGroup("debuggerTabPopup"), "debuggerTabPopup", true);
        for (GridImpl each : this.getGrids()) {
            each.rebuildTabPopup();
        }
    }

    @Override
    public ActionGroup getCellPopupGroup(String place) {
        ActionGroup original = this.myTabPopupActions != null ? this.myTabPopupActions : (ActionGroup)this.myActionManager.getAction(VIEW_POPUP);
        ActionGroup focusPlaceholder = (ActionGroup)this.myActionManager.getAction("Runner.Focus");
        DefaultActionGroup group = new DefaultActionGroup(VIEW_POPUP, original.isPopup());
        if (this.myShowDebugContentAction == null && "Debug".equals(this.myRunnerId)) {
            this.myShowDebugContentAction = new ShowDebugContentAction(this, this.myTabs.getComponent(), this);
        }
        if (this.myShowDebugContentAction != null) {
            group.add((AnAction)this.myShowDebugContentAction);
        }
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(), place, new Presentation(), ActionManager.getInstance(), 0);
        for (AnAction each : original.getChildren(event)) {
            if (each == focusPlaceholder) {
                AnAction[] focusActions;
                for (AnAction eachFocus : focusActions = ((ActionGroup)each).getChildren(event)) {
                    group.add(eachFocus);
                }
                if (this.myAdditionalFocusActions == null) continue;
                for (AnAction action2 : this.myAdditionalFocusActions.getChildren(event)) {
                    group.add(action2);
                }
                continue;
            }
            group.add(each);
        }
        if (this.myViewActions.getChildrenCount() > 0) {
            DefaultActionGroup layoutGroup = new DefaultActionGroup(this.myViewActions.getChildren(null));
            layoutGroup.getTemplatePresentation().setText(ExecutionBundle.messagePointer((String)"action.presentation.RunnerContentUi.text", (Object[])new Object[0]));
            layoutGroup.setPopup(true);
            group.addSeparator();
            group.addAction((AnAction)layoutGroup);
        }
        return group;
    }

    @Override
    public boolean isOriginal() {
        return this.myOriginal == null;
    }

    @Override
    public int getWindow() {
        return this.myWindow;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Content content2 = (Content)evt.getSource();
        GridImpl grid = this.getGridFor(content2, false);
        if (grid == null) {
            return;
        }
        GridCellImpl cell = grid.findCell(content2);
        if (cell == null) {
            return;
        }
        String property = evt.getPropertyName();
        if ("alerting".equals(property)) {
            this.attract(content2, true);
        } else if ("displayName".equals(property) || "icon".equals(property) || "actions".equals(property) || "description".equals(property)) {
            cell.updateTabPresentation(content2);
            this.updateTabsUI(false);
        }
    }

    void processBounce(Content content2, boolean activate2) {
        GridImpl grid = this.getGridFor(content2, false);
        if (grid == null) {
            return;
        }
        TabInfo tab = this.myTabs.findInfo((Component)((Object)grid));
        if (tab == null) {
            return;
        }
        if (this.getSelectedGrid() != grid) {
            tab.setAlertIcon(content2.getAlertIcon());
            if (activate2) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        } else {
            grid.processAlert(content2, activate2);
        }
    }

    @Override
    public ActionCallback detachTo(int window, GridCell cell) {
        if (this.myOriginal != null) {
            return this.myOriginal.detachTo(window, cell);
        }
        RunnerContentUi target2 = null;
        if (window > 0) {
            for (RunnerContentUi child2 : this.myChildren) {
                if (child2.myWindow != window) continue;
                target2 = child2;
                break;
            }
        }
        GridCellImpl gridCell = (GridCellImpl)cell;
        Content[] contents = gridCell.getContents();
        this.storeDefaultIndices(contents);
        for (Content content2 : contents) {
            content2.putUserData(RunnerLayout.DROP_INDEX, (Object)this.getStateFor(content2).getTab().getIndex());
        }
        Dimension size = gridCell.getSize();
        if (size == null) {
            size = JBUI.size((int)200, (int)200);
        }
        DockableGrid content3 = new DockableGrid(null, null, size, Arrays.asList(contents), window);
        if (target2 != null) {
            target2.add(content3, null);
        } else {
            Point location = gridCell.getLocation();
            if (location == null) {
                location = this.getComponent().getLocationOnScreen();
            }
            location.translate(size.width / 2, size.height / 2);
            this.getDockManager().createNewDockContainerFor(content3, new RelativePoint(location));
        }
        return ActionCallback.DONE;
    }

    private void storeDefaultIndices(Content @NotNull [] contents) {
        for (Content content2 : contents) {
            content2.putUserData(RunnerLayout.DEFAULT_INDEX, (Object)this.getStateFor(content2).getTab().getDefaultIndex());
        }
    }

    @NotNull
    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle(this.myTabs.getComponent());
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
        if (!(content2 instanceof DockableGrid)) {
            return DockContainer.ContentResponse.DENY;
        }
        RunnerContentUi ui = ((DockableGrid)content2).getOriginalRunnerUi();
        return ui.getProject() == this.myProject && ui.mySessionName.equals(this.mySessionName) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
    }

    public JComponent getComponent() {
        this.initUi();
        return this.myComponent;
    }

    public JComponent getContainerComponent() {
        this.initUi();
        return this.myManager.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull DockableContent dockable, RelativePoint dropTarget) {
        DockableGrid dockableGrid = (DockableGrid)dockable;
        RunnerContentUi prev = dockableGrid.getRunnerUi();
        this.saveUiState();
        List<Content> contents = dockableGrid.getContents();
        boolean wasRestoring = this.myOriginal != null && this.myOriginal.isStateBeingRestored();
        this.setStateIsBeingRestored(true, this);
        try {
            Point point = dropTarget != null ? dropTarget.getPoint((Component)this.myComponent) : null;
            boolean hadGrid = !this.myTabs.shouldAddToGlobal(point);
            for (Content content2 : contents) {
                View view = this.getStateFor(content2);
                if (view.isMinimizedInGrid()) continue;
                prev.myManager.removeContent(content2, false);
                this.myManager.removeContent(content2, false);
                if (hadGrid && !wasRestoring) {
                    view.assignTab(this.getTabFor(this.getSelectedGrid()));
                    view.setPlaceInGrid(RunnerContentUi.calcPlaceInGrid(point, this.myComponent.getSize()));
                } else if (contents.size() == 1 && !wasRestoring) {
                    view.assignTab(null);
                    view.setPlaceInGrid(this.myLayoutSettings.getDefaultGridPlace(content2));
                }
                view.setWindow(this.myWindow);
                this.myManager.addContent(content2);
            }
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.saveUiState();
        this.updateTabsUI(true);
    }

    public void closeAll() {
        Content[] contents = this.myManager.getContents();
        if (this.myOriginal != null) {
            for (Content content2 : contents) {
                this.getStateFor(content2).setWindow(0);
                this.myOriginal.myManager.addContent(content2);
                GridCell cell = this.myOriginal.findCellFor(content2);
                if (cell == null) continue;
                this.myOriginal.restoreContent((String)content2.getUserData(ViewImpl.ID));
                cell.minimize(content2);
            }
        }
        this.myManager.removeAllContents(false);
    }

    public void addListener(@NotNull DockContainer.Listener listener2, Disposable parent) {
        this.myDockingListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> this.myDockingListeners.remove(listener2));
    }

    public boolean isEmpty() {
        return this.myTabs.isEmptyVisible() || this.myDisposing;
    }

    public Image processDropOver(@NotNull DockableContent dockable, RelativePoint dropTarget) {
        JBTabs current2 = this.getTabsAt(dockable, dropTarget);
        if (this.myCurrentOver != null && this.myCurrentOver != current2) {
            this.resetDropOver(dockable);
        }
        if (this.myCurrentOver == null && current2 != null) {
            this.myCurrentOver = current2;
            Presentation presentation2 = dockable.getPresentation();
            this.myCurrentOverInfo = new TabInfo((JComponent)new JLabel("")).setText(presentation2.getText()).setIcon(presentation2.getIcon());
            this.myCurrentOverImg = this.myCurrentOver.startDropOver(this.myCurrentOverInfo, dropTarget);
        }
        if (this.myCurrentOver != null) {
            this.myCurrentOver.processDropOver(this.myCurrentOverInfo, dropTarget);
        }
        if (this.myCurrentPainter == null) {
            this.myCurrentPainter = new MyDropAreaPainter();
            this.myGlassPaneListenersDisposable = Disposer.newDisposable((String)"GlassPaneListeners");
            Disposer.register((Disposable)this, (Disposable)this.myGlassPaneListenersDisposable);
            IdeGlassPaneUtil.find((Component)this.myComponent).addPainter((Component)this.myComponent, (Painter)this.myCurrentPainter, this.myGlassPaneListenersDisposable);
        }
        this.myCurrentPainter.processDropOver(this, dockable, dropTarget);
        return this.myCurrentOverImg;
    }

    public void toggleContentPopup(JBTabs tabs) {
        if (this.myOriginal != null) {
            this.myOriginal.toggleContentPopup(tabs);
            return;
        }
        List<Content> contents = this.getPopupContents();
        SelectContentStep step = new SelectContentStep(contents);
        Content selectedContent = this.myManager.getSelectedContent();
        if (selectedContent != null) {
            step.setDefaultOptionIndex(this.myManager.getIndexOfContent(selectedContent));
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        popup2.showUnderneathOf(tabs.getTabLabel(tabs.getSelectedInfo()));
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup2).addRequest(() -> popup2.handleSelect(false), 50);
        }
    }

    public List<Content> getPopupContents() {
        Content[] debugTabs;
        if (this.myOriginal != null) {
            return this.myOriginal.getPopupContents();
        }
        ArrayList<Content> contents = new ArrayList<Content>(Arrays.asList(this.myManager.getContents()));
        this.myChildren.stream().flatMap(child2 -> Arrays.stream(child2.myManager.getContents())).forEachOrdered(contents::add);
        RunContentManager contentManager2 = RunContentManager.getInstance((Project)this.myProject);
        RunContentDescriptor selectedDescriptor = contentManager2.getSelectedContent();
        Content selectedContent = selectedDescriptor != null ? selectedDescriptor.getAttachedContent() : null;
        for (Content content2 : debugTabs = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Debug").getContentManager().getContents()) {
            if (content2 == selectedContent) continue;
            contents.add(content2);
        }
        return contents;
    }

    @NotNull
    private static PlaceInGrid calcPlaceInGrid(Point point, Dimension size) {
        if (point.x < size.width / 3) {
            return PlaceInGrid.left;
        }
        if (point.x > size.width * 2 / 3) {
            return PlaceInGrid.right;
        }
        if (point.y > size.height * 3 / 4) {
            return PlaceInGrid.bottom;
        }
        return PlaceInGrid.center;
    }

    @Nullable
    private JBTabs getTabsAt(DockableContent content2, RelativePoint point) {
        if (content2 instanceof DockableGrid) {
            Point p = point.getPoint((Component)this.getComponent());
            for (Component c = SwingUtilities.getDeepestComponentAt(this.getComponent(), p.x, p.y); c != null; c = c.getParent()) {
                if (!(c instanceof JBRunnerTabs)) continue;
                return (JBTabs)c;
            }
        }
        return null;
    }

    public void resetDropOver(@NotNull DockableContent content2) {
        if (this.myCurrentOver != null) {
            this.myCurrentOver.resetDropOver(this.myCurrentOverInfo);
            this.myCurrentOver = null;
            this.myCurrentOverInfo = null;
            this.myCurrentOverImg = null;
            Disposer.dispose((Disposable)this.myGlassPaneListenersDisposable);
            this.myGlassPaneListenersDisposable = Disposer.newDisposable();
            this.myCurrentPainter = null;
        }
    }

    public boolean isDisposeWhenEmpty() {
        return this.myOriginal != null;
    }

    public void setManager(@NotNull ContentManager manager) {
        assert (this.myManager == null);
        this.myManager = manager;
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                GridImpl grid;
                RunnerContentUi.this.initUi();
                if (event.getContent().getUserData(LIGHTWEIGHT_CONTENT_MARKER) == Boolean.TRUE) {
                    RunnerContentUi.this.myLayoutSettings.setLightWeight(event.getContent());
                    Disposer.register((Disposable)event.getContent(), () -> RunnerContentUi.this.myLayoutSettings.clearStateFor(event.getContent()));
                }
                if ((grid = RunnerContentUi.this.getGridFor(event.getContent(), true)) == null) {
                    return;
                }
                grid.add(event.getContent());
                if (RunnerContentUi.this.getSelectedGrid() == grid) {
                    grid.processAddToUi(false);
                }
                if (RunnerContentUi.this.myManager.getComponent().isShowing() && !RunnerContentUi.this.isStateBeingRestored()) {
                    grid.restoreLastUiState();
                }
                RunnerContentUi.this.updateTabsUI(false);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                RunnerContentUi.this.fireContentOpened(event.getContent());
                if (RunnerContentUi.this.myMinimizeActionEnabled) {
                    AnAction[] actions;
                    for (AnAction action2 : actions = RunnerContentUi.this.myViewActions.getChildren(null)) {
                        if (!(action2 instanceof RestoreViewAction) || ((RestoreViewAction)action2).getContent() != event.getContent()) continue;
                        return;
                    }
                    RunnerContentUi.this.myViewActions.addAction((AnAction)new RestoreViewAction(RunnerContentUi.this, event.getContent())).setAsSecondary(true);
                    ArrayList<AnAction> toAdd = new ArrayList<AnAction>();
                    for (AnAction anAction : RunnerContentUi.this.myViewActions.getChildren(null)) {
                        if (anAction instanceof RestoreViewAction) continue;
                        RunnerContentUi.this.myViewActions.remove(anAction);
                        toAdd.add(anAction);
                    }
                    for (AnAction anAction : toAdd) {
                        RunnerContentUi.this.myViewActions.addAction(anAction).setAsSecondary(true);
                    }
                }
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                Content content2 = event.getContent();
                content2.removePropertyChangeListener((PropertyChangeListener)RunnerContentUi.this);
                GridImpl grid = (GridImpl)RunnerContentUi.this.findGridFor(content2);
                if (grid != null) {
                    grid.remove(content2);
                    if (grid.isEmpty()) {
                        grid.processRemoveFromUi();
                    }
                    RunnerContentUi.this.removeGridIfNeeded(grid);
                }
                RunnerContentUi.this.updateTabsUI(false);
                RunnerContentUi.this.fireContentClosed(content2);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (Disposer.isDisposed((Disposable)content2)) {
                        AnAction[] actions;
                        for (AnAction action2 : actions = RunnerContentUi.this.myViewActions.getChildren(null)) {
                            if (!(action2 instanceof RestoreViewAction) || ((RestoreViewAction)action2).getContent() != content2) continue;
                            RunnerContentUi.this.myViewActions.remove(action2);
                            break;
                        }
                    }
                });
            }

            public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (RunnerContentUi.this.isStateBeingRestored()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    RunnerContentUi.this.select(event.getContent(), false);
                }
            }
        });
    }

    @Nullable
    private GridImpl getSelectedGrid() {
        TabInfo selection = this.myTabs.getSelectedInfo();
        return selection != null ? RunnerContentUi.getGridFor(selection) : null;
    }

    private void removeGridIfNeeded(GridImpl grid) {
        if (grid.isEmpty()) {
            this.myTabs.removeTab(this.myTabs.findInfo((Component)((Object)grid)));
            this.myMinimizedButtonsPlaceholder.remove((Object)grid);
            this.myCommonActionsPlaceholder.remove((Object)grid);
            Disposer.dispose((Disposable)grid);
        }
    }

    @Nullable
    private GridImpl getGridFor(@NotNull Content content2, boolean createIfMissing) {
        GridImpl grid = (GridImpl)this.findGridFor(content2);
        if (grid != null || !createIfMissing) {
            return grid;
        }
        grid = new GridImpl(this, this.mySessionName);
        grid.setToolbarBefore(this.myContentToolbarBefore);
        if (this.myCurrentOver != null || this.myOriginal != null) {
            int dropIndex;
            Integer forcedDropIndex = (Integer)content2.getUserData(RunnerLayout.DROP_INDEX);
            int index = this.myTabs.getDropInfoIndex() + (this.myOriginal != null ? this.myOriginal.getTabOffsetFor(this) : 0);
            int n = dropIndex = forcedDropIndex != null ? forcedDropIndex : index;
            if (forcedDropIndex == null) {
                this.moveFollowingTabs(dropIndex);
            }
            int defaultIndex = (Integer)content2.getUserData(RunnerLayout.DEFAULT_INDEX);
            TabImpl tab = this.myLayoutSettings.getOrCreateTab(forcedDropIndex != null ? forcedDropIndex : -1);
            tab.setDefaultIndex(defaultIndex);
            tab.setIndex(dropIndex);
            this.getStateFor(content2).assignTab((Tab)tab);
            content2.putUserData(RunnerLayout.DROP_INDEX, null);
            content2.putUserData(RunnerLayout.DEFAULT_INDEX, null);
        }
        TabInfo tab = new TabInfo((JComponent)((Object)grid)).setObject((Object)this.getStateFor(content2).getTab()).setText("Tab");
        Wrapper leftWrapper = new Wrapper();
        Wrapper middleWrapper = new Wrapper();
        Wrapper rightWrapper = new Wrapper();
        this.myCommonActionsPlaceholder.put(grid, new TopToolbarWrappers(leftWrapper, middleWrapper, rightWrapper));
        Wrapper minimizedToolbar = new Wrapper();
        this.myMinimizedButtonsPlaceholder.put(grid, minimizedToolbar);
        Wrapper searchComponent = new Wrapper();
        if (content2.getSearchComponent() != null) {
            searchComponent.setContent(content2.getSearchComponent());
        }
        TwoSideComponent right = new TwoSideComponent((JComponent)searchComponent, (JComponent)minimizedToolbar);
        TwoSideComponent sideComponent = new TwoSideComponent((JComponent)leftWrapper, (JComponent)((Object)new TwoSideComponent((JComponent)middleWrapper, (JComponent)((Object)new TwoSideComponent((JComponent)((Object)right), (JComponent)rightWrapper)))));
        tab.setSideComponent((JComponent)((Object)sideComponent));
        tab.setTabLabelActions((ActionGroup)this.myActionManager.getAction(VIEW_TOOLBAR), "debuggerTabToolbar");
        this.myTabs.addTab(tab);
        this.myTabs.sortTabs(this.myTabsComparator);
        return grid;
    }

    private void moveFollowingTabs(int index) {
        if (this.myOriginal != null) {
            this.myOriginal.moveFollowingTabs(index);
            return;
        }
        RunnerContentUi.moveFollowingTabs(index, (JBTabs)this.myTabs);
        for (RunnerContentUi child2 : this.myChildren) {
            RunnerContentUi.moveFollowingTabs(index, (JBTabs)child2.myTabs);
        }
    }

    ActionGroup getSettingsActions() {
        return (ActionGroup)this.myActionManager.getAction(SETTINGS);
    }

    public ContentManager getContentManager(Content content2) {
        if (RunnerContentUi.hasContent(this.myManager, content2)) {
            return this.myManager;
        }
        for (RunnerContentUi child2 : this.myChildren) {
            if (!RunnerContentUi.hasContent(child2.myManager, content2)) continue;
            return child2.myManager;
        }
        return this.myManager;
    }

    private static boolean hasContent(ContentManager manager, Content content2) {
        return ArrayUtil.contains((Object)content2, (Object[])manager.getContents());
    }

    private static void moveFollowingTabs(int index, JBTabs tabs) {
        for (TabInfo info : tabs.getTabs()) {
            int tabIndex;
            TabImpl tab = RunnerContentUi.getTabFor(info);
            if (tab == null || (tabIndex = tab.getIndex()) < index) continue;
            tab.setIndex(tabIndex + 1);
        }
    }

    private int getTabOffsetFor(RunnerContentUi ui) {
        int offset = this.myTabs.getTabCount();
        for (RunnerContentUi child2 : this.myChildren) {
            if (child2 == ui) break;
            offset += child2.myTabs.getTabCount();
        }
        return offset;
    }

    @Nullable
    public GridCell findCellFor(@NotNull Content content2) {
        GridImpl cell = this.getGridFor(content2, false);
        return cell != null ? cell.getCellFor(content2) : null;
    }

    private boolean rebuildToolbar() {
        boolean hasToolbarContent = this.rebuildCommonActions();
        return hasToolbarContent |= this.rebuildMinimizedActions();
    }

    private boolean rebuildCommonActions() {
        boolean hasToolbarContent = false;
        for (Map.Entry<GridImpl, TopToolbarWrappers> entry : this.myCommonActionsPlaceholder.entrySet()) {
            Wrapper leftPlaceHolder = entry.getValue().left;
            Wrapper middlePlaceHolder = entry.getValue().middle;
            Wrapper rightPlaceHolder = entry.getValue().right;
            TopToolbarContextActions topToolbarContextActions = this.myContextActions.get((Object)entry.getKey());
            DefaultActionGroup leftGroupToBuild = new DefaultActionGroup();
            leftGroupToBuild.addAll(this.myTopLeftActions);
            Object[] leftActions = leftGroupToBuild.getChildren(null);
            if (topToolbarContextActions == null || !Arrays.equals(leftActions, topToolbarContextActions.left)) {
                this.setActions(leftPlaceHolder, this.myTopLeftActionsPlace, leftGroupToBuild);
            }
            DefaultActionGroup middleGroupToBuild = new DefaultActionGroup();
            middleGroupToBuild.addAll(this.myTopMiddleActions);
            Object[] middleActions = middleGroupToBuild.getChildren(null);
            if (topToolbarContextActions == null || !Arrays.equals(middleActions, topToolbarContextActions.middle)) {
                this.setActions(middlePlaceHolder, this.myTopMiddleActionsPlace, middleGroupToBuild);
            }
            DefaultActionGroup rightGroupToBuild = new DefaultActionGroup();
            rightGroupToBuild.addAll(this.myTopRightActions);
            Object[] rightActions = rightGroupToBuild.getChildren(null);
            if (topToolbarContextActions == null || !Arrays.equals(rightActions, topToolbarContextActions.right)) {
                this.setActions(rightPlaceHolder, this.myTopRightActionsPlace, rightGroupToBuild);
            }
            this.myContextActions.put(entry.getKey(), new TopToolbarContextActions((AnAction[])leftActions, (AnAction[])middleActions, (AnAction[])rightActions));
            if (leftGroupToBuild.getChildrenCount() <= 0 && rightGroupToBuild.getChildrenCount() <= 0) continue;
            hasToolbarContent = true;
        }
        return hasToolbarContent;
    }

    private void setActions(Wrapper placeHolder, String place, DefaultActionGroup group) {
        String adjustedPlace = place == "unknown" ? "toolbar" : place;
        ActionToolbar tb = this.myActionManager.createActionToolbar(adjustedPlace, (ActionGroup)group, true);
        tb.getComponent().setBorder(null);
        placeHolder.setContent(tb.getComponent());
    }

    private boolean rebuildMinimizedActions() {
        for (Map.Entry<GridImpl, Wrapper> entry : this.myMinimizedButtonsPlaceholder.entrySet()) {
            Wrapper eachPlaceholder = entry.getValue();
            ActionToolbar tb = this.myActionManager.createActionToolbar("RunnerLayoutButtonToolbar", (ActionGroup)this.myViewActions, true);
            tb.setSecondaryActionsIcon(AllIcons.Debugger.RestoreLayout);
            tb.setSecondaryActionsTooltip("Layout Settings");
            tb.setTargetComponent((JComponent)this.myComponent);
            tb.getComponent().setBorder(null);
            tb.setReservePlaceAutoPopupIcon(false);
            JComponent minimized = tb.getComponent();
            eachPlaceholder.setContent(minimized);
        }
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
        return this.myViewActions.getChildrenCount() > 0;
    }

    private void updateTabsUI(boolean validateNow) {
        boolean hasToolbarContent = this.rebuildToolbar();
        HashSet usedNames = new HashSet();
        List tabs = this.myTabs.getTabs();
        for (TabInfo each : tabs) {
            hasToolbarContent |= this.updateTabUI(each, usedNames);
        }
        int tabsCount = tabs.size() + this.myChildren.stream().mapToInt(child2 -> child2.myTabs.getTabCount()).sum();
        this.myTabs.getPresentation().setHideTabs(!hasToolbarContent && tabsCount <= 1 && this.myOriginal == null);
        this.myTabs.updateTabActions(validateNow);
        if (validateNow) {
            this.myTabs.sortTabs(this.myTabsComparator);
        }
    }

    private boolean updateTabUI(TabInfo tab, Set<? super String> usedNames) {
        String title;
        TabImpl t = RunnerContentUi.getTabFor(tab);
        if (t == null) {
            return false;
        }
        Icon icon2 = t.getIcon();
        GridImpl grid = RunnerContentUi.getGridFor(tab);
        boolean hasToolbarContent = grid.updateGridUI();
        List<Content> contents = grid.getContents();
        String string = title = contents.size() > 1 ? t.getDisplayName() : null;
        if (title == null) {
            String name = this.myLayoutSettings.getDefaultDisplayName(t.getDefaultIndex());
            title = name != null && contents.size() > 1 && !usedNames.contains(name) ? name : StringUtil.join(contents, (Function)((NotNullFunction)Content::getTabName), (String)" | ");
        }
        usedNames.add(title);
        boolean hidden = true;
        for (Content content2 : contents) {
            if (grid.isMinimized(content2)) continue;
            hidden = false;
            break;
        }
        tab.setHidden(hidden);
        if (icon2 == null && contents.size() == 1) {
            icon2 = contents.get(0).getIcon();
        }
        tab.setDragOutDelegate((TabInfo.DragOutDelegate)(this.myTabs.getTabs().size() > 1 || !this.isOriginal() ? this.myDragOutDelegate : null));
        Tab gridTab = grid.getTab();
        tab.setText(title).setIcon((Icon)(gridTab != null && gridTab.isDefault() && contents.size() > 1 ? null : icon2));
        return hasToolbarContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionCallback restoreLastUiState() {
        if (this.isStateBeingRestored()) {
            return ActionCallback.REJECTED;
        }
        try {
            this.setStateIsBeingRestored(true, this);
            ArrayList tabs = new ArrayList(this.myTabs.getTabs());
            ActionCallback result2 = new ActionCallback(tabs.size());
            for (TabInfo each : tabs) {
                RunnerContentUi.getGridFor(each).restoreLastUiState().notifyWhenDone(result2);
            }
            ActionCallback actionCallback = result2;
            return actionCallback;
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
    }

    public void saveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        if (this.myOriginal != null) {
            this.myOriginal.saveUiState();
            return;
        }
        if (!this.myUiLastStateWasRestored) {
            return;
        }
        int offset = RunnerContentUi.updateTabsIndices((JBTabs)this.myTabs, 0);
        for (RunnerContentUi child2 : this.myChildren) {
            offset = RunnerContentUi.updateTabsIndices((JBTabs)child2.myTabs, offset);
        }
        this.doSaveUiState();
    }

    private static int updateTabsIndices(JBTabs tabs, int offset) {
        for (TabInfo each : tabs.getTabs()) {
            int index = tabs.getIndexOf(each);
            TabImpl tab = RunnerContentUi.getTabFor(each);
            if (tab == null) continue;
            tab.setIndex(index >= 0 ? index + offset : index);
        }
        return offset + tabs.getTabCount();
    }

    private void doSaveUiState() {
        if (this.isStateBeingRestored()) {
            return;
        }
        for (TabInfo each : this.myTabs.getTabs()) {
            GridImpl eachGrid = RunnerContentUi.getGridFor(each);
            eachGrid.saveUiState();
        }
        for (RunnerContentUi child2 : this.myChildren) {
            child2.doSaveUiState();
        }
    }

    @Nullable
    public Tab getTabFor(Grid grid) {
        TabInfo info = this.myTabs.findInfo((Component)grid);
        return RunnerContentUi.getTabFor(info);
    }

    public void showNotify() {
        Window window = SwingUtilities.getWindowAncestor((Component)this.myComponent);
        if (window instanceof IdeFrame.Child) {
            ((IdeFrame.Child)window).setFrameTitle(this.mySessionName);
        }
    }

    @Nullable
    private static TabImpl getTabFor(@Nullable TabInfo tab) {
        if (tab == null) {
            return null;
        }
        return (TabImpl)tab.getObject();
    }

    private static GridImpl getGridFor(TabInfo tab) {
        return (GridImpl)((Object)tab.getComponent());
    }

    @Nullable
    public Grid findGridFor(@NotNull Content content2) {
        TabImpl tab = (TabImpl)this.getStateFor(content2).getTab();
        for (TabInfo each : this.myTabs.getTabs()) {
            TabImpl t = RunnerContentUi.getTabFor(each);
            if (t == null || !t.equals(tab)) continue;
            return RunnerContentUi.getGridFor(each);
        }
        return null;
    }

    @NotNull
    private List<GridImpl> getGrids() {
        return ContainerUtil.map((Collection)this.myTabs.getTabs(), RunnerContentUi::getGridFor);
    }

    public boolean isSingleSelection() {
        return false;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return true;
    }

    public void beforeDispose() {
        if (this.myOriginal != null) {
            this.myDisposing = true;
            this.fireContentClosed(null);
        }
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        GridImpl grid;
        if (implicit && (grid = this.getGridFor(content2, false)) != null) {
            return !grid.isMinimized(content2);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getPreviousContentActionName() {
        return ExecutionBundle.message((String)"select.previous.tab", (Object[])new Object[0]);
    }

    @NotNull
    public String getNextContentActionName() {
        return ExecutionBundle.message((String)"select.next.tab", (Object[])new Object[0]);
    }

    public void dispose() {
        if (this.myOriginal != null) {
            this.myOriginal.myChildren.remove(this);
        }
        this.myMinimizedButtonsPlaceholder.clear();
        this.myCommonActionsPlaceholder.clear();
        this.myContextActions.clear();
        this.myOriginal = null;
        this.myTopLeftActions = null;
        this.myTopRightActions = null;
        this.myAdditionalFocusActions = null;
        this.myLeftToolbarActions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void restoreLayout() {
        void var6_13;
        int n;
        RunnerContentUi[] runnerContentUiArray;
        RunnerContentUi[] children2 = this.myChildren.toArray(new RunnerContentUi[0]);
        LinkedHashSet<Content> contents = new LinkedHashSet<Content>();
        Collections.addAll(contents, this.myManager.getContents());
        for (RunnerContentUi runnerContentUi : children2) {
            Collections.addAll(contents, runnerContentUi.myManager.getContents());
        }
        for (RunnerContentUi runnerContentUi : this.myViewActions.getChildren(null)) {
            if (!(runnerContentUi instanceof RestoreViewAction)) continue;
            contents.add(((RestoreViewAction)((Object)runnerContentUi)).getContent());
        }
        Content[] all = contents.toArray(new Content[0]);
        Arrays.sort(all, Comparator.comparingInt(content2 -> this.getStateFor((Content)content2).getTab().getDefaultIndex()));
        this.setStateIsBeingRestored(true, this);
        try {
            void var6_11;
            runnerContentUiArray = children2;
            n = runnerContentUiArray.length;
            boolean bl = false;
            while (var6_11 < n) {
                RunnerContentUi runnerContentUi = runnerContentUiArray[var6_11];
                runnerContentUi.myManager.removeAllContents(false);
                ++var6_11;
            }
            this.myManager.removeAllContents(false);
        }
        finally {
            this.setStateIsBeingRestored(false, this);
        }
        this.myLayoutSettings.resetToDefault();
        runnerContentUiArray = all;
        n = runnerContentUiArray.length;
        boolean bl = false;
        while (var6_13 < n) {
            RunnerContentUi runnerContentUi = runnerContentUiArray[var6_13];
            this.myManager.addContent((Content)runnerContentUi);
            ++var6_13;
        }
        this.updateTabsUI(true);
    }

    public boolean isStateBeingRestored() {
        return !this.myRestoreStateRequestors.isEmpty();
    }

    public void setStateIsBeingRestored(boolean restoredNow, Object requestor) {
        if (restoredNow) {
            this.myRestoreStateRequestors.add(requestor);
        } else {
            this.myRestoreStateRequestors.remove(requestor);
        }
    }

    ActionGroup getLayoutActions() {
        return (ActionGroup)this.myActionManager.getAction(LAYOUT);
    }

    public void updateActionsImmediately() {
        Collection<TopToolbarWrappers> values2 = this.myCommonActionsPlaceholder.values();
        Stream<Wrapper> leftWrappers = values2.stream().map(it -> it.left);
        Stream<Wrapper> rightWrappers = values2.stream().map(it -> it.right);
        ((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Object)this.myToolbar).append(leftWrappers)).append(rightWrappers)).map(Wrapper::getTargetComponent).select(ActionToolbar.class).distinct()).forEach(ActionToolbar::updateActionsImmediately);
    }

    void setMinimizeActionEnabled(boolean enabled) {
        this.myMinimizeActionEnabled = enabled;
        this.updateRestoreLayoutActionVisibility();
    }

    private void updateRestoreLayoutActionVisibility() {
        ArrayList<AnAction> specialActions = new ArrayList<AnAction>();
        for (AnAction action2 : this.myViewActions.getChildren(null)) {
            if (action2 instanceof RestoreViewAction) continue;
            specialActions.add(action2);
        }
        if (this.myMinimizeActionEnabled) {
            if (specialActions.isEmpty()) {
                this.myViewActions.addAction((AnAction)new Separator()).setAsSecondary(true);
                this.myViewActions.addAction(ActionManager.getInstance().getAction("Runner.RestoreLayout")).setAsSecondary(true);
            }
        } else {
            for (AnAction action3 : specialActions) {
                this.myViewActions.remove(action3);
            }
        }
    }

    void setMovetoGridActionEnabled(boolean enabled) {
        this.myMoveToGridActionEnabled = enabled;
        if (this.myTabs != null) {
            this.myTabs.getPresentation().setTabDraggingEnabled(enabled);
        }
    }

    public boolean isMinimizeActionEnabled() {
        return this.myMinimizeActionEnabled && this.myOriginal == null;
    }

    public boolean isMoveToGridActionEnabled() {
        return this.myMoveToGridActionEnabled;
    }

    public void setPolicy(String contentId, LayoutAttractionPolicy policy) {
        this.myAttractions.put(contentId, policy);
    }

    void setConditionPolicy(String condition, LayoutAttractionPolicy policy) {
        this.myConditionAttractions.put(condition, policy);
    }

    private static LayoutAttractionPolicy getOrCreatePolicyFor(String key, Map<String, LayoutAttractionPolicy> map2, LayoutAttractionPolicy defaultPolicy) {
        return map2.computeIfAbsent(key, __ -> defaultPolicy);
    }

    @Nullable
    public Content findContent(String key) {
        Content[] contents;
        ContentManager manager = this.getContentManager();
        if (manager == null || key == null) {
            return null;
        }
        for (Content content2 : contents = manager.getContents()) {
            String kind = (String)content2.getUserData(ViewImpl.ID);
            if (!key.equals(kind)) continue;
            return content2;
        }
        return null;
    }

    public void restoreContent(String key) {
        for (AnAction action2 : this.myViewActions.getChildren(null)) {
            Content content2;
            if (!(action2 instanceof RestoreViewAction) || !key.equals((content2 = ((RestoreViewAction)action2).getContent()).getUserData(ViewImpl.ID))) continue;
            this.restore(content2);
            return;
        }
    }

    void setToDisposeRemovedContent(boolean toDispose) {
        this.myToDisposeRemovedContent = toDispose;
    }

    public boolean isToDisposeRemovedContent() {
        return this.myToDisposeRemovedContent;
    }

    private void attractOnStartup() {
        int currentCount = this.myAttractionCount;
        SwingUtilities.invokeLater(() -> {
            if (currentCount < this.myAttractionCount) {
                return;
            }
            this.attractByCondition("startup", false);
        });
    }

    public void attract(Content content2, boolean afterInitialized) {
        this.processAttraction((String)content2.getUserData(ViewImpl.ID), this.myAttractions, (LayoutAttractionPolicy)new LayoutAttractionPolicy.Bounce(), afterInitialized, true);
    }

    void attractByCondition(@NotNull String condition, boolean afterInitialized) {
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), this.myConditionAttractions, this.myLayoutSettings.getAttractionPolicy(condition), afterInitialized, true);
    }

    void clearAttractionByCondition(String condition, boolean afterInitialized) {
        this.processAttraction(this.myLayoutSettings.getToFocus(condition), this.myConditionAttractions, (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(), afterInitialized, false);
    }

    private void processAttraction(String contentId, Map<String, LayoutAttractionPolicy> policyMap, LayoutAttractionPolicy defaultPolicy, boolean afterInitialized, boolean activate2) {
        IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> this.myInitialized.processOnDone(() -> {
            Content content2 = this.findContent(contentId);
            if (content2 == null) {
                return;
            }
            LayoutAttractionPolicy policy = RunnerContentUi.getOrCreatePolicyFor(contentId, policyMap, defaultPolicy);
            if (activate2) {
                if (!(policy instanceof LayoutAttractionPolicy.Bounce)) {
                    ++this.myAttractionCount;
                }
                policy.attract(content2, this.myRunnerUi);
            } else {
                policy.clearAttraction(content2, this.myRunnerUi);
            }
        }, afterInitialized));
    }

    public static boolean ensureValid(JComponent c) {
        Container eachParent;
        if (c.getRootPane() == null) {
            return false;
        }
        for (eachParent = c.getParent(); eachParent != null && eachParent.isValid(); eachParent = eachParent.getParent()) {
        }
        if (eachParent == null) {
            eachParent = c.getRootPane();
        }
        eachParent.validate();
        return true;
    }

    ContentUI getContentUI() {
        return this;
    }

    public void minimize(Content content2, CellTransform.Restore restore) {
        this.getStateFor(content2).setMinimizedInGrid(true);
        this.myManager.removeContent(content2, false);
        this.saveUiState();
        this.updateTabsUI(false);
    }

    public void restore(@NotNull Content content2) {
        GridImpl grid = this.getGridFor(content2, false);
        if (grid == null) {
            this.getStateFor(content2).assignTab((Tab)this.myLayoutSettings.getOrCreateTab(-1));
        } else {
            ((GridCellImpl)this.findCellFor(content2)).restore(content2);
        }
        this.getStateFor(content2).setMinimizedInGrid(false);
        this.myManager.addContent(content2);
        this.saveUiState();
        this.select(content2, true);
        this.updateTabsUI(false);
    }

    public Project getProject() {
        return this.myProject;
    }

    public CellTransform.Facade getCellTransform() {
        return this;
    }

    public ContentManager getContentManager() {
        return this.myManager;
    }

    @NotNull
    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    @Override
    public RunnerLayout getLayoutSettings() {
        return this.myLayoutSettings;
    }

    public View getStateFor(@NotNull Content content2) {
        return this.myLayoutSettings.getStateFor(content2);
    }

    public ActionCallback select(@NotNull Content content2, boolean requestFocus) {
        GridImpl grid = (GridImpl)this.findGridFor(content2);
        if (grid == null) {
            return ActionCallback.DONE;
        }
        TabInfo info = this.myTabs.findInfo((Component)((Object)grid));
        if (info == null) {
            return ActionCallback.DONE;
        }
        ActionCallback result2 = new ActionCallback();
        this.myTabs.select(info, false).doWhenDone(() -> grid.select(content2, requestFocus).notifyWhenDone(result2));
        return result2;
    }

    public void validate(Content content2, ActiveRunnable toRestore) {
        TabInfo current2 = this.myTabs.getSelectedInfo();
        this.myTabs.getPresentation().setPaintBlocked(true, true);
        this.select(content2, false).doWhenDone(() -> {
            this.myTabs.getComponent().validate();
            toRestore.run().doWhenDone(() -> {
                assert (current2 != null);
                this.myTabs.select(current2, true);
                this.myTabs.getPresentation().setPaintBlocked(false, true);
            });
        });
    }

    public IdeFocusManager getFocusManager() {
        return this.myFocusManager;
    }

    public RunnerLayoutUi getRunnerLayoutUi() {
        return this.myRunnerUi;
    }

    @NotNull
    public String getName() {
        return this.mySessionName;
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        if (this.myLeftToolbarActions != null) {
            Object[] kids = this.myLeftToolbarActions.getChildren(null);
            ContainerUtil.addAll(result2, (Object[])kids);
        }
        return result2;
    }

    private int findFreeWindow() {
        int i2;
        for (i2 = 1; i2 < Integer.MAX_VALUE; ++i2) {
            if (this.isUsed(i2)) continue;
            return i2;
        }
        return i2;
    }

    private boolean isUsed(int i2) {
        return this.myChildren.stream().anyMatch(child2 -> child2.getWindow() == i2);
    }

    private DockManagerImpl getDockManager() {
        return (DockManagerImpl)DockManager.getInstance((Project)this.myProject);
    }

    private void fireContentOpened(@NotNull Content content2) {
        for (DockContainer.Listener each : this.myDockingListeners) {
            each.contentAdded((Object)content2);
        }
    }

    private void fireContentClosed(Content content2) {
        for (DockContainer.Listener each : this.myDockingListeners) {
            each.contentRemoved((Object)content2);
        }
    }

    private static class TopToolbarWrappers {
        public final Wrapper left;
        public final Wrapper middle;
        public final Wrapper right;

        private TopToolbarWrappers(Wrapper left, Wrapper middle2, Wrapper right) {
            this.left = left;
            this.middle = middle2;
            this.right = right;
        }
    }

    private static class TopToolbarContextActions {
        public final AnAction[] left;
        public final AnAction[] middle;
        public final AnAction[] right;

        private TopToolbarContextActions(AnAction[] left, AnAction[] middle2, AnAction[] right) {
            this.left = left;
            this.middle = middle2;
            this.right = right;
        }
    }

    public static class ShowDebugContentAction
    extends AnAction
    implements DumbAware {
        public static final String ACTION_ID = "ShowDebugContent";
        private RunnerContentUi myContentUi;

        public ShowDebugContentAction() {
        }

        public ShowDebugContentAction(RunnerContentUi runner, JComponent component2, @NotNull Disposable parentDisposable) {
            this.myContentUi = runner;
            AnAction original = ActionManager.getInstance().getAction("ShowContent");
            new ShadowAction((AnAction)this, original, component2, parentDisposable);
            ActionUtil.copyFrom((AnAction)this, (String)"ShowContent");
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myContentUi != null && this.myContentUi.getPopupContents().size() > 1);
            e.getPresentation().setText(ExecutionBundle.messagePointer((String)"action.presentation.RunnerContentUi.text.show.list.of.tabs", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myContentUi.toggleContentPopup((JBTabs)e.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY));
        }
    }

    class DockableGrid
    implements DockableContent<List<Content>> {
        private final Image myImg;
        private final Presentation myPresentation;
        private final Dimension myPreferredSize;
        private final List<Content> myContents;
        private final int myWindow;

        DockableGrid(Image img, Presentation presentation2, Dimension size, List<Content> contents, int window) {
            this.myImg = img;
            this.myPresentation = presentation2;
            this.myPreferredSize = size;
            this.myContents = contents;
            this.myWindow = window;
        }

        @NotNull
        public List<Content> getKey() {
            return this.myContents;
        }

        public Image getPreviewImage() {
            return this.myImg;
        }

        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        public String getDockContainerType() {
            return "runner-grid";
        }

        public Presentation getPresentation() {
            return this.myPresentation;
        }

        RunnerContentUi getRunnerUi() {
            return RunnerContentUi.this;
        }

        RunnerContentUi getOriginalRunnerUi() {
            return RunnerContentUi.this.myOriginal != null ? RunnerContentUi.this.myOriginal : RunnerContentUi.this;
        }

        @NotNull
        public List<Content> getContents() {
            return this.myContents;
        }

        public void close() {
        }

        public int getWindow() {
            return this.myWindow;
        }
    }

    class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private DragSession mySession;

        MyDragOutDelegate() {
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            JComponent component2 = info.getComponent();
            Content[] data2 = (Content[])ViewContext.CONTENT_KEY.getData((DataProvider)component2);
            assert (data2 != null);
            RunnerContentUi.this.storeDefaultIndices(data2);
            Dimension size = info.getComponent().getSize();
            Image image = JBTabsImpl.getComponentImage((TabInfo)info);
            if (component2 instanceof Grid) {
                info.setHidden(true);
            }
            Presentation presentation2 = new Presentation(info.getText());
            presentation2.setIcon(info.getIcon());
            this.mySession = RunnerContentUi.this.getDockManager().createDragSession(mouseEvent, new DockableGrid(image, presentation2, size, Arrays.asList(data2), 0));
        }

        public void processDragOut(@NotNull MouseEvent event, @NotNull TabInfo source) {
            this.mySession.process(event);
        }

        public void dragOutFinished(@NotNull MouseEvent event, TabInfo source) {
            this.mySession.process(event);
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source) {
            source.setHidden(false);
            this.mySession.cancel();
            this.mySession = null;
        }
    }

    private static class CommonToolbarLayout
    extends AbstractLayoutManager {
        private final JComponent myLeft;
        private final JComponent myRight;

        CommonToolbarLayout(JComponent left, JComponent right) {
            this.myLeft = left;
            this.myRight = right;
        }

        public Dimension preferredLayoutSize(@NotNull Container parent) {
            Dimension size = new Dimension();
            Dimension leftSize = this.myLeft.getPreferredSize();
            Dimension rightSize = this.myRight.getPreferredSize();
            size.width = leftSize.width + rightSize.width;
            size.height = Math.max(leftSize.height, rightSize.height);
            return size;
        }

        public void layoutContainer(@NotNull Container parent) {
            Dimension size = parent.getSize();
            Dimension prefSize = parent.getPreferredSize();
            if (prefSize.width <= size.width) {
                this.myLeft.setBounds(0, 0, this.myLeft.getPreferredSize().width, parent.getHeight());
                Dimension rightSize = this.myRight.getPreferredSize();
                this.myRight.setBounds(parent.getWidth() - rightSize.width, 0, rightSize.width, parent.getHeight());
            } else {
                Dimension leftMinSize = this.myLeft.getMinimumSize();
                Dimension rightMinSize = this.myRight.getMinimumSize();
                int delta = 0;
                this.myLeft.setBounds(0, 0, this.myLeft.getPreferredSize().width - delta, parent.getHeight());
                int rightX = (int)this.myLeft.getBounds().getMaxX();
                int rightWidth = size.width - rightX;
                if (rightWidth < rightMinSize.width) {
                    Dimension leftSize = this.myLeft.getSize();
                    int diffToRightMin = rightMinSize.width - rightWidth;
                    if (leftSize.width - diffToRightMin >= leftMinSize.width) {
                        leftSize.width -= diffToRightMin;
                        this.myLeft.setSize(leftSize);
                    }
                }
                this.myRight.setBounds((int)this.myLeft.getBounds().getMaxX(), 0, parent.getWidth() - this.myLeft.getWidth(), parent.getHeight());
            }
            CommonToolbarLayout.toMakeVerticallyInCenter(this.myLeft, parent);
            CommonToolbarLayout.toMakeVerticallyInCenter(this.myRight, parent);
        }

        private static void toMakeVerticallyInCenter(JComponent comp, Container parent) {
            Rectangle compBounds = comp.getBounds();
            int compHeight = comp.getPreferredSize().height;
            int parentHeight = parent.getHeight();
            if (compHeight > parentHeight) {
                compHeight = parentHeight;
            }
            int y = (int)Math.floor((double)parentHeight / 2.0 - (double)compHeight / 2.0);
            comp.setBounds(compBounds.x, y, compBounds.width, compHeight);
        }
    }

    private static class TwoSideComponent
    extends NonOpaquePanel {
        private TwoSideComponent(JComponent left, JComponent right) {
            this.setLayout((LayoutManager)((Object)new CommonToolbarLayout(left, right)));
            this.add(left);
            this.add(right);
        }
    }

    private class MyComponent
    extends NonOpaquePanel
    implements DataProvider,
    QuickActionProvider {
        private boolean myWasEverAdded;

        MyComponent(LayoutManager layout) {
            super(layout);
            this.setOpaque(true);
            this.setFocusCycleRoot(!ScreenReader.isActive());
            this.setBorder(new ToolWindowEx.Border(false, false, false, false));
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            JComponent originalContentComponent;
            ContentManager contentManager2;
            Content content2;
            if (QuickActionProvider.KEY.is(dataId)) {
                return RunnerContentUi.this;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId) && (content2 = RunnerContentUi.this.getContentManager().getSelectedContent()) != null && content2.isCloseable() && (contentManager2 = Objects.requireNonNull(content2.getManager())).canCloseContents()) {
                return () -> contentManager2.removeContent(content2, true, true, true);
            }
            ContentManager originalContentManager = RunnerContentUi.this.myOriginal == null ? null : RunnerContentUi.this.myOriginal.getContentManager();
            JComponent jComponent = originalContentComponent = originalContentManager == null ? null : originalContentManager.getComponent();
            if (originalContentComponent instanceof DataProvider) {
                return ((DataProvider)originalContentComponent).getData(dataId);
            }
            return null;
        }

        @NotNull
        public String getName() {
            return RunnerContentUi.this.getName();
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            return RunnerContentUi.this.getActions(originalProvider);
        }

        public JComponent getComponent() {
            return RunnerContentUi.this.getComponent();
        }

        public boolean isCycleRoot() {
            return RunnerContentUi.this.isCycleRoot();
        }

        public void addNotify() {
            super.addNotify();
            if (null != ComponentUtil.findParentByCondition((Component)((Object)this), component2 -> UIUtil.isClientPropertyTrue((Object)component2, (Object)"TEMPORARY_ADDED"))) {
                return;
            }
            if (!RunnerContentUi.this.myUiLastStateWasRestored && RunnerContentUi.this.myOriginal == null) {
                RunnerContentUi.this.myUiLastStateWasRestored = true;
                SwingUtilities.invokeLater(() -> RunnerContentUi.this.restoreLastUiState().doWhenDone(() -> {
                    if (!this.myWasEverAdded) {
                        this.myWasEverAdded = true;
                        RunnerContentUi.this.attractOnStartup();
                        RunnerContentUi.this.myInitialized.setDone();
                    }
                }));
            }
        }

        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                return;
            }
            if (Disposer.isDisposed((Disposable)RunnerContentUi.this)) {
                return;
            }
            RunnerContentUi.this.saveUiState();
        }
    }

    private static class MyDropAreaPainter
    extends AbstractPainter {
        private Shape myBoundingBox;
        private final Color myColor = ColorUtil.mix((Color)JBColor.BLUE, (Color)JBColor.WHITE, (double)0.3);

        private MyDropAreaPainter() {
        }

        public boolean needsRepaint() {
            return this.myBoundingBox != null;
        }

        public void executePaint(Component component2, Graphics2D g) {
            if (this.myBoundingBox == null) {
                return;
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(ColorUtil.toAlpha((Color)this.myColor, (int)200));
            g.setStroke(new BasicStroke(2.0f));
            g.draw(this.myBoundingBox);
            g.setColor(ColorUtil.toAlpha((Color)this.myColor, (int)40));
            g.fill(this.myBoundingBox);
        }

        private void processDropOver(RunnerContentUi ui, DockableContent dockable, RelativePoint dropTarget) {
            Point point;
            this.myBoundingBox = null;
            this.setNeedsRepaint(true);
            if (!(dockable instanceof DockableGrid)) {
                return;
            }
            NonOpaquePanel component2 = ui.myComponent;
            Point point2 = point = dropTarget != null ? dropTarget.getPoint((Component)component2) : null;
            if (ui.myTabs.shouldAddToGlobal(point)) {
                return;
            }
            PlaceInGrid targetPlaceInGrid = null;
            for (Content c : ((DockableGrid)dockable).getContents()) {
                View view = ui.getStateFor(c);
                if (view.isMinimizedInGrid()) continue;
                PlaceInGrid defaultGridPlace = ui.getLayoutSettings().getDefaultGridPlace(c);
                PlaceInGrid placeInGrid = targetPlaceInGrid = point == null ? defaultGridPlace : RunnerContentUi.calcPlaceInGrid(point, component2.getSize());
                break;
            }
            if (targetPlaceInGrid == null) {
                return;
            }
            Dimension size = component2.getSize();
            Rectangle r = new Rectangle(size);
            switch (targetPlaceInGrid) {
                case left: {
                    r.width /= 3;
                    break;
                }
                case center: {
                    r.width /= 3;
                    r.x += r.width;
                    break;
                }
                case right: {
                    r.width /= 3;
                    r.x += 2 * r.width;
                    break;
                }
                case bottom: {
                    r.height /= 4;
                    r.y += 3 * r.height;
                }
            }
            for (Content c : ui.getContentManager().getContents()) {
                JComponent cellWrapper;
                PlaceInGrid placeInGrid;
                GridCell cellFor = ui.findCellFor(c);
                PlaceInGrid placeInGrid2 = placeInGrid = cellFor == null ? null : ((GridCellImpl)cellFor).getPlaceInGrid();
                if (placeInGrid != targetPlaceInGrid) continue;
                Wrapper wrapper2 = (Wrapper)ComponentUtil.getParentOfType(Wrapper.class, (Component)c.getComponent());
                JComponent jComponent = cellWrapper = wrapper2 == null ? null : (JComponent)wrapper2.getParent();
                if (cellWrapper == null || !cellWrapper.isShowing()) continue;
                r = new RelativeRectangle(cellWrapper).getRectangleOn((Component)component2);
                break;
            }
            this.myBoundingBox = new RoundRectangle2D.Double(r.x, r.y, r.width, r.height, 16.0, 16.0);
        }
    }
}

