/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.impl.JBRunnerTabsBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SideBorder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBRunnerTabs
extends SingleHeightTabs
implements JBRunnerTabsBase {
    public static JBRunnerTabsBase create(@Nullable Project project, @NotNull Disposable parentDisposable) {
        return new JBRunnerTabs(project, parentDisposable);
    }

    protected TabPainterAdapter createTabPainterAdapter() {
        return new DefaultTabPainterAdapter(JBTabPainter.getDEBUGGER());
    }

    public JBRunnerTabs(@Nullable Project project, @NotNull Disposable parent) {
        super(project, parent);
    }

    @Deprecated
    public JBRunnerTabs(@Nullable Project project, @NotNull ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        super(project, parent);
    }

    protected SingleRowLayout createSingleRowLayout() {
        return new ScrollableSingleRowLayout((JBTabsImpl)this);
    }

    protected JBTabsBorder createTabBorder() {
        return new JBRunnerTabsBorder((JBTabsImpl)this);
    }

    public boolean useSmallLabels() {
        return true;
    }

    public int getToolbarInset() {
        return 0;
    }

    @Override
    public boolean shouldAddToGlobal(Point point) {
        TabLabel label2 = this.getSelectedLabel();
        if (label2 == null || point == null) {
            return true;
        }
        Rectangle bounds2 = label2.getBounds();
        return point.y <= bounds2.y + bounds2.height;
    }

    public Rectangle layout(JComponent c, Rectangle bounds2) {
        if (c instanceof JBTabsImpl.Toolbar) {
            bounds2.height -= this.getSeparatorWidth();
            return super.layout(c, bounds2);
        }
        return super.layout(c, bounds2);
    }

    public void processDropOver(TabInfo over, RelativePoint relativePoint) {
        Point point = relativePoint.getPoint((Component)this.getComponent());
        this.myShowDropLocation = this.shouldAddToGlobal(point);
        super.processDropOver(over, relativePoint);
        for (Map.Entry entry : this.myInfo2Label.entrySet()) {
            TabLabel label2 = (TabLabel)entry.getValue();
            if (!label2.getBounds().contains(point) || this.myDropInfo == entry.getKey()) continue;
            this.select((TabInfo)entry.getKey(), false);
            break;
        }
    }

    @NotNull
    protected TabLabel createTabLabel(@NotNull TabInfo info) {
        return new SingleHeightTabs.SingleHeightLabel((JBTabsImpl)this, info){

            public void setTabActions(ActionGroup group) {
                super.setTabActions(group);
                if (this.myActionPanel != null) {
                    JComponent wrapper2 = (JComponent)this.myActionPanel.getComponent(0);
                    wrapper2.remove(0);
                    wrapper2.add(Box.createHorizontalStrut(6), "West");
                }
            }
        };
    }

    class JBRunnerTabsBorder
    extends JBTabsBorder {
        private int mySideMask;

        JBRunnerTabsBorder(JBTabsImpl tabs) {
            super(tabs);
            this.mySideMask = 1;
        }

        @NotNull
        public Insets getEffectiveBorder() {
            return new Insets(JBRunnerTabs.this.getBorderThickness(), (this.mySideMask & 1) != 0 ? JBRunnerTabs.this.getBorderThickness() : 0, 0, 0);
        }

        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (JBRunnerTabs.this.isEmptyVisible()) {
                return;
            }
            if ((this.mySideMask & 1) != 0) {
                JBRunnerTabs.this.getTabPainter().paintBorderLine((Graphics2D)g, JBRunnerTabs.this.getBorderThickness(), new Point(x, y), new Point(x, y + height));
            }
            if (JBTabsImpl.NEW_TABS) {
                if (JBRunnerTabs.this.getLastLayoutPass() == null || JBRunnerTabs.this.getLastLayoutPass().getExtraBorderLines() == null) {
                    return;
                }
                List borderLines = JBRunnerTabs.this.getLastLayoutPass().getExtraBorderLines();
                for (LayoutPassInfo.LineCoordinates borderLine : borderLines) {
                    JBRunnerTabs.this.getTabPainter().paintBorderLine((Graphics2D)g, JBRunnerTabs.this.getBorderThickness(), borderLine.from(), borderLine.to());
                }
            } else {
                JBRunnerTabs.this.getTabPainter().paintBorderLine((Graphics2D)g, JBRunnerTabs.this.getBorderThickness(), new Point(x, y + JBRunnerTabs.this.myHeaderFitSize.height), new Point(x + width, y + JBRunnerTabs.this.myHeaderFitSize.height));
            }
        }

        void setSideMask(@SideBorder.SideMask int mask) {
            this.mySideMask = mask;
        }
    }
}

