/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.FragmentedSettingsEditor;
import com.intellij.execution.ui.RunConfigurationEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class RunConfigurationFragmentedEditor<Settings extends RunConfigurationBase<?>>
extends FragmentedSettingsEditor<Settings> {
    private static final Logger LOG = Logger.getInstance(RunConfigurationFragmentedEditor.class);
    private final Settings myRunConfiguration;
    private final RunConfigurationExtensionsManager<RunConfigurationBase<?>, RunConfigurationExtensionBase<RunConfigurationBase<?>>> myExtensionsManager;

    protected RunConfigurationFragmentedEditor(Settings runConfiguration, RunConfigurationExtensionsManager extensionsManager) {
        this.myRunConfiguration = runConfiguration;
        this.myExtensionsManager = extensionsManager;
    }

    protected final List<SettingsEditorFragment<Settings, ?>> createFragments() {
        ArrayList fragments = new ArrayList(this.createRunFragments());
        for (SettingsEditorFragment wrapper2 : this.myExtensionsManager.createFragments(this.myRunConfiguration)) {
            fragments.add(wrapper2);
        }
        this.addRunnerSettingsEditors(fragments);
        return fragments;
    }

    private void addRunnerSettingsEditors(List<SettingsEditorFragment<Settings, ?>> fragments) {
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            final ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), this.myRunConfiguration);
            if (runner == null) continue;
            final SettingsEditor configEditor = this.myRunConfiguration.getRunnerSettingsEditor(runner);
            final SettingsEditor runnerEditor = runner.getSettingsEditor(executor, this.myRunConfiguration);
            if (configEditor == null && runnerEditor == null) continue;
            JPanel component2 = new JPanel(new BorderLayout());
            component2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)executor.getStartActionText(), (boolean)false));
            if (configEditor != null) {
                component2.add((Component)configEditor.getComponent(), "Center");
            }
            if (runnerEditor != null) {
                component2.add((Component)runnerEditor.getComponent(), configEditor == null ? "Center" : "South");
            }
            RunConfigurationEditorFragment fragment = new RunConfigurationEditorFragment<Settings, JComponent>(executor.getId() + ".config", executor.getStartActionText(), ExecutionBundle.message((String)"run.configuration.startup.connection.rab.title", (Object[])new Object[0]), component2, 0){

                @Override
                public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
                    if (configEditor != null) {
                        configEditor.resetFrom((Object)s.getConfigurationSettings(runner));
                    }
                    if (runnerEditor != null) {
                        runnerEditor.resetFrom(s.getRunnerSettings(runner));
                    }
                }

                @Override
                public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
                    try {
                        if (configEditor != null) {
                            configEditor.applyTo((Object)s.getConfigurationSettings(runner));
                        }
                        if (runnerEditor != null) {
                            runnerEditor.applyTo(s.getRunnerSettings(runner));
                        }
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            if (configEditor != null) {
                Disposer.register((Disposable)fragment, (Disposable)configEditor);
            }
            if (runnerEditor != null) {
                Disposer.register((Disposable)fragment, (Disposable)runnerEditor);
            }
            fragments.add(fragment);
        }
    }

    protected abstract List<SettingsEditorFragment<Settings, ?>> createRunFragments();

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
        for (RunConfigurationEditorFragment<?, ?> fragment : this.getRunFragments()) {
            fragment.resetEditorFrom(s);
        }
    }

    public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
        for (RunConfigurationEditorFragment<?, ?> fragment : this.getRunFragments()) {
            fragment.applyEditorTo(s);
        }
    }

    @NotNull
    private @NotNull List<@NotNull RunConfigurationEditorFragment<?, ?>> getRunFragments() {
        return ContainerUtil.mapNotNull((Collection)this.getFragments(), fragment -> fragment instanceof RunConfigurationEditorFragment ? (RunConfigurationEditorFragment)((Object)fragment) : null);
    }
}

