/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStatusLine
extends NonOpaquePanel {
    private static final SimpleTextAttributes IGNORE_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.YELLOW);
    private static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.RED_TEXT);
    protected final JProgressBar myProgressBar = new JProgressBar();
    protected final SimpleColoredComponent myState = new SimpleColoredComponent();
    private final JPanel myProgressPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());

    public TestStatusLine() {
        super((LayoutManager)new BorderLayout());
        this.add(this.myProgressPanel, "South");
        this.myProgressBar.setMaximum(100);
        this.myProgressBar.putClientProperty("ProgressBar.stripeWidth", 3);
        this.myProgressBar.putClientProperty("ProgressBar.flatEnds", Boolean.TRUE);
        this.setStatusColor(ColorProgressBar.GREEN);
        NonOpaquePanel stateWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myState.setOpaque(false);
        stateWrapper.add((Component)this.myState, "North");
        this.add((Component)stateWrapper, "Center");
        this.myState.append(ExecutionBundle.message((String)"junit.runing.info.starting.label", (Object[])new Object[0]));
    }

    public void formatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        UIUtil.invokeLaterIfNeeded(() -> this.doFormatTestMessage(testsTotal, finishedTestsCount, failuresCount, ignoredTestsCount, duration, endTime));
    }

    private void doFormatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        boolean stopped;
        this.myState.clear();
        if (testsTotal == 0 && (testsTotal = finishedTestsCount) == 0) {
            return;
        }
        int passedCount = finishedTestsCount - failuresCount - ignoredTestsCount;
        if (duration == null || endTime == 0L) {
            this.formatCounts(failuresCount, ignoredTestsCount, passedCount, testsTotal);
            return;
        }
        boolean bl = stopped = finishedTestsCount != testsTotal;
        if (stopped) {
            this.myState.append("Stopped. ");
        }
        this.formatCounts(failuresCount, ignoredTestsCount, passedCount, testsTotal);
        this.myState.append(" \u2013 " + StringUtil.formatDuration((long)duration, (String)"\u2009"), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private void formatCounts(int failuresCount, int ignoredTestsCount, int passedCount, int testsTotal) {
        boolean something = false;
        if (failuresCount > 0) {
            this.myState.append("Tests failed: " + failuresCount, ERROR_ATTRIBUTES);
            something = true;
        } else {
            this.myState.append("Tests ");
        }
        if (passedCount > 0 || ignoredTestsCount + failuresCount == 0) {
            if (something) {
                this.myState.append(", ");
            }
            something = true;
            this.myState.append("passed: " + passedCount);
        }
        if (ignoredTestsCount > 0) {
            if (something) {
                this.myState.append(", ");
            }
            this.myState.append("ignored: " + ignoredTestsCount, IGNORE_ATTRIBUTES);
        }
        if (testsTotal > 0) {
            this.myState.append(" of " + TestStatusLine.getTestsTotalMessage(testsTotal), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public void setIndeterminate(boolean flag) {
        this.myProgressPanel.add((Component)this.myProgressBar, "North");
        this.myProgressBar.setIndeterminate(flag);
    }

    public void onTestsDone(@Nullable TestStateInfo.Magnitude info) {
        EdtInvocationManager.getInstance().invokeLater(() -> {
            this.myProgressPanel.remove(this.myProgressBar);
            if (info != null) {
                this.myState.setIcon(TestIconMapper.getToolbarIcon((TestStateInfo.Magnitude)info));
            }
        });
    }

    private static String getTestsTotalMessage(int testsTotal) {
        return testsTotal + " test" + (testsTotal > 1 ? "s" : "");
    }

    public void setStatusColor(Color color) {
        this.myProgressBar.setForeground(color);
    }

    public Color getStatusColor() {
        return this.myProgressBar.getForeground();
    }

    public void setFraction(double v) {
        int fraction = (int)(v * 100.0);
        this.myProgressBar.setValue(fraction);
    }

    @Deprecated
    public void setPreferredSize(boolean orientation) {
        JBDimension size = new JBDimension(orientation ? 150 : 450, -1);
        this.myProgressPanel.setMaximumSize((Dimension)size);
        this.myProgressPanel.setMinimumSize((Dimension)size);
        this.myProgressPanel.setPreferredSize((Dimension)size);
    }

    public void setText(String progressStatus_text) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myState.clear();
            this.myState.append(progressStatus_text);
        });
    }

    @NotNull
    public String getStateText() {
        return this.myState.toString();
    }
}

