/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsGroup
extends ActionGroup {
    private SMTRunnerConsoleProperties myProperties;

    public ImportTestsGroup() {
        super(() -> SmRunnerBundle.message("sm.test.runner.import.test.group.history", new Object[0]), () -> SmRunnerBundle.message("sm.test.runner.import.test.group.open.recent.session", new Object[0]), AllIcons.Vcs.History);
        this.setPopup(true);
    }

    public ImportTestsGroup(SMTRunnerConsoleProperties properties) {
        this();
        this.myProperties = properties;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            return EMPTY_ARRAY;
        }
        Collection<String> filePaths = TestHistoryConfiguration.getInstance(project).getFiles();
        File testHistoryRoot = TestStateStorage.getTestHistoryRoot(project);
        List fileNames = filePaths.stream().map(fileName -> new File(testHistoryRoot, (String)fileName)).filter(file2 -> file2.exists()).sorted((f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified())).collect(Collectors.toList());
        int historySize = fileNames.size();
        AnAction[] actions = new AnAction[historySize];
        for (int i2 = 0; i2 < historySize; ++i2) {
            actions[i2] = new ImportTestsFromHistoryAction(this.myProperties, project, ((File)fileNames.get(i2)).getName());
        }
        return actions;
    }
}

