/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.history.ImportTestOutputExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImportedToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @NotNull
    private final TestConsoleProperties myConsoleProperties;
    @NotNull
    private final File myFile;
    @NotNull
    private final ProcessHandler myHandler;

    public ImportedToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull File file2, @NotNull ProcessHandler handler2) {
        super(testFrameworkName, consoleProperties);
        this.myConsoleProperties = consoleProperties;
        this.myFile = file2;
        this.myHandler = handler2;
    }

    @Override
    public void onStartTesting() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.parseTestResults();
            this.myHandler.detachProcess();
        });
    }

    private void parseTestResults() {
        try {
            ImportedToGeneralTestEventsConverter.parseTestResults(() -> {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream(this.myFile), StandardCharsets.UTF_8);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }, this.getProcessor());
        }
        catch (IOException e) {
            String message = e.getMessage();
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myConsoleProperties.getProject(), (String)message, (String)SmRunnerBundle.message("sm.test.runner.imported.to.general.failed.to.parse.error.title", this.myFile.getName())));
        }
    }

    public static void parseTestResults(Supplier<? extends Reader> readerSupplier, GeneralTestEventsProcessor processor2) throws IOException {
        try (Reader reader = readerSupplier.get();){
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(reader), ImportTestOutputExtension.findHandler(readerSupplier, processor2));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }
}

