/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.HistoryTestRunnableState;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Getter;
import java.io.File;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportedTestRunnableState
implements RunProfileState,
HistoryTestRunnableState {
    private final AbstractImportTestsAction.ImportRunProfile myRunProfile;
    private final File myFile;

    public ImportedTestRunnableState(AbstractImportTestsAction.ImportRunProfile profile, File file2) {
        this.myRunProfile = profile;
        this.myFile = file2;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) {
        String frameworkName;
        RunProfile configuration;
        MyEmptyProcessHandler handler2 = new MyEmptyProcessHandler();
        SMTRunnerConsoleProperties properties = this.myRunProfile.getProperties();
        if (properties != null) {
            configuration = properties.getConfiguration();
            frameworkName = properties.getTestFrameworkName();
        } else {
            configuration = this.myRunProfile;
            frameworkName = "Import Test Results";
        }
        ImportedTestConsoleProperties consoleProperties = new ImportedTestConsoleProperties(properties, this.myFile, handler2, this.myRunProfile.getProject(), configuration, frameworkName, executor);
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(consoleProperties.getTestFrameworkName(), consoleProperties);
        JComponent component2 = console.getComponent();
        AbstractRerunFailedTestsAction rerunFailedTestsAction = null;
        if (component2 instanceof TestFrameworkRunningModel && (rerunFailedTestsAction = consoleProperties.createRerunFailedTestsAction(console)) != null) {
            rerunFailedTestsAction.setModelProvider((Getter<? extends TestFrameworkRunningModel>)((Getter)() -> (TestFrameworkRunningModel)((Object)component2)));
        }
        console.attachToProcess(handler2);
        DefaultExecutionResult result2 = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)handler2);
        if (rerunFailedTestsAction != null) {
            result2.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        }
        return result2;
    }

    private static class MyEmptyProcessHandler
    extends ProcessHandler {
        private MyEmptyProcessHandler() {
        }

        protected void destroyProcessImpl() {
        }

        protected void detachProcessImpl() {
            this.notifyProcessTerminated(0);
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

