/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.text.StringUtil;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestIgnoredEvent
extends TreeNodeEvent {
    private final String myIgnoreComment;
    private final String myStacktrace;

    public TestIgnoredEvent(@NotNull String testName, @NotNull String ignoreComment, @Nullable String stacktrace) {
        this(testName, null, ignoreComment, stacktrace);
    }

    public TestIgnoredEvent(@NotNull TestIgnored testIgnored, @Nullable String stacktrace) {
        this(testIgnored.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testIgnored), testIgnored.getIgnoreComment(), stacktrace);
    }

    public TestIgnoredEvent(@Nullable String name, @Nullable String id2, @Nullable String ignoreComment, @Nullable String stacktrace) {
        super(name, id2);
        this.myIgnoreComment = ignoreComment;
        this.myStacktrace = stacktrace;
    }

    @NotNull
    public String getIgnoreComment() {
        if (StringUtil.isEmpty((String)this.myIgnoreComment)) {
            return SmRunnerBundle.message("sm.test.runner.states.test.is.ignored", new Object[0]);
        }
        return this.myIgnoreComment;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        TestIgnoredEvent.append(buf, "ignoreComment", this.myIgnoreComment);
        TestIgnoredEvent.append(buf, "stacktrace", this.myStacktrace);
    }
}

